/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.editors.tab;

import org.eclipse.swt.graphics.GC;
import org.herac.tuxguitar.gui.editors.tab.MeasureCoords;
import org.herac.tuxguitar.gui.editors.tab.SongTrackCoords;
import org.herac.tuxguitar.gui.editors.tab.layout.ViewLayout;

public class LyricPainter {
    private SongTrackCoords trackCoords;
    private String[] lyricBeats;
    private int from;
    private int height;
    int nextIndex = 0;

    public LyricPainter(SongTrackCoords songTrackCoords) {
        this.trackCoords = songTrackCoords;
        this.update();
    }

    public void update() {
        this.lyricBeats = this.trackCoords.getTrack().getLyrics().getLyricBeats();
        this.from = this.trackCoords.getTrack().getLyrics().getFrom();
        this.height = 0;
        if (this.lyricBeats != null && this.lyricBeats.length > 0) {
            this.height = 10;
        }
    }

    public void start() {
        this.start(0);
    }

    public void start(int n) {
        this.nextIndex = n;
    }

    public void setCurrentMeasure(MeasureCoords measureCoords) {
        if (measureCoords.getMeasure().getNumber() >= this.from) {
            measureCoords.setLyricBeatIndex(this.nextIndex);
            this.nextIndex += measureCoords.getBeatPositions().size();
        } else {
            measureCoords.setLyricBeatIndex(-1);
            this.start();
        }
    }

    public void paintCurrentNoteBeats(GC gC, ViewLayout viewLayout, MeasureCoords measureCoords, int n, int n2) {
        int n3 = measureCoords.getLyricBeatIndex();
        if (this.lyricBeats != null && n3 >= 0 && n3 < this.lyricBeats.length) {
            for (int i = 0; i < measureCoords.getBeatPositions().size(); ++i) {
                String string;
                MeasureCoords.BeatPosition beatPosition = (MeasureCoords.BeatPosition)measureCoords.getBeatPositions().get(i);
                if (n3 + i >= this.lyricBeats.length || (string = this.lyricBeats[n3 + i]).trim().length() <= 0) continue;
                int n4 = n + beatPosition.getPosX();
                viewLayout.setLyricStyle(gC);
                if (viewLayout.isPlayModeEnabled() && beatPosition.isPlayingBeat()) {
                    viewLayout.setPlayNoteColor(gC);
                }
                gC.drawString(string, n4 + 13, n2 + measureCoords.getTs().getPosition(13));
                viewLayout.setTabNoteColor(gC);
            }
        }
    }

    public int getHeight() {
        return this.height;
    }
}

