/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.editors.tab;

import java.util.List;
import org.eclipse.swt.graphics.GC;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.editors.tab.MeasureComponent;
import org.herac.tuxguitar.gui.editors.tab.MeasureCoords;
import org.herac.tuxguitar.gui.editors.tab.NoteCoords;
import org.herac.tuxguitar.gui.editors.tab.SilenceCoords;
import org.herac.tuxguitar.gui.editors.tab.SongCoords;
import org.herac.tuxguitar.gui.editors.tab.SongTrackCoords;
import org.herac.tuxguitar.gui.editors.tab.Tablature;
import org.herac.tuxguitar.gui.editors.tab.TablatureUtil;
import org.herac.tuxguitar.gui.editors.tab.layout.ViewLayout;
import org.herac.tuxguitar.song.managers.SongManager;
import org.herac.tuxguitar.song.models.Duration;
import org.herac.tuxguitar.song.models.InstrumentString;
import org.herac.tuxguitar.song.models.Note;

public class Caret {
    private Tablature tablature;
    private SongManager songManager;
    private SongCoords songCoords;
    private SongTrackCoords selectedTrack;
    private MeasureCoords selectedMeasure;
    private MeasureComponent selectedComponent;
    private Duration selectedDuration;
    private long position;
    private int string;
    private boolean changes;
    private int velocity;
    private Note selectedNote;

    public Caret(Tablature tablature, SongManager songManager, SongCoords songCoords) {
        this.tablature = tablature;
        this.songManager = songManager;
        this.songCoords = songCoords;
        this.selectedDuration = new Duration(4);
        this.string = 1;
        this.velocity = 95;
        this.changes = false;
    }

    public synchronized void update() {
        int n = this.selectedTrack != null ? this.selectedTrack.getTrack().getNumber() : 1;
        this.update(n, this.position, this.string);
    }

    public synchronized void update(int n) {
        this.update(n, this.position, this.string);
    }

    public synchronized void update(int n, long l, int n2) {
        this.update(n, l, n2, this.getVelocity());
    }

    public synchronized void update(int n, long l, int n2, int n3) {
        l = TuxGuitar.instance().getPlayer().isRunning() ? TuxGuitar.instance().getPlayer().getTickPosition() : l;
        SongTrackCoords songTrackCoords = this.findTrack(n);
        MeasureCoords measureCoords = this.findMeasure(l, songTrackCoords);
        MeasureComponent measureComponent = this.findComponent(l, n2, measureCoords);
        if (songTrackCoords != null && measureCoords != null && measureComponent != null) {
            this.moveTo(songTrackCoords, measureCoords, measureComponent, n2);
        }
        this.setVelocity(n3);
    }

    public void moveTo(SongTrackCoords songTrackCoords, MeasureCoords measureCoords, MeasureComponent measureComponent, int n) {
        this.selectedTrack = songTrackCoords;
        this.selectedMeasure = measureCoords;
        this.selectedComponent = measureComponent;
        this.string = n;
        this.updatePosition();
        this.updateDuration();
        this.checkString();
        this.updateNote();
        this.checkTransport();
        this.setChanges(true);
    }

    private SongTrackCoords findTrack(int n) {
        SongTrackCoords songTrackCoords = this.songCoords.getTrack(n);
        if (songTrackCoords == null) {
            songTrackCoords = this.songCoords.getFirstTrack();
        }
        return songTrackCoords;
    }

    private MeasureCoords findMeasure(long l, SongTrackCoords songTrackCoords) {
        MeasureCoords measureCoords = null;
        if (songTrackCoords != null && (measureCoords = songTrackCoords.getMeasureCoords(l)) == null) {
            measureCoords = songTrackCoords.getFirstMeasure();
        }
        return measureCoords;
    }

    private MeasureComponent findComponent(long l, int n, MeasureCoords measureCoords) {
        MeasureComponent measureComponent = null;
        if (measureCoords != null && (measureComponent = measureCoords.getComponentOrSilence(l, n)) == null) {
            measureComponent = measureCoords.getFirstComponent();
        }
        return measureComponent;
    }

    public synchronized void goToTickPosition() {
        if (!this.songManager.isAtPosition(this.selectedMeasure.getMeasure().getHeader(), TuxGuitar.instance().getPlayer().getTickPosition())) {
            this.update(this.selectedTrack.getTrack().getNumber(), TuxGuitar.instance().getPlayer().getTickPosition(), this.string);
            this.setChanges(true);
        }
    }

    public void paintCaret(ViewLayout viewLayout, GC gC) {
        if (this.selectedMeasure != null && this.selectedComponent != null) {
            long l = this.selectedComponent.getStart();
            int n = TablatureUtil.getStartPosition(this.selectedMeasure.getMeasure(), l, this.selectedMeasure.getQuarterSpan()) + this.selectedComponent.getSpan();
            int n2 = 15 + this.selectedMeasure.getFirstNoteSpan();
            if (viewLayout.isTablatureEnabled()) {
                int n3 = this.tablature.getViewLayout().getStringSpan();
                int n4 = this.selectedMeasure.getPosX() + n2 + n + 6;
                int n5 = this.selectedMeasure.getPosY() + this.selectedMeasure.getTs().getPosition(12) + (this.string * n3 - n3) - 7;
                int n6 = 14;
                int n7 = 14;
                gC.drawRectangle(n4, n5, n6, n7);
            }
            if (viewLayout.isScoreEnabled()) {
                // empty if block
            }
        }
    }

    public boolean moveRight() {
        if (this.getSelectedComponent() != null) {
            MeasureCoords measureCoords = this.getMeasureCoords();
            MeasureComponent measureComponent = this.getMeasureCoords().getNextComponent(this.getSelectedComponent());
            if (measureComponent == null) {
                measureCoords = this.getSongTrackCoords().getNextMeasure(this.getMeasureCoords());
                if (measureCoords == null) {
                    return false;
                }
                measureComponent = measureCoords.getFirstComponent();
            }
            this.moveTo(this.getSongTrackCoords(), measureCoords, measureComponent, this.getStringNumber());
        }
        return true;
    }

    public void moveLeft() {
        if (this.getSelectedComponent() != null) {
            MeasureCoords measureCoords = this.getMeasureCoords();
            MeasureComponent measureComponent = this.getMeasureCoords().getPreviousComponent(this.getSelectedComponent());
            if (measureComponent == null) {
                measureCoords = this.getSongTrackCoords().getPrevMeasure(this.getMeasureCoords());
                if (measureCoords == null) {
                    return;
                }
                measureComponent = measureCoords.getLastComponent();
            }
            this.moveTo(this.getSongTrackCoords(), measureCoords, measureComponent, this.getStringNumber());
        }
    }

    private void updateDuration() {
        if (this.selectedComponent != null) {
            boolean bl = false;
            for (MeasureComponent measureComponent : this.getMeasureCoords().getComponentsBeforeEnd(this.getSelectedComponent().getStart())) {
                if (!(measureComponent instanceof NoteCoords)) continue;
                bl = true;
                break;
            }
            if (bl) {
                if (this.selectedComponent instanceof SilenceCoords) {
                    long l = this.selectedComponent.getDuration().getTime();
                    MeasureComponent measureComponent = this.getMeasureCoords().getNextComponent(this.selectedComponent);
                    while (measureComponent != null && measureComponent instanceof SilenceCoords) {
                        l += measureComponent.getDuration().getTime();
                        measureComponent = this.getMeasureCoords().getNextComponent(measureComponent);
                    }
                    if (this.selectedDuration.getTime() > l) {
                        this.selectedDuration = (Duration)this.selectedComponent.getDuration().clone();
                    }
                } else {
                    this.selectedDuration = (Duration)this.selectedComponent.getDuration().clone();
                }
            }
        }
    }

    public void moveUp() {
        int n = this.selectedTrack.getTrack().stringCount();
        int n2 = (this.string - 2 + n) % n + 1;
        this.setStringNumber(n2);
    }

    public void moveDown() {
        int n = this.selectedTrack.getTrack().stringCount();
        int n2 = this.string % n + 1;
        this.setStringNumber(n2);
    }

    public void setStringNumber(int n) {
        this.string = n;
        this.updateNote();
    }

    public int getStringNumber() {
        return this.string;
    }

    public long getPosition() {
        return this.position;
    }

    public SongCoords getSongCoords() {
        return this.songCoords;
    }

    public MeasureCoords getMeasureCoords() {
        return this.selectedMeasure;
    }

    public SongTrackCoords getSongTrackCoords() {
        return this.selectedTrack;
    }

    public MeasureComponent getSelectedComponent() {
        return this.selectedComponent;
    }

    public Duration getDuration() {
        return this.selectedDuration;
    }

    public void setSelectedDuration(Duration duration) {
        this.selectedDuration = duration;
    }

    public InstrumentString getSelectedString() {
        List list = this.selectedTrack.getTrack().getStrings();
        for (InstrumentString instrumentString : list) {
            if (instrumentString.getNumber() != this.string) continue;
            return instrumentString;
        }
        return null;
    }

    public void changeDuration(Duration duration) {
        this.getSongCoords().getSongManager().getMeasureManager().changeDuration(this.getMeasureCoords().getMeasure(), this.getSelectedComponent().getComponent(), duration);
        this.setChanges(true);
    }

    private void updatePosition() {
        this.position = this.getSelectedComponent().getStart();
    }

    private void checkString() {
        int n = this.getSongTrackCoords().getTrack().getStrings().size();
        if (this.string > n) {
            this.string = n;
        }
    }

    private void checkTransport() {
        TuxGuitar.instance().getTransport().gotoMeasure(this.getMeasureCoords().getMeasure().getHeader());
    }

    public boolean hasChanges() {
        return this.changes;
    }

    public void setChanges(boolean bl) {
        this.changes = bl;
    }

    public int getVelocity() {
        return this.velocity;
    }

    public void setVelocity(int n) {
        this.velocity = n;
    }

    private void updateNote() {
        this.selectedNote = this.songManager.getMeasureManager().getNote(this.getMeasureCoords().getMeasure(), this.getPosition(), this.getSelectedString().getNumber());
    }

    public Note getSelectedNote() {
        return this.selectedNote;
    }
}

