/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.editors.tab;

import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;

public class CacheImage {
    private Device device;
    private Image cache;
    private GC gc;
    private int width;
    private int height;

    public CacheImage(Device device) {
        this(device, 1, 1);
    }

    public CacheImage(Device device, int n, int n2) {
        this.device = device;
        this.resizeCache(n, n2);
    }

    private void resizeCache(int n, int n2) {
        if (this.width != n || this.height != n2) {
            this.dispose();
            this.cache = new Image(this.device, n, n2);
        } else {
            if (this.cache == null || this.cache.isDisposed()) {
                this.cache = new Image(this.device, n, n2);
            }
            this.getGC().fillRectangle(new Rectangle(0, 0, n, n2));
        }
        this.width = n;
        this.height = n2;
    }

    public void setSize(int n, int n2) {
        this.resizeCache(n, n2);
    }

    public GC getGC() {
        if (this.gc == null || this.gc.isDisposed()) {
            this.gc = new GC(this.cache);
        }
        return this.gc;
    }

    public void paintImage(GC gC, int n, int n2) {
        gC.drawImage(this.cache, n, n2);
    }

    public Image getImage() {
        return this.cache;
    }

    public void dispose() {
        if (this.cache != null && !this.cache.isDisposed()) {
            this.cache.dispose();
        }
        if (this.gc != null && !this.gc.isDisposed()) {
            this.gc.dispose();
        }
    }

    public boolean isDisposed() {
        return this.cache == null || this.cache.isDisposed();
    }
}

