/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.editors.piano;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.herac.tuxguitar.gui.SystemImages;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.editors.tab.Caret;
import org.herac.tuxguitar.gui.editors.tab.MeasureComponent;
import org.herac.tuxguitar.gui.editors.tab.NoteCoords;
import org.herac.tuxguitar.gui.undo.undoables.measure.UndoableMeasureGeneric;
import org.herac.tuxguitar.song.managers.SongManager;
import org.herac.tuxguitar.song.models.Duration;
import org.herac.tuxguitar.song.models.InstrumentString;
import org.herac.tuxguitar.song.models.Note;
import org.herac.tuxguitar.song.models.NoteEffect;

public class Piano
extends Composite {
    private static final boolean[] TYPE_NOTES = new boolean[]{true, false, true, false, true, true, false, true, false, true, false, true};
    private static final int NATURAL_NOTES = 7;
    private static final int MAX_OCTAVES = 8;
    private static final int NATURAL_WIDTH = 15;
    private static final int SHARP_WIDTH = 8;
    private static final int NATURAL_HEIGHT = 60;
    private static final int SHARP_HEIGHT = 40;
    private static final int MOUSE_MOVE_DELAY = 10;
    private PianoListener listener;
    private Image image;
    private Composite pianoComposite;
    private Composite toolComposite;
    private Label durationLabel;
    private Button scale;
    private List components;
    private long lastMouseMoveTime;
    private boolean scaleChanges;

    public Piano(Composite composite, int n) {
        super(composite, n);
        this.setLayout(new GridLayout());
        this.setLayoutData(new GridData(4, 4, true, true));
        this.listener = new PianoListener();
        this.components = new ArrayList();
        this.initToolBar();
        this.makePiano();
    }

    private void initToolBar() {
        GridLayout gridLayout = new GridLayout();
        gridLayout.makeColumnsEqualWidth = false;
        gridLayout.numColumns = 0;
        this.toolComposite = new Composite(this, 0);
        ++gridLayout.numColumns;
        Button button = new Button(this.toolComposite, 16388);
        button.addSelectionListener(TuxGuitar.instance().getAction("action.caret.go-left"));
        ++gridLayout.numColumns;
        Button button2 = new Button(this.toolComposite, 131076);
        button2.addSelectionListener(TuxGuitar.instance().getAction("action.caret.go-right"));
        ++gridLayout.numColumns;
        this.makeToolSeparator(this.toolComposite);
        ++gridLayout.numColumns;
        Button button3 = new Button(this.toolComposite, 132);
        button3.addSelectionListener(TuxGuitar.instance().getAction("action.note.duration.decrement-duration"));
        ++gridLayout.numColumns;
        this.durationLabel = new Label(this.toolComposite, 2048);
        this.durationLabel.setImage(this.getDurationImage());
        ++gridLayout.numColumns;
        Button button4 = new Button(this.toolComposite, 1028);
        button4.addSelectionListener(TuxGuitar.instance().getAction("action.note.duration.increment-duration"));
        ++gridLayout.numColumns;
        this.makeToolSeparator(this.toolComposite);
        ++gridLayout.numColumns;
        this.scale = new Button(this.toolComposite, 8);
        this.scale.setText(TuxGuitar.getProperty("scale"));
        this.scale.addSelectionListener(TuxGuitar.instance().getAction("action.tools.scale"));
        this.toolComposite.setLayout(gridLayout);
        this.toolComposite.setLayoutData(new GridData(4, 128, true, true));
    }

    private void makeToolSeparator(Composite composite) {
        Label label = new Label(composite, 2);
        label.setLayoutData(new GridData(20, 20));
    }

    private Image getDurationImage() {
        Duration duration = (Duration)TuxGuitar.instance().getTablatureEditor().getTablature().getCaret().getDuration().clone();
        return SystemImages.getDuration(duration.getValue());
    }

    private void makePiano() {
        Point point = new Point(0, 0);
        this.image = this.makePianoImage();
        this.pianoComposite = new Composite(this, 0x20000800);
        this.pianoComposite.setLayout(new GridLayout());
        this.pianoComposite.setLayoutData(new GridData(840, 60));
        this.pianoComposite.addPaintListener(this.listener);
        this.pianoComposite.addMouseListener(this.listener);
    }

    private Image makePianoImage() {
        Image image = new Image((Device)this.getDisplay(), 840, 60);
        GC gC = new GC(image);
        int n = 0;
        int n2 = 0;
        gC.setBackground(this.getDisplay().getSystemColor(1));
        gC.fillRectangle(n, n2, 840, 60);
        for (int i = 0; i < 8 * TYPE_NOTES.length; ++i) {
            if (TYPE_NOTES[i % TYPE_NOTES.length]) {
                gC.setForeground(this.getDisplay().getSystemColor(2));
                gC.drawRectangle(n, n2, 15, 60);
                n += 15;
                continue;
            }
            gC.setBackground(this.getDisplay().getSystemColor(2));
            gC.fillRectangle(n - 4, n2, 8, 40);
        }
        this.paintScale(gC);
        gC.dispose();
        return image;
    }

    private void paintScale(GC gC) {
        gC.setBackground(this.getDisplay().getSystemColor(3));
        gC.setForeground(this.getDisplay().getSystemColor(3));
        int n = 0;
        boolean bl = false;
        for (int i = 0; i < 8 * TYPE_NOTES.length; ++i) {
            int n2 = 0;
            if (TYPE_NOTES[i % TYPE_NOTES.length]) {
                n2 = 15;
                if (i > 0 && !TYPE_NOTES[(i - 1) % TYPE_NOTES.length]) {
                    n2 -= 4;
                }
                if (!TYPE_NOTES[(i + 1) % TYPE_NOTES.length]) {
                    n2 -= 4;
                }
            } else {
                n2 = 8;
            }
            if (TuxGuitar.instance().getScaleManager().getScale().getNote(i)) {
                int n3;
                if (TYPE_NOTES[i % TYPE_NOTES.length]) {
                    n3 = n;
                    if (i > 0 && !TYPE_NOTES[(i - 1) % TYPE_NOTES.length]) {
                        n3 -= 4;
                    }
                    int n4 = 8;
                    gC.fillRectangle(n3 + 1 + (15 - n4) / 2, 60 - n4 - (15 - n4) / 2, n4, n4);
                } else {
                    n3 = n2 - 2;
                    gC.fillRectangle(n + 1, 33, 6, 6);
                }
            }
            n += n2;
        }
    }

    private void paintNote(GC gC, int n) {
        gC.setBackground(this.getDisplay().getSystemColor(15));
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < 8 * TYPE_NOTES.length; ++i) {
            int n4 = 0;
            if (TYPE_NOTES[i % TYPE_NOTES.length]) {
                n4 = 15;
                if (i > 0 && !TYPE_NOTES[(i - 1) % TYPE_NOTES.length]) {
                    n4 -= 4;
                }
                if (!TYPE_NOTES[(i + 1) % TYPE_NOTES.length]) {
                    n4 -= 4;
                }
            } else {
                n4 = 8;
            }
            if (i == n) {
                if (TYPE_NOTES[i % TYPE_NOTES.length]) {
                    gC.fillRectangle(n2 + 1, n3 + 1, n4 - 1, 40);
                    int n5 = n2;
                    if (i > 0 && !TYPE_NOTES[(i - 1) % TYPE_NOTES.length]) {
                        n5 -= 4;
                    }
                    gC.fillRectangle(n5 + 1, n3 + 40 + 1, 14, 19);
                } else {
                    gC.fillRectangle(n2 + 1, n3 + 1, n4 - 1, 39);
                }
            }
            n2 += n4;
        }
    }

    private int getSelection(Point point) {
        int n = 0;
        for (int i = 0; i < 8 * TYPE_NOTES.length; ++i) {
            int n2 = 0;
            if (TYPE_NOTES[i % TYPE_NOTES.length]) {
                n2 = 15;
                if (i > 0 && !TYPE_NOTES[(i - 1) % TYPE_NOTES.length]) {
                    n2 -= 4;
                }
                if (!TYPE_NOTES[(i + 1) % TYPE_NOTES.length]) {
                    n2 -= 4;
                }
            } else {
                n2 = 8;
            }
            if (point.x >= n && point.x < n + n2) {
                return i;
            }
            n += n2;
        }
        return -1;
    }

    private void hit(int n, int n2) {
        int n3 = this.getSelection(new Point(n, n2));
        if (!this.removeNote(n3)) {
            this.addNote(n3);
        }
    }

    private boolean removeNote(int n) {
        for (MeasureComponent measureComponent : this.components) {
            NoteCoords noteCoords;
            if (!(measureComponent instanceof NoteCoords) || (noteCoords = (NoteCoords)measureComponent).getRealValue() != n) continue;
            UndoableMeasureGeneric undoableMeasureGeneric = UndoableMeasureGeneric.startUndo();
            Caret caret = TuxGuitar.instance().getTablatureEditor().getTablature().getCaret();
            SongManager songManager = TuxGuitar.instance().getSongManager();
            songManager.getMeasureManager().removeNote(caret.getMeasureCoords().getMeasure(), noteCoords.getNote());
            TuxGuitar.instance().getTablatureEditor().getUndoManager().addEdit(undoableMeasureGeneric.endUndo());
            return true;
        }
        return false;
    }

    private boolean addNote(int n) {
        Caret caret = TuxGuitar.instance().getTablatureEditor().getTablature().getCaret();
        List list = caret.getSongTrackCoords().getTrack().getStrings();
        for (int i = 0; i < list.size(); ++i) {
            Object object2;
            InstrumentString instrumentString = (InstrumentString)list.get(i);
            if (n < instrumentString.getValue()) continue;
            boolean bl = true;
            for (Object object2 : this.components) {
                if (!(object2 instanceof NoteCoords) || ((NoteCoords)object2).getNote().getString() != instrumentString.getNumber()) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            object2 = UndoableMeasureGeneric.startUndo();
            Duration duration = (Duration)caret.getDuration().clone();
            Note note = new Note(n - instrumentString.getValue(), caret.getPosition(), duration, caret.getVelocity(), instrumentString.getNumber(), false, new NoteEffect());
            SongManager songManager = TuxGuitar.instance().getSongManager();
            songManager.getMeasureManager().addNote(caret.getMeasureCoords().getMeasure(), note);
            TuxGuitar.instance().getTablatureEditor().getUndoManager().addEdit(((UndoableMeasureGeneric)object2).endUndo());
            caret.getMeasureCoords().playBeat(note.getStart());
            return true;
        }
        return false;
    }

    private void afterAction() {
        TuxGuitar.instance().getTablatureEditor().getTablature().getViewLayout().fireUpdate(TuxGuitar.instance().getTablatureEditor().getTablature().getCaret().getMeasureCoords().getMeasure().getNumber(), false);
        TuxGuitar.instance().redraw();
        TuxGuitar.instance().updateCache(true);
    }

    public boolean isScaleChanges() {
        return this.scaleChanges;
    }

    public void setScaleChanges(boolean bl) {
        this.scaleChanges = bl;
    }

    private void updateEditor() {
        if (this.isVisible()) {
            if (this.isScaleChanges()) {
                this.image.dispose();
                this.image = this.makePianoImage();
            }
            SongManager songManager = TuxGuitar.instance().getSongManager();
            this.components = TuxGuitar.instance().getPlayer().isRunning() ? TuxGuitar.instance().getEditorCache().getPlayingComponents() : TuxGuitar.instance().getEditorCache().getCaretComponents();
        }
    }

    public void redraw() {
        if (!super.isDisposed()) {
            super.redraw();
            this.pianoComposite.redraw();
            this.durationLabel.setImage(this.getDurationImage());
        }
    }

    public void redrawPlayingMode() {
        if (!super.isDisposed()) {
            this.pianoComposite.redraw();
        }
    }

    public void dispose() {
        super.dispose();
        this.image.dispose();
    }

    public void loadProperties() {
        this.scale.setText(TuxGuitar.getProperty("scale"));
        this.layout();
    }

    private class PianoListener
    implements PaintListener,
    MouseListener {
        private PianoListener() {
        }

        public void paintControl(PaintEvent paintEvent) {
            Piano.this.updateEditor();
            paintEvent.gc.drawImage(Piano.this.image, 0, 0);
            for (MeasureComponent measureComponent : Piano.this.components) {
                if (!(measureComponent instanceof NoteCoords)) continue;
                NoteCoords noteCoords = (NoteCoords)measureComponent;
                Piano.this.paintNote(paintEvent.gc, noteCoords.getRealValue());
            }
            paintEvent.gc.dispose();
        }

        public void mouseUp(MouseEvent mouseEvent) {
            if (mouseEvent.button == 1) {
                Piano.this.hit(mouseEvent.x, mouseEvent.y);
                Piano.this.afterAction();
            } else {
                TuxGuitar.instance().getAction("action.caret.go-right").process(mouseEvent);
            }
        }

        public void mouseDoubleClick(MouseEvent mouseEvent) {
        }

        public void mouseDown(MouseEvent mouseEvent) {
        }
    }
}

