/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.editors.fretboard;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.herac.tuxguitar.gui.SystemImages;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.editors.TablatureEditor;
import org.herac.tuxguitar.gui.editors.tab.Caret;
import org.herac.tuxguitar.gui.editors.tab.MeasureComponent;
import org.herac.tuxguitar.gui.editors.tab.NoteCoords;
import org.herac.tuxguitar.gui.undo.undoables.measure.UndoableMeasureGeneric;
import org.herac.tuxguitar.song.managers.SongManager;
import org.herac.tuxguitar.song.models.Duration;
import org.herac.tuxguitar.song.models.InstrumentString;
import org.herac.tuxguitar.song.models.Note;
import org.herac.tuxguitar.song.models.NoteEffect;
import org.herac.tuxguitar.song.models.SongTrack;

public class FretBoard
extends Composite {
    public static final int MAX_FRETS = 24;
    public static final int TOP_SPAN = 10;
    public static final int BOTTOM_SPAN = 10;
    private static final int STRING_SPAN = TuxGuitar.instance().getConfig().getIntConfigValue("fretboard.string-span");
    private static final Color COLOR_BACKGROUND = new Color(TuxGuitar.instance().getDisplay(), 255, 255, 255);
    private static final Color COLOR_STRING = new Color(TuxGuitar.instance().getDisplay(), 227, 217, 217);
    private static final String[] NOTE_NAMES = new String[]{"C", "C#", "D", "D#", "E", "F", "F#", "G", "G#", "A", "A#", "B"};
    private TablatureEditor editor;
    private FretBoardListener listener;
    private Composite toolComposite;
    private Composite fretBoardComposite;
    private Label durationLabel;
    private Combo handSelector;
    private Button scale;
    private Image fretBoard;
    private List components;
    private int[] frets;
    private int[] strings;
    private int fretSpan;
    private boolean changes;
    private Point lastSize;

    public FretBoard(Composite composite, TablatureEditor tablatureEditor) {
        super(composite, 0);
        this.setLayout(new FormLayout());
        this.components = new ArrayList();
        this.listener = new FretBoardListener();
        this.editor = tablatureEditor;
        this.initToolBar();
        this.initEditor();
        this.layout(this.getDisplay().getBounds().width, 1);
    }

    private void initToolBar() {
        FormData formData = new FormData();
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        formData.top = new FormAttachment(0, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.makeColumnsEqualWidth = false;
        gridLayout.numColumns = 0;
        gridLayout.marginWidth = 0;
        this.toolComposite = new Composite(this, 0);
        ++gridLayout.numColumns;
        Button button = new Button(this.toolComposite, 16388);
        button.addSelectionListener(TuxGuitar.instance().getAction("action.caret.go-left"));
        ++gridLayout.numColumns;
        Button button2 = new Button(this.toolComposite, 131076);
        button2.addSelectionListener(TuxGuitar.instance().getAction("action.caret.go-right"));
        ++gridLayout.numColumns;
        this.makeToolSeparator(this.toolComposite);
        ++gridLayout.numColumns;
        Button button3 = new Button(this.toolComposite, 132);
        button3.addSelectionListener(TuxGuitar.instance().getAction("action.note.duration.decrement-duration"));
        ++gridLayout.numColumns;
        this.durationLabel = new Label(this.toolComposite, 2048);
        this.durationLabel.setImage(this.getDurationImage());
        ++gridLayout.numColumns;
        Button button4 = new Button(this.toolComposite, 1028);
        button4.addSelectionListener(TuxGuitar.instance().getAction("action.note.duration.increment-duration"));
        ++gridLayout.numColumns;
        this.makeToolSeparator(this.toolComposite);
        ++gridLayout.numColumns;
        this.handSelector = new Combo(this.toolComposite, 12);
        this.handSelector.add(TuxGuitar.getProperty("fretboard.right-mode"));
        this.handSelector.add(TuxGuitar.getProperty("fretboard.left-mode"));
        this.handSelector.select(0);
        this.handSelector.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                int n = FretBoard.this.handSelector.getSelectionIndex();
                if (n == 0) {
                    FretBoard.this.initFrets(10, 1);
                } else {
                    FretBoard.this.initFrets(10, 2);
                }
                FretBoard.this.setChanges(true);
                FretBoard.this.fretBoardComposite.redraw();
            }
        });
        ++gridLayout.numColumns;
        this.makeToolSeparator(this.toolComposite);
        ++gridLayout.numColumns;
        this.scale = new Button(this.toolComposite, 8);
        this.scale.setText(TuxGuitar.getProperty("scale"));
        this.scale.addSelectionListener(TuxGuitar.instance().getAction("action.tools.scale"));
        this.toolComposite.setLayoutData(formData);
        this.toolComposite.setLayout(gridLayout);
    }

    private void makeToolSeparator(Composite composite) {
        Label label = new Label(composite, 2);
        label.setLayoutData(new GridData(20, 20));
    }

    private void initEditor() {
        this.lastSize = new Point(0, 0);
        FormData formData = new FormData();
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        formData.top = new FormAttachment(this.toolComposite, 0);
        formData.bottom = new FormAttachment(100, 0);
        this.fretBoardComposite = new Composite(this, 0x20000800);
        this.fretBoardComposite.setLayoutData(formData);
        this.fretBoardComposite.setBackground(COLOR_BACKGROUND);
        this.fretBoardComposite.addMouseListener(this.listener);
        this.fretBoardComposite.addPaintListener(this.listener);
    }

    private Image getDurationImage() {
        Duration duration = (Duration)this.editor.getTablature().getCaret().getDuration().clone();
        return SystemImages.getDuration(duration.getValue());
    }

    private void calculateFretSpan(int n) {
        this.fretSpan = n / 24;
        int n2 = 0;
        for (int i = 0; i < 24; ++i) {
            n2 += i * 2;
        }
        this.fretSpan += n2 / 24 + 2;
    }

    private void disposeFretBoardImage() {
        if (this.fretBoard != null && !this.fretBoard.isDisposed()) {
            this.fretBoard.dispose();
        }
    }

    private void initFrets(int n, int n2) {
        block3: {
            int n3;
            block2: {
                this.frets = new int[24];
                n3 = n;
                if (n2 != 1) break block2;
                for (int i = 0; i < this.frets.length; ++i) {
                    this.frets[i] = n3;
                    n3 += this.fretSpan - (i + 1) * 2;
                }
                break block3;
            }
            if (n2 != 2) break block3;
            for (int i = this.frets.length - 1; i >= 0; --i) {
                this.frets[i] = n3;
                n3 += this.fretSpan - i * 2;
            }
        }
    }

    private void initStrings(int n) {
        int n2 = 10;
        this.strings = new int[n];
        for (int i = 0; i < this.strings.length; ++i) {
            this.strings[i] = n2 + STRING_SPAN * i;
        }
    }

    private void updateEditor() {
        if (this.isVisible()) {
            SongManager songManager = TuxGuitar.instance().getSongManager();
            this.components = TuxGuitar.instance().getPlayer().isRunning() ? TuxGuitar.instance().getEditorCache().getPlayingComponents() : TuxGuitar.instance().getEditorCache().getCaretComponents();
            if (this.strings.length != this.getStringCount()) {
                this.disposeFretBoardImage();
                this.initStrings(this.getStringCount());
                this.lastSize.y = 0;
            }
            int n = this.getClientArea().width;
            int n2 = this.getClientArea().height;
            if (this.lastSize.x != n || this.hasChanges()) {
                this.layout(this.getClientArea().width, this.handSelector.getSelectionIndex() + 1);
            }
            if (this.lastSize.y != n2) {
                TuxGuitar.instance().getFretBoardEditor().showFretBoard();
            }
            this.lastSize.x = n;
            this.lastSize.y = n2;
        }
    }

    private void paintFretBoard(GC gC) {
        if (this.fretBoard == null || this.fretBoard.isDisposed()) {
            int n;
            this.fretBoard = new Image((Device)this.getDisplay(), this.getClientArea().width, STRING_SPAN * (this.strings.length - 1) + 10 + 10);
            GC gC2 = new GC(this.fretBoard);
            gC2.setBackground(this.getDisplay().getSystemColor(2));
            gC2.fillRectangle(this.getClientArea());
            Image image = SystemImages.FRETBOARD_FRET_IMAGE;
            Image image2 = SystemImages.FRETBOARD_FIRST_FRET_IMAGE;
            gC2.drawImage(image2, 0, 0, image2.getBounds().width, image2.getBounds().height, this.frets[0] - 5, this.strings[0] - 5, image2.getBounds().width, this.strings[this.strings.length - 1]);
            this.paintFretPoints(gC2, 0);
            for (n = 1; n < this.frets.length; ++n) {
                gC2.drawImage(image, 0, 0, image.getBounds().width, image.getBounds().height, this.frets[n], this.strings[0] - 5, image.getBounds().width, this.strings[this.strings.length - 1]);
                this.paintFretPoints(gC2, n);
            }
            for (n = 0; n < this.strings.length; ++n) {
                gC2.setForeground(COLOR_STRING);
                if (n > 2) {
                    gC2.setLineWidth(2);
                }
                gC2.drawLine(this.frets[0], this.strings[n], this.frets[this.frets.length - 1], this.strings[n]);
            }
            this.paintScale(gC2);
        }
        gC.drawImage(this.fretBoard, 0, 0);
    }

    private void paintFretPoints(GC gC, int n) {
        gC.setBackground(this.getDisplay().getSystemColor(15));
        if (n + 1 < this.frets.length) {
            int n2;
            for (n2 = n + 1; n2 >= 12; n2 -= 12) {
            }
            if (n2 == 0) {
                gC.setLineWidth(10);
                int n3 = this.getOvalSize();
                int n4 = this.frets[n] + (this.frets[n + 1] - this.frets[n]) / 2;
                int n5 = this.strings[0] + (this.strings[this.strings.length - 1] - this.strings[0]) / 2 - STRING_SPAN;
                int n6 = this.strings[0] + (this.strings[this.strings.length - 1] - this.strings[0]) / 2 + STRING_SPAN;
                gC.fillOval(n4 - n3 / 2, n5 - n3 / 2, n3, n3);
                gC.fillOval(n4 - n3 / 2, n6 - n3 / 2, n3, n3);
                gC.setLineWidth(1);
            } else if (n2 == 3 || n2 == 5 || n2 == 7 || n2 == 9) {
                gC.setLineWidth(10);
                int n7 = this.getOvalSize();
                int n8 = this.frets[n] + (this.frets[n + 1] - this.frets[n]) / 2;
                int n9 = this.strings[0] + (this.strings[this.strings.length - 1] - this.strings[0]) / 2;
                gC.fillOval(n8 - n7 / 2, n9 - n7 / 2, n7, n7);
                gC.setLineWidth(1);
            }
        }
    }

    private void paintScale(GC gC) {
        SongTrack songTrack = this.editor.getTablature().getCaret().getSongTrackCoords().getTrack();
        Font font = new Font((Device)this.getDisplay(), new FontData("Sans", 8, 1));
        gC.setBackground(this.getDisplay().getSystemColor(1));
        gC.setForeground(this.getDisplay().getSystemColor(3));
        gC.setFont(font);
        for (int i = 0; i < this.strings.length; ++i) {
            InstrumentString instrumentString = songTrack.getString(i + 1);
            for (int j = 0; j < this.frets.length; ++j) {
                int n = (instrumentString.getValue() + j) % 12;
                if (!TuxGuitar.instance().getScaleManager().getScale().getNote(n)) continue;
                String string = NOTE_NAMES[n];
                Point point = gC.stringExtent(string);
                int n2 = this.frets[j];
                if (j > 0) {
                    n2 -= (n2 - this.frets[j - 1]) / 2;
                }
                int n3 = this.strings[i];
                gC.fillRectangle(n2 - point.x / 2, n3 - point.y / 2, point.x, point.y);
                gC.drawString(string, n2 - point.x / 2, n3 - point.y / 2, true);
            }
        }
        gC.setForeground(this.getDisplay().getSystemColor(2));
        font.dispose();
    }

    private void paintComponents(GC gC) {
        int n = this.getOvalSize();
        gC.setBackground(this.getDisplay().getSystemColor(9));
        gC.setLineWidth(10);
        for (MeasureComponent measureComponent : this.components) {
            if (!(measureComponent instanceof NoteCoords)) continue;
            NoteCoords noteCoords = (NoteCoords)measureComponent;
            int n2 = noteCoords.getNote().getValue();
            int n3 = noteCoords.getNote().getString() - 1;
            if (n2 < 0 || n2 >= this.frets.length || n3 < 0 || n3 >= this.strings.length) continue;
            int n4 = this.frets[n2];
            if (n2 > 0) {
                n4 -= (this.frets[n2] - this.frets[n2 - 1]) / 2;
            }
            int n5 = this.strings[n3];
            gC.fillOval(n4 - n / 2, n5 - n / 2, n, n);
        }
        gC.setLineWidth(1);
        gC.setForeground(this.getDisplay().getSystemColor(2));
    }

    private void paintEditor(GC gC) {
        this.updateEditor();
        if (this.frets.length > 0 && this.strings.length > 0) {
            this.paintFretBoard(gC);
            this.paintComponents(gC);
        }
    }

    private void hit(int n, int n2) {
        int n3 = this.getFretIndex(n);
        int n4 = this.getStringIndex(n2);
        this.editor.getTablature().getCaret().setStringNumber(n4 + 1);
        if (!this.removeNote(n3, n4 + 1)) {
            this.addNote(n3, n4 + 1);
        }
    }

    private int getStringIndex(int n) {
        int n2 = -1;
        for (int i = 0; i < this.strings.length; ++i) {
            if (n2 < 0) {
                n2 = i;
                continue;
            }
            int n3 = Math.abs(n - this.strings[n2]);
            int n4 = Math.abs(n - this.strings[i]);
            if (n4 >= n3) continue;
            n2 = i;
        }
        return n2;
    }

    private int getFretIndex(int n) {
        int n2 = this.frets.length;
        if (n - 10 <= this.frets[0] && this.frets[0] < this.frets[n2 - 1]) {
            return 0;
        }
        if (n + 10 >= this.frets[0] && this.frets[0] > this.frets[n2 - 1]) {
            return 0;
        }
        for (int i = 0; i < n2; ++i) {
            if (i + 1 >= n2 || (n <= this.frets[i] || n > this.frets[i + 1]) && (n <= this.frets[i + 1] || n > this.frets[i])) continue;
            return i + 1;
        }
        return n2 - 1;
    }

    private boolean removeNote(int n, int n2) {
        for (MeasureComponent measureComponent : this.components) {
            Note note;
            if (!(measureComponent instanceof NoteCoords) || (note = ((NoteCoords)measureComponent).getNote()).getValue() != n || note.getString() != n2) continue;
            UndoableMeasureGeneric undoableMeasureGeneric = UndoableMeasureGeneric.startUndo();
            Caret caret = this.editor.getTablature().getCaret();
            SongManager songManager = TuxGuitar.instance().getSongManager();
            songManager.getMeasureManager().removeNote(caret.getMeasureCoords().getMeasure(), note);
            this.editor.getUndoManager().addEdit(undoableMeasureGeneric.endUndo());
            return true;
        }
        return false;
    }

    private int getStringCount() {
        return this.editor.getTablature().getCaret().getSongTrackCoords().getTrack().getStrings().size();
    }

    private int getOvalSize() {
        return STRING_SPAN / 2 + STRING_SPAN / 10;
    }

    private void addNote(int n, int n2) {
        UndoableMeasureGeneric undoableMeasureGeneric = UndoableMeasureGeneric.startUndo();
        Caret caret = this.editor.getTablature().getCaret();
        Duration duration = (Duration)caret.getDuration().clone();
        Note note = new Note(n, caret.getPosition(), duration, caret.getVelocity(), n2, false, new NoteEffect());
        SongManager songManager = TuxGuitar.instance().getSongManager();
        songManager.getMeasureManager().addNote(caret.getMeasureCoords().getMeasure(), note);
        this.editor.getUndoManager().addEdit(undoableMeasureGeneric.endUndo());
        caret.getMeasureCoords().playBeat(note.getStart());
    }

    private void afterAction() {
        this.editor.getTablature().getViewLayout().fireUpdate(this.editor.getTablature().getCaret().getMeasureCoords().getMeasure().getNumber(), false);
        TuxGuitar.instance().redraw();
        TuxGuitar.instance().updateCache(true);
    }

    public boolean hasChanges() {
        return this.changes;
    }

    public void setChanges(boolean bl) {
        this.changes = bl;
    }

    public void redraw() {
        if (!super.isDisposed()) {
            super.redraw();
            this.fretBoardComposite.redraw();
            this.durationLabel.setImage(this.getDurationImage());
        }
    }

    public void redrawPlayingMode() {
        if (!super.isDisposed()) {
            this.fretBoardComposite.redraw();
        }
    }

    public void dispose() {
        super.dispose();
        this.disposeFretBoardImage();
    }

    public void loadProperties() {
        int n = this.handSelector.getSelectionIndex();
        this.handSelector.removeAll();
        this.handSelector.add(TuxGuitar.getProperty("fretboard.right-mode"));
        this.handSelector.add(TuxGuitar.getProperty("fretboard.left-mode"));
        this.handSelector.select(n);
        this.scale.setText(TuxGuitar.getProperty("scale"));
        this.layout();
    }

    public int getHeight() {
        int n = 2 * this.fretBoardComposite.getBorderWidth();
        int n2 = this.toolComposite.getBounds().height;
        int n3 = STRING_SPAN * (this.strings.length - 1) + 10 + 10;
        return n + n2 + n3;
    }

    public int getWidth() {
        return this.frets[this.frets.length - 1];
    }

    public void layout() {
        super.layout();
    }

    public void layout(int n, int n2) {
        this.disposeFretBoardImage();
        this.calculateFretSpan(n);
        this.initFrets(10, n2);
        this.initStrings(this.getStringCount());
        this.setChanges(false);
    }

    public static void disposeColors() {
        COLOR_BACKGROUND.dispose();
        COLOR_STRING.dispose();
    }

    private class FretBoardListener
    implements PaintListener,
    MouseListener {
        private FretBoardListener() {
        }

        public void paintControl(PaintEvent paintEvent) {
            FretBoard.this.paintEditor(paintEvent.gc);
            paintEvent.gc.dispose();
        }

        public void mouseUp(MouseEvent mouseEvent) {
            if (mouseEvent.button == 1) {
                FretBoard.this.hit(mouseEvent.x, mouseEvent.y);
                FretBoard.this.afterAction();
            } else {
                TuxGuitar.instance().getAction("action.caret.go-right").process(mouseEvent);
            }
        }

        public void mouseDoubleClick(MouseEvent mouseEvent) {
        }

        public void mouseDown(MouseEvent mouseEvent) {
        }
    }
}

