/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.editors.chord;

import java.io.File;
import java.util.List;
import org.herac.tuxguitar.gui.editors.chord.xml.ChordReader;
import org.herac.tuxguitar.gui.editors.chord.xml.ChordWriter;
import org.herac.tuxguitar.gui.util.TuxGuitarFileUtils;
import org.herac.tuxguitar.song.models.Chord;

public class CustomChordManager {
    private long lastEdit;
    private List chords = ChordReader.getChords(CustomChordManager.getUserFileName());

    public CustomChordManager() {
        this.setLastEdit();
    }

    public int countChords() {
        return this.chords.size();
    }

    public Chord getChord(int n) {
        if (n >= 0 && n < this.countChords()) {
            return (Chord)((Chord)this.chords.get(n)).clone();
        }
        return null;
    }

    public void addChord(Chord chord) {
        this.chords.add(chord);
        this.setLastEdit();
    }

    public void removeChord(int n) {
        if (n >= 0 && n < this.countChords()) {
            this.chords.remove(n);
            this.setLastEdit();
        }
    }

    public void renameChord(int n, String string) {
        if (n >= 0 && n < this.countChords()) {
            ((Chord)this.chords.get(n)).setName(string);
            this.setLastEdit();
        }
    }

    public boolean existOtherEqualCustomChord(String string, int n) {
        for (int i = 0; i < this.countChords(); ++i) {
            Chord chord = this.getChord(i);
            if (!chord.getName().equals(string) || n == i) continue;
            return true;
        }
        return false;
    }

    public void write() {
        ChordWriter.setChords(this.chords, CustomChordManager.getUserFileName());
    }

    private static String getUserFileName() {
        return TuxGuitarFileUtils.USER_CONFIG_PREFIX + File.separator + "customchords.xml";
    }

    private void setLastEdit() {
        this.lastEdit = System.currentTimeMillis();
    }

    public long getLastEdit() {
        return this.lastEdit;
    }
}

