/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.editors;

import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.widgets.Composite;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.clipboard.ClipBoard;
import org.herac.tuxguitar.gui.editors.tab.Tablature;
import org.herac.tuxguitar.gui.undo.UndoManager;
import org.herac.tuxguitar.song.managers.SongManager;

public class TablatureEditor {
    private SongManager songManager;
    private Tablature tablature;
    private UndoManager undoManager;
    private ClipBoard clipBoard;

    public TablatureEditor(SongManager songManager) {
        this.songManager = songManager;
        this.undoManager = new UndoManager();
        this.clipBoard = new ClipBoard();
    }

    public void showTablature(Composite composite) {
        this.tablature = new Tablature(composite, 0x20000B00);
        this.tablature.loadFlags();
        this.tablature.initGUI();
        this.tablature.setSongManager(this.songManager);
        this.tablature.reloadStyles();
        this.tablature.reloadViewLayout();
        this.tablature.initDefaults();
        this.tablature.updateTablature();
        this.tablature.initCaret();
        this.initKeyActions();
        this.initMenu();
    }

    private void initKeyActions() {
        this.tablature.addKeyListener(new TablatureKeyListener());
        TuxGuitar.instance().getkeyBindingManager().appendListenersTo(this.tablature);
    }

    private void initMenu() {
        this.tablature.setMenu(TuxGuitar.instance().getItemManager().getPopupMenu());
    }

    public void resetDefaults() {
        this.getUndoManager().discardAllEdits();
        this.getTablature().resetScroll();
        this.getTablature().updateTablature();
        this.getTablature().initCaret();
        TuxGuitar.instance().getPlayer().reset();
        TuxGuitar.instance().getEditorCache().reset();
        TuxGuitar.instance().updateCache(true);
    }

    public void reloadConfig() {
        this.getTablature().reloadStyles();
    }

    public Tablature getTablature() {
        return this.tablature;
    }

    public SongManager getSongManager() {
        return this.songManager;
    }

    public UndoManager getUndoManager() {
        return this.undoManager;
    }

    public ClipBoard getClipBoard() {
        return this.clipBoard;
    }

    private class TablatureKeyListener
    extends KeyAdapter {
        private TablatureKeyListener() {
        }

        public void keyPressed(KeyEvent keyEvent) {
            Action action = this.switchAction(keyEvent);
            if (action != null) {
                action.process(keyEvent);
            }
        }

        private Action switchAction(KeyEvent keyEvent) {
            Action action = null;
            if (keyEvent.stateMask == 0 && this.isNumber(keyEvent.character)) {
                action = TuxGuitar.instance().getAction("action.note.general.change");
            } else if (keyEvent.stateMask == 0 && keyEvent.keyCode == 0x1000009) {
                action = TuxGuitar.instance().getAction("action.note.general.insert");
            } else if (keyEvent.stateMask == 0 && (keyEvent.keyCode == 127 || keyEvent.keyCode == 8)) {
                action = TuxGuitar.instance().getAction("action.note.general.remove");
            } else if (keyEvent.stateMask == 0 && keyEvent.keyCode == 0x1000001) {
                action = TuxGuitar.instance().getAction("action.caret.go-up");
            } else if (keyEvent.stateMask == 0 && keyEvent.keyCode == 0x1000002) {
                action = TuxGuitar.instance().getAction("action.caret.go-down");
            } else if (keyEvent.stateMask == 0 && keyEvent.keyCode == 0x1000004) {
                action = TuxGuitar.instance().getAction("action.caret.go-right");
            } else if (keyEvent.stateMask == 0 && keyEvent.keyCode == 0x1000003) {
                action = TuxGuitar.instance().getAction("action.caret.go-left");
            } else if (keyEvent.stateMask == 0 && keyEvent.character == '+') {
                action = TuxGuitar.instance().getAction("action.note.duration.increment-duration");
            } else if (keyEvent.stateMask == 0 && keyEvent.character == '-') {
                action = TuxGuitar.instance().getAction("action.note.duration.decrement-duration");
            }
            return action;
        }

        private boolean isNumber(char c) {
            return c == '0' || c == '1' || c == '2' || c == '3' || c == '4' || c == '5' || c == '6' || c == '7' || c == '8' || c == '9';
        }
    }
}

