/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.editors;

import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.editors.TablatureEditor;
import org.herac.tuxguitar.gui.editors.piano.Piano;

public class PianoEditor {
    private TablatureEditor tablatureEditor;
    private Piano piano;

    public PianoEditor(TablatureEditor tablatureEditor) {
        this.tablatureEditor = tablatureEditor;
    }

    public void show() {
        Shell shell = TuxGuitar.instance().getTablatureEditor().getTablature().getShell();
        Shell shell2 = new Shell(shell, 2144);
        shell2.setLayout(new GridLayout());
        this.piano = new Piano(shell2, 0);
        shell2.pack();
        shell2.open();
        int n = shell.getBounds().x + (shell.getBounds().width - shell2.getSize().x) / 2;
        int n2 = shell.getBounds().y + (shell.getBounds().height - shell2.getSize().y) / 2;
        shell2.setLocation(n, n2);
        TuxGuitar.instance().updateCache(true);
        while (!shell2.isDisposed()) {
            if (shell2.getDisplay().readAndDispatch()) continue;
            shell2.getDisplay().sleep();
        }
        TuxGuitar.instance().updateCache(true);
    }

    private Piano getPiano() {
        return this.piano;
    }

    public void setScaleChanges() {
        if (this.isVisible()) {
            this.getPiano().setScaleChanges(true);
        }
    }

    public void dispose() {
        if (!this.isDisposed()) {
            this.getPiano().getShell().dispose();
            this.getPiano().dispose();
        }
    }

    public void redraw() {
        if (!this.isDisposed()) {
            this.getPiano().redraw();
        }
    }

    public void redrawPlayingMode() {
        if (!this.isDisposed()) {
            this.getPiano().redrawPlayingMode();
        }
    }

    public boolean isVisible() {
        return !this.isDisposed() && this.getPiano().isVisible();
    }

    public boolean isDisposed() {
        return this.getPiano() == null || this.getPiano().isDisposed();
    }

    public void loadProperties() {
        if (!this.isDisposed()) {
            this.getPiano().loadProperties();
        }
    }
}

