/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.editors;

import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.editors.TablatureEditor;
import org.herac.tuxguitar.gui.editors.fretboard.FretBoard;

public class FretBoardEditor {
    private TablatureEditor tablatureEditor;
    private FretBoard fretBoard;
    private boolean visible;

    public FretBoardEditor(TablatureEditor tablatureEditor) {
        this.tablatureEditor = tablatureEditor;
    }

    private FretBoard getFretBoard() {
        return this.fretBoard;
    }

    public void hideFretBoard() {
        this.visible = false;
        this.getFretBoard().setVisible(this.visible);
        TuxGuitar.instance().updateShellFooter(0, 0, 0);
    }

    public void showFretBoard() {
        this.visible = true;
        this.getFretBoard().setVisible(this.visible);
        TuxGuitar.instance().updateShellFooter(this.getFretBoard().getHeight(), 730, 520);
    }

    public void showFretBoard(Composite composite) {
        FormData formData = new FormData();
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        formData.top = new FormAttachment(0, 0);
        formData.bottom = new FormAttachment(100, 0);
        this.fretBoard = new FretBoard(composite, this.tablatureEditor);
        this.fretBoard.setLayoutData(formData);
    }

    public void setScaleChanges() {
        if (this.isVisible()) {
            this.getFretBoard().setChanges(true);
        }
    }

    public void dispose() {
        if (this.getFretBoard() != null && !this.getFretBoard().isDisposed()) {
            this.getFretBoard().dispose();
        }
    }

    public void redraw() {
        if (this.getFretBoard() != null && !this.getFretBoard().isDisposed()) {
            this.getFretBoard().redraw();
        }
    }

    public void redrawPlayingMode() {
        if (this.getFretBoard() != null && !this.getFretBoard().isDisposed()) {
            this.getFretBoard().redrawPlayingMode();
        }
    }

    public boolean isVisible() {
        return this.getFretBoard() != null && !this.getFretBoard().isDisposed() && this.visible;
    }

    public void loadProperties() {
        if (this.getFretBoard() != null && !this.getFretBoard().isDisposed()) {
            this.getFretBoard().loadProperties();
        }
    }
}

