/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.editors;

import java.util.ArrayList;
import java.util.List;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.editors.tab.Caret;
import org.herac.tuxguitar.gui.editors.tab.MeasureComponent;
import org.herac.tuxguitar.gui.editors.tab.MeasureCoords;
import org.herac.tuxguitar.song.managers.SongManager;
import org.herac.tuxguitar.song.models.SongTrack;

public class EditorCache {
    private List playingComponents;
    private List caretComponents;
    private boolean playingUpdate;
    private boolean caretUpdate;
    private MeasureCoords playingMeasure;
    private int lastTrack;
    private long lastTick;
    private long playBeatEnd;
    private boolean playingChanges;

    public EditorCache() {
        this.reset();
    }

    public void reset() {
        this.playingComponents = new ArrayList();
        this.caretComponents = new ArrayList();
        this.playingUpdate = false;
        this.caretUpdate = false;
        this.playingMeasure = null;
        this.lastTrack = 0;
        this.lastTick = 0L;
        this.playBeatEnd = 0L;
        this.playingChanges = false;
    }

    public void updateCaretMode() {
        this.caretUpdate = true;
    }

    public void updatePlayingMode() {
        this.playingUpdate = true;
        this.getPlayingComponents();
    }

    public List getCaretComponents() {
        if (this.caretUpdate) {
            this.caretComponents.clear();
            Caret caret = TuxGuitar.instance().getTablatureEditor().getTablature().getCaret();
            MeasureCoords measureCoords = caret.getMeasureCoords();
            if (measureCoords != null) {
                this.caretComponents = measureCoords.getComponents(caret.getPosition());
            }
            this.caretUpdate = false;
        }
        return this.caretComponents;
    }

    public List getPlayingComponents() {
        if (this.playingUpdate) {
            this.playingChanges = false;
            SongManager songManager = TuxGuitar.instance().getSongManager();
            if (TuxGuitar.instance().getPlayer().isRunning()) {
                long l = TuxGuitar.instance().getPlayer().getTickPosition();
                Caret caret = TuxGuitar.instance().getTablatureEditor().getTablature().getCaret();
                SongTrack songTrack = caret.getSongTrackCoords().getTrack();
                if (this.playingMeasure == null || this.playBeatEnd == 0L || l > this.playBeatEnd || l < this.lastTick || songTrack.getNumber() != this.lastTrack) {
                    this.playingComponents.clear();
                    this.playBeatEnd = 0L;
                    this.playingChanges = true;
                    if (this.playingMeasure == null || !this.playingMeasure.hasTrack(songTrack.getNumber()) || !this.playingMeasure.isPlaying()) {
                        this.playingMeasure = caret.getSongTrackCoords().getMeasure(songManager.getTrackManager().getMeasureAt(songTrack, l));
                    }
                    if (this.playingMeasure != null) {
                        this.playingComponents = this.playingMeasure.getComponentsBetween(l);
                        for (MeasureComponent measureComponent : this.playingComponents) {
                            long l2 = measureComponent.getStart() + measureComponent.getDuration().getTime();
                            if (this.playBeatEnd != 0L && l2 >= this.playBeatEnd) continue;
                            this.playBeatEnd = l2;
                        }
                    }
                }
                this.lastTrack = songTrack.getNumber();
                this.lastTick = l;
            }
            this.playingUpdate = false;
        }
        return this.playingComponents;
    }

    public MeasureCoords getPlayingMeasure() {
        return this.playingMeasure;
    }

    public boolean shouldRedraw() {
        return this.playingChanges;
    }
}

