/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.clipboard;

import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.clipboard.CannotInsertTransferException;
import org.herac.tuxguitar.gui.clipboard.Transferable;
import org.herac.tuxguitar.gui.editors.TablatureEditor;
import org.herac.tuxguitar.gui.editors.tab.MeasureCoords;
import org.herac.tuxguitar.gui.editors.tab.SongCoords;
import org.herac.tuxguitar.gui.editors.tab.SongTrackCoords;
import org.herac.tuxguitar.gui.undo.undoables.measure.UndoableInsertMeasure;
import org.herac.tuxguitar.gui.undo.undoables.measure.UndoableReplaceMeasures;
import org.herac.tuxguitar.song.helpers.TracksMeasures;
import org.herac.tuxguitar.song.models.MeasureHeader;

public class MeasureTransferable
implements Transferable {
    public static final int TRANSFER_TYPE_REPLACE = 1;
    public static final int TRANSFER_TYPE_INSERT = 2;
    private TablatureEditor tablatureEditor;
    private TracksMeasures tracksMeasures;
    private long p1;
    private long p2;
    private int transferType;

    public MeasureTransferable(TablatureEditor tablatureEditor, long l, long l2, boolean bl) {
        this.tablatureEditor = tablatureEditor;
        this.transferType = 1;
        this.p1 = l;
        this.p2 = l2;
        this.getTransfer(l, l2, bl);
    }

    private void getTransfer(long l, long l2, boolean bl) {
        if (bl) {
            this.tracksMeasures = TuxGuitar.instance().getSongManager().copyMeasures(l, l2);
        } else {
            SongTrackCoords songTrackCoords = this.tablatureEditor.getTablature().getCaret().getSongTrackCoords();
            this.tracksMeasures = TuxGuitar.instance().getSongManager().copyMeasures(l, l2, songTrackCoords.getTrack());
        }
        this.skipMarkers();
    }

    public void insertTransfer() throws CannotInsertTransferException {
        if (this.transferType == 1) {
            this.replaceMeasures();
        } else if (this.transferType == 2) {
            this.insertMeasures();
        }
    }

    public void insertMeasures() throws CannotInsertTransferException {
        MeasureCoords measureCoords = this.tablatureEditor.getTablature().getCaret().getMeasureCoords();
        SongCoords songCoords = this.tablatureEditor.getTablature().getCaret().getSongCoords();
        if (measureCoords == null || songCoords == null || this.tracksMeasures.isEmpty()) {
            throw new CannotInsertTransferException();
        }
        UndoableInsertMeasure undoableInsertMeasure = new UndoableInsertMeasure();
        int n = measureCoords.getMeasure().getNumber();
        long l = measureCoords.getMeasure().getStart() - this.p1;
        TuxGuitar.instance().getSongManager().insertMeasures((TracksMeasures)this.tracksMeasures.clone(), n, l);
        this.tablatureEditor.getUndoManager().addEdit(undoableInsertMeasure.endUndo((TracksMeasures)this.tracksMeasures.clone(), this.tracksMeasures.getMeasureHeaders().size(), n, l));
    }

    public void replaceMeasures() throws CannotInsertTransferException {
        MeasureCoords measureCoords = this.tablatureEditor.getTablature().getCaret().getMeasureCoords();
        SongTrackCoords songTrackCoords = this.tablatureEditor.getTablature().getCaret().getSongTrackCoords();
        SongCoords songCoords = this.tablatureEditor.getTablature().getCaret().getSongCoords();
        if (measureCoords == null || songCoords == null || this.tracksMeasures.isEmpty()) {
            throw new CannotInsertTransferException();
        }
        int n = this.tracksMeasures.getMeasureHeaders().size();
        int n2 = measureCoords.getMeasure().getNumber();
        int n3 = songTrackCoords.getMeasuresCoords().size() - (n2 - 1);
        long l = measureCoords.getMeasure().getStart() - this.p1;
        UndoableReplaceMeasures undoableReplaceMeasures = new UndoableReplaceMeasures(this.p1 + l, this.p2 + l);
        for (int i = n3; i < n; ++i) {
            this.tablatureEditor.getSongManager().addNewMeasureBeforeEnd();
        }
        this.tablatureEditor.getSongManager().replaceMeasures((TracksMeasures)this.tracksMeasures.clone(), l);
        this.tablatureEditor.getUndoManager().addEdit(undoableReplaceMeasures.endUndo((TracksMeasures)this.tracksMeasures.clone(), n, n3, l));
    }

    public void setTransferType(int n) {
        this.transferType = n;
    }

    private void skipMarkers() {
        for (MeasureHeader measureHeader : this.tracksMeasures.getMeasureHeaders()) {
            measureHeader.setMarker(null);
        }
    }
}

