/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.actions.track;

import org.eclipse.swt.events.TypedEvent;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.editors.TablatureEditor;
import org.herac.tuxguitar.gui.editors.tab.Caret;
import org.herac.tuxguitar.gui.editors.tab.SongCoords;
import org.herac.tuxguitar.gui.editors.tab.SongTrackCoords;
import org.herac.tuxguitar.gui.undo.undoables.track.UndoableRemoveTrack;

public class RemoveTrackAction
extends Action {
    public static final String NAME = "action.track.remove";

    public RemoveTrackAction(TablatureEditor tablatureEditor) {
        super(NAME, true, tablatureEditor);
    }

    public boolean doAction(TypedEvent typedEvent) {
        Caret caret = this.getEditor().getTablature().getCaret();
        SongCoords songCoords = caret.getSongCoords();
        if (this.getSongManager().countTracks() <= 1) {
            TuxGuitar.instance().getSongManager().newSong();
            this.getEditor().resetDefaults();
            TuxGuitar.instance().getMixer().update();
            TuxGuitar.instance().getTableViewer().getTableInfo().fireUpdate();
            this.redraw();
            return true;
        }
        UndoableRemoveTrack undoableRemoveTrack = UndoableRemoveTrack.startUndo();
        SongTrackCoords songTrackCoords = caret.getSongTrackCoords();
        SongTrackCoords songTrackCoords2 = caret.getSongCoords().getNextTrack(songTrackCoords);
        if (songTrackCoords2 == null) {
            songTrackCoords2 = caret.getSongCoords().getPrevTrack(songTrackCoords);
        }
        this.getSongManager().removeTrack(songTrackCoords.getTrack());
        this.updateTablature();
        if (songTrackCoords2 != null) {
            caret.update(songTrackCoords2.getTrack().getNumber(), songTrackCoords2.getMeasureCoords(caret.getMeasureCoords().getMeasure().getStart()).getMeasure().getStart(), 1);
        }
        TuxGuitar.instance().getMixer().update();
        this.redraw();
        this.getEditor().getUndoManager().addEdit(undoableRemoveTrack.endUndo());
        return true;
    }
}

