/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.actions.track;

import org.eclipse.swt.events.TypedEvent;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.editors.TablatureEditor;
import org.herac.tuxguitar.gui.editors.tab.Caret;
import org.herac.tuxguitar.gui.undo.undoables.track.UndoableMoveTrackDown;
import org.herac.tuxguitar.song.models.SongTrack;

public class MoveTrackDownAction
extends Action {
    public static final String NAME = "action.track.move-down";

    public MoveTrackDownAction(TablatureEditor tablatureEditor) {
        super(NAME, false, tablatureEditor);
    }

    public boolean doAction(TypedEvent typedEvent) {
        UndoableMoveTrackDown undoableMoveTrackDown = UndoableMoveTrackDown.startUndo();
        Caret caret = this.getEditor().getTablature().getCaret();
        SongTrack songTrack = caret.getSongTrackCoords().getTrack();
        if (this.getSongManager().moveTrackDown(songTrack)) {
            this.updateTablature();
            TuxGuitar.instance().getMixer().update();
            this.redraw();
            this.getEditor().getUndoManager().addEdit(undoableMoveTrackDown.endUndo(songTrack));
        }
        return true;
    }
}

