/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.actions.player;

import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.widgets.Display;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.editors.TablatureEditor;
import org.herac.tuxguitar.gui.helper.SyncThread;
import org.herac.tuxguitar.gui.util.MessageDialog;
import org.herac.tuxguitar.player.base.MidiPlayer;
import org.herac.tuxguitar.song.models.Measure;

public class PlaySongAction
extends Action {
    public static final String NAME = "action.player.play";

    public PlaySongAction(TablatureEditor tablatureEditor) {
        super(NAME, true, tablatureEditor);
    }

    public boolean doAction(TypedEvent typedEvent) {
        MidiPlayer midiPlayer = TuxGuitar.instance().getPlayer();
        if (!midiPlayer.isRunning()) {
            if (this.checkSoundbank(midiPlayer)) {
                midiPlayer.play();
                this.redrawTablaturePlayMode();
            }
        } else {
            Measure measure = this.getSongManager().getTrackManager().getMeasureAt(this.getSongManager().getFirstTrack(), midiPlayer.getTickPosition());
            midiPlayer.pause();
            if (measure != null) {
                midiPlayer.setTickPosition(measure.getStartWidthRepetitions(), measure.getStartWidthRepetitions() - measure.getStart());
            }
            this.getEditor().getTablature().getCaret().goToTickPosition();
            this.redrawTablatureStopMode();
        }
        return true;
    }

    private boolean checkSoundbank(MidiPlayer midiPlayer) {
        if (midiPlayer.getSoundbank() == null) {
            String string = TuxGuitar.getProperty("soundbank.error");
            String string2 = TuxGuitar.getProperty("soundbank.error.unavailable");
            new MessageDialog(string, string2, 33).show(this.getEditor().getTablature().getShell());
            return false;
        }
        return true;
    }

    protected void redrawTablaturePlayMode() {
        final Display display = TuxGuitar.instance().getDisplay();
        final Runnable runnable = new Runnable(){

            public void run() {
                if (TuxGuitar.instance().getPlayer().isRunning()) {
                    TuxGuitar.instance().redrawPayingMode();
                }
            }
        };
        final Runnable runnable2 = new Runnable(){

            public void run() {
                TuxGuitar.instance().updateCache(true);
                PlaySongAction.this.redraw();
            }
        };
        new Thread(new Runnable(){

            public void run() {
                while (TuxGuitar.instance().getPlayer().isRunning()) {
                    if (display.isDisposed()) continue;
                    display.syncExec(runnable);
                    PlaySongAction.this.sleep(80L);
                }
                if (!display.isDisposed()) {
                    display.syncExec(runnable2);
                }
            }
        }).start();
    }

    private void redrawTablatureStopMode() {
        new SyncThread(new Runnable(){

            public void run() {
                if (!TuxGuitar.isDisposed()) {
                    PlaySongAction.this.redraw();
                }
            }
        }).start();
    }

    private void sleep(long l) {
        try {
            Thread.sleep(l);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }
}

