/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.actions.note;

import org.eclipse.swt.events.TypedEvent;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.editors.TablatureEditor;
import org.herac.tuxguitar.gui.editors.tab.Caret;
import org.herac.tuxguitar.gui.editors.tab.SilenceCoords;
import org.herac.tuxguitar.gui.undo.undoables.measure.UndoableMeasureGeneric;

public class RemoveNoteAction
extends Action {
    public static final String NAME = "action.note.general.remove";

    public RemoveNoteAction(TablatureEditor tablatureEditor) {
        super(NAME, tablatureEditor);
    }

    public boolean doAction(TypedEvent typedEvent) {
        UndoableMeasureGeneric undoableMeasureGeneric = UndoableMeasureGeneric.startUndo();
        Caret caret = this.getEditor().getTablature().getCaret();
        if (caret.getSelectedComponent() instanceof SilenceCoords) {
            SilenceCoords silenceCoords = (SilenceCoords)caret.getSelectedComponent();
            this.getSongManager().getMeasureManager().removeSilence(caret.getMeasureCoords().getMeasure(), silenceCoords.getSilence(), true);
        } else {
            long l = caret.getSelectedComponent().getStart();
            int n = caret.getSelectedString().getNumber();
            this.getSongManager().getMeasureManager().removeComponentsAt(caret.getMeasureCoords().getMeasure(), l, n, true);
        }
        this.getEditor().getUndoManager().addEdit(undoableMeasureGeneric.endUndo());
        this.updateTablature();
        return true;
    }

    protected void updateTablature() {
        this.fireUpdate(this.getEditor().getTablature().getCaret().getMeasureCoords().getMeasure().getNumber());
        this.redraw();
    }
}

