/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.actions.file;

import java.io.File;
import org.eclipse.swt.events.TypedEvent;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.editors.TablatureEditor;
import org.herac.tuxguitar.gui.helper.SyncThread;

public class SaveFileAction
extends Action {
    public static final String NAME = "action.file.save";

    public SaveFileAction(TablatureEditor tablatureEditor) {
        super(NAME, true, tablatureEditor);
    }

    public boolean doAction(TypedEvent typedEvent) {
        final String string = TuxGuitar.instance().getFileHistory().getFilePath() + File.separator + TuxGuitar.instance().getFileHistory().getFileName();
        if (TuxGuitar.instance().getFileHistory().isNewFile() || !this.isSuportedFormat(string)) {
            TuxGuitar.instance().getAction("action.file.save-as").process(typedEvent);
        } else {
            this.getEditor().getTablature().changeCursor(1);
            new SyncThread(new Runnable(){

                public void run() {
                    if (!TuxGuitar.isDisposed()) {
                        SaveFileAction.this.getEditor().getSongManager().save(string);
                        SaveFileAction.this.getEditor().getTablature().changeCursor(0);
                    }
                }
            }).start();
        }
        return true;
    }

    private boolean isSuportedFormat(String string) {
        return string.endsWith(".tg") || string.endsWith(".gp3") || string.endsWith(".gp4");
    }
}

