/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.actions.file;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.editors.TablatureEditor;
import org.herac.tuxguitar.gui.editors.tab.Tablature;
import org.herac.tuxguitar.gui.editors.tab.layout.PrinterViewLayout;
import org.herac.tuxguitar.gui.helper.SyncThread;
import org.herac.tuxguitar.gui.printer.PrintDocument;
import org.herac.tuxguitar.gui.printer.PrintDocumentData;
import org.herac.tuxguitar.gui.util.ConfirmDialog;
import org.herac.tuxguitar.gui.util.FileChooser;
import org.herac.tuxguitar.gui.util.MessageDialog;
import org.herac.tuxguitar.gui.util.PDFWriter;

public class ExportPDFAction
extends Action {
    public static final String NAME = "action.file.export-pdf";
    private static final int PAGE_WIDTH = 550;
    private static final int PAGE_HEIGHT = 800;

    public ExportPDFAction(TablatureEditor tablatureEditor) {
        super(NAME, tablatureEditor);
    }

    public boolean doAction(TypedEvent typedEvent) {
        final PrintDocumentData printDocumentData = PrintDocumentData.openDialog(TuxGuitar.instance().getShell());
        if (printDocumentData != null) {
            Shell shell = this.getEditor().getTablature().getShell();
            String string = FileChooser.instance().save(shell, FileChooser.EXPORT_PDF_FORMAT);
            if (string != null) {
                ConfirmDialog confirmDialog;
                String string2;
                File file;
                boolean bl = true;
                if (!this.isSuportedFormat(string)) {
                    string = string + this.getDefaultExtension();
                }
                if ((file = new File(string2 = string)).exists() && !(confirmDialog = new ConfirmDialog(this.getEditor().getTablature().getShell(), TuxGuitar.getProperty("replace-file-question"))).confirm()) {
                    bl = false;
                }
                if (bl) {
                    this.getEditor().getTablature().changeCursor(1);
                    new SyncThread(new Runnable(){

                        public void run() {
                            if (!TuxGuitar.isDisposed()) {
                                try {
                                    ExportPDFAction.this.writeFile(new FileOutputStream(string2), printDocumentData);
                                    ExportPDFAction.this.getEditor().getTablature().changeCursor(0);
                                }
                                catch (FileNotFoundException fileNotFoundException) {
                                    fileNotFoundException.printStackTrace();
                                }
                            }
                        }
                    }).start();
                }
            }
        }
        return true;
    }

    private boolean isSuportedFormat(String string) {
        return string.endsWith(this.getDefaultExtension());
    }

    private String getDefaultExtension() {
        return ".pdf";
    }

    private void writeFile(OutputStream outputStream, PrintDocumentData printDocumentData) {
        try {
            PDFWriter.write(outputStream, this.makePrintDocument(printDocumentData));
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.showErrorMessage(outOfMemoryError);
            return;
        }
    }

    public PrintDocument makePrintDocument(PrintDocumentData printDocumentData) {
        Tablature tablature = new Tablature(this.getEditor().getTablature(), 0);
        tablature.setSongManager(this.getEditor().getSongManager());
        tablature.reloadStyles();
        PrinterViewLayout printerViewLayout = new PrinterViewLayout(tablature, this.getEditor().getSongManager(), printDocumentData);
        tablature.setViewLayout(printerViewLayout);
        tablature.initDefaults();
        tablature.updateTablature();
        tablature.getCaret().update(this.getEditor().getTablature().getCaret().getSongTrackCoords().getTrack().getNumber());
        PrintDocument printDocument = printerViewLayout.makeDocument(new Rectangle(0, 0, 550, 800));
        tablature.dispose();
        return printDocument;
    }

    private void showErrorMessage(final Error error) {
        new SyncThread(new Runnable(){

            public void run() {
                if (!TuxGuitar.isDisposed()) {
                    String string = error.getClass().getName();
                    String string2 = error.getMessage();
                    new MessageDialog(string, string2, 33).show(ExportPDFAction.this.getEditor().getTablature().getShell());
                }
            }
        }).start();
    }
}

