/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.actions.file;

import java.io.File;
import java.io.FileNotFoundException;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.editors.TablatureEditor;
import org.herac.tuxguitar.gui.helper.SyncThread;
import org.herac.tuxguitar.gui.util.ConfirmDialog;
import org.herac.tuxguitar.gui.util.FileChooser;
import org.herac.tuxguitar.io.exporter.ASCIITabOutputStream;

public class ExportASCIIAction
extends Action {
    public static final String NAME = "action.file.export-ascii";

    public ExportASCIIAction(TablatureEditor tablatureEditor) {
        super(NAME, tablatureEditor);
    }

    public boolean doAction(TypedEvent typedEvent) {
        Shell shell = this.getEditor().getTablature().getShell();
        String string = FileChooser.instance().save(shell, FileChooser.EXPORT_ASCII_FORMAT);
        if (string != null) {
            ConfirmDialog confirmDialog;
            String string2;
            File file;
            boolean bl = true;
            if (!this.isSuportedFormat(string)) {
                string = string + this.getDefaultExtension();
            }
            if ((file = new File(string2 = string)).exists() && !(confirmDialog = new ConfirmDialog(this.getEditor().getTablature().getShell(), TuxGuitar.getProperty("replace-file-question"))).confirm()) {
                bl = false;
            }
            if (bl) {
                this.getEditor().getTablature().changeCursor(1);
                new SyncThread(new Runnable(){

                    public void run() {
                        if (!TuxGuitar.isDisposed()) {
                            try {
                                new ASCIITabOutputStream(string2).writeSong(ExportASCIIAction.this.getSongManager().getSong());
                                ExportASCIIAction.this.getEditor().getTablature().changeCursor(0);
                            }
                            catch (FileNotFoundException fileNotFoundException) {
                                fileNotFoundException.printStackTrace();
                            }
                        }
                    }
                }).start();
            }
        }
        return true;
    }

    private boolean isSuportedFormat(String string) {
        return string.endsWith(this.getDefaultExtension());
    }

    private String getDefaultExtension() {
        return ".tab";
    }
}

