/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.actions.duration;

import org.eclipse.swt.events.TypedEvent;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.editors.TablatureEditor;
import org.herac.tuxguitar.gui.editors.tab.Caret;
import org.herac.tuxguitar.gui.undo.undoables.measure.UndoableMeasureGeneric;
import org.herac.tuxguitar.song.models.Duration;

public class SetEighthDurationAction
extends Action {
    public static final String NAME = "action.note.duration.set-eighth";
    public static final int VALUE = 8;

    public SetEighthDurationAction(TablatureEditor tablatureEditor) {
        super(NAME, tablatureEditor);
    }

    public boolean doAction(TypedEvent typedEvent) {
        if (this.getSelectedDuration().getValue() != 8) {
            UndoableMeasureGeneric undoableMeasureGeneric = UndoableMeasureGeneric.startUndo();
            this.getSelectedDuration().setValue(8);
            this.getSelectedDuration().setDotted(false);
            this.getSelectedDuration().setDoubleDotted(false);
            this.setDurations();
            this.getEditor().getUndoManager().addEdit(undoableMeasureGeneric.endUndo());
        }
        return true;
    }

    private void setDurations() {
        Caret caret = this.getEditor().getTablature().getCaret();
        caret.changeDuration((Duration)this.getSelectedDuration().clone());
        this.fireUpdate(this.getEditor().getTablature().getCaret().getMeasureCoords().getMeasure().getNumber());
        this.redraw();
    }

    public Duration getSelectedDuration() {
        return this.getEditor().getTablature().getCaret().getDuration();
    }
}

