/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.actions.composition;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.editors.TablatureEditor;
import org.herac.tuxguitar.gui.editors.tab.Caret;
import org.herac.tuxguitar.gui.editors.tab.MeasureCoords;
import org.herac.tuxguitar.gui.editors.tab.SongCoords;
import org.herac.tuxguitar.gui.undo.undoables.custom.UndoableChangeTripletFeel;

public class ChangeTripletFeelAction
extends Action {
    public static final String NAME = "action.composition.change-triplet-feel";

    public ChangeTripletFeelAction(TablatureEditor tablatureEditor) {
        super(NAME, tablatureEditor);
    }

    public boolean doAction(TypedEvent typedEvent) {
        this.showDialog(this.getEditor().getTablature().getShell());
        return true;
    }

    public void showDialog(Shell shell) {
        MeasureCoords measureCoords = this.getEditor().getTablature().getCaret().getMeasureCoords();
        if (measureCoords != null) {
            final Shell shell2 = new Shell(shell, 67680);
            shell2.setLayout(new GridLayout());
            shell2.setText(TuxGuitar.getProperty("composition.tripletfeel"));
            Composite composite = new Composite(shell2, 0);
            composite.setLayout(new GridLayout());
            composite.setLayoutData(new GridData(4, 4, true, true));
            final Button button = new Button(composite, 16);
            button.setText(TuxGuitar.getProperty("composition.tripletfeel.none"));
            button.setSelection(measureCoords.getMeasure().getTripletFeel() == 1);
            final Button button2 = new Button(composite, 16);
            button2.setText(TuxGuitar.getProperty("composition.tripletfeel.eighth"));
            button2.setSelection(measureCoords.getMeasure().getTripletFeel() == 2);
            final Button button3 = new Button(composite, 16);
            button3.setText(TuxGuitar.getProperty("composition.tripletfeel.sixteenth"));
            button3.setSelection(measureCoords.getMeasure().getTripletFeel() == 3);
            Composite composite2 = new Composite(shell2, 0);
            composite2.setLayout(new GridLayout());
            composite2.setLayoutData(new GridData(4, 4, true, true));
            final Button button4 = new Button(composite2, 32);
            button4.setText(TuxGuitar.getProperty("composition.tripletfeel.to-the-end"));
            button4.setSelection(true);
            Composite composite3 = new Composite(shell2, 0);
            composite3.setLayout(new GridLayout(2, false));
            composite3.setLayoutData(new GridData(0x1000008, 4, true, true));
            GridData gridData = new GridData(4, 4, true, true);
            gridData.minimumWidth = 80;
            gridData.minimumHeight = 25;
            Button button5 = new Button(composite3, 8);
            button5.setText(TuxGuitar.getProperty("ok"));
            button5.setLayoutData(gridData);
            button5.addSelectionListener(new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    boolean bl = button4.getSelection();
                    int n = 1;
                    if (button.getSelection()) {
                        n = 1;
                    } else if (button2.getSelection()) {
                        n = 2;
                    } else if (button3.getSelection()) {
                        n = 3;
                    }
                    ChangeTripletFeelAction.this.setTripletFeel(n, bl);
                    shell2.dispose();
                }
            });
            Button button6 = new Button(composite3, 8);
            button6.setLayoutData(gridData);
            button6.setText(TuxGuitar.getProperty("cancel"));
            button6.addSelectionListener(new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    shell2.dispose();
                }
            });
            shell2.setMinimumSize(300, 0);
            shell2.pack();
            shell2.open();
            int n = shell.getBounds().x + (shell.getBounds().width - shell2.getSize().x) / 2;
            int n2 = shell.getBounds().y + (shell.getBounds().height - shell2.getSize().y) / 2;
            shell2.setLocation(n, n2);
            while (!shell2.isDisposed()) {
                if (shell2.getDisplay().readAndDispatch()) continue;
                shell2.getDisplay().sleep();
            }
        }
    }

    private void setTripletFeel(int n, boolean bl) {
        UndoableChangeTripletFeel undoableChangeTripletFeel = UndoableChangeTripletFeel.startUndo();
        Caret caret = this.getEditor().getTablature().getCaret();
        SongCoords songCoords = caret.getSongCoords();
        MeasureCoords measureCoords = caret.getMeasureCoords();
        this.getSongManager().changeTripletFeel(measureCoords.getMeasure().getStart(), n, bl);
        this.updateTablature();
        this.redraw();
        this.getEditor().getUndoManager().addEdit(undoableChangeTripletFeel.endUndo(n, bl));
    }
}

