/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.actions.composition;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.editors.TablatureEditor;
import org.herac.tuxguitar.song.models.Song;

public class ChangeInfoAction
extends Action {
    public static final String NAME = "action.composition.change-info";
    private static final int TEXT_WIDTH = 300;

    public ChangeInfoAction(TablatureEditor tablatureEditor) {
        super(NAME, true, tablatureEditor);
    }

    public boolean doAction(TypedEvent typedEvent) {
        this.showDialog(this.getEditor().getTablature().getShell());
        return true;
    }

    public void showDialog(Shell shell) {
        Song song = this.getEditor().getSongManager().getSong();
        if (song != null) {
            final Shell shell2 = new Shell(shell, 67680);
            shell2.setLayout(new GridLayout());
            shell2.setLayoutData(new GridData(4, 4, true, true));
            shell2.setText(TuxGuitar.getProperty("composition.properties"));
            Group group = new Group(shell2, 16);
            group.setLayout(this.makeGroupLayout(5));
            group.setLayoutData(new GridData(4, 4, true, true));
            group.setText(TuxGuitar.getProperty("composition.properties"));
            Label label = new Label(group, 0);
            label.setLayoutData(this.makeLabelData());
            label.setText(TuxGuitar.getProperty("composition.name") + ":");
            final Text text = new Text(group, 2048);
            text.setLayoutData(this.makeTextData());
            text.setText(song.getName());
            Label label2 = new Label(group, 0);
            label2.setLayoutData(this.makeLabelData());
            label2.setText(TuxGuitar.getProperty("composition.interpret") + ":");
            final Text text2 = new Text(group, 2048);
            text2.setLayoutData(this.makeTextData());
            text2.setText(song.getInterpret());
            Label label3 = new Label(group, 0);
            label3.setLayoutData(this.makeLabelData());
            label3.setText(TuxGuitar.getProperty("composition.album") + ":");
            final Text text3 = new Text(group, 2048);
            text3.setLayoutData(this.makeTextData());
            text3.setText(song.getAlbum());
            Label label4 = new Label(group, 0);
            label4.setLayoutData(this.makeLabelData());
            label4.setText(TuxGuitar.getProperty("composition.author") + ":");
            final Text text4 = new Text(group, 2048);
            text4.setLayoutData(this.makeTextData());
            text4.setText(song.getAuthor());
            Composite composite = new Composite(shell2, 0);
            composite.setLayout(new GridLayout(2, false));
            composite.setLayoutData(new GridData(131072, 4, true, true));
            GridData gridData = new GridData(4, 4, true, true);
            gridData.minimumWidth = 80;
            gridData.minimumHeight = 25;
            Button button = new Button(composite, 8);
            button.setText(TuxGuitar.getProperty("ok"));
            button.setLayoutData(gridData);
            button.addSelectionListener(new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    ChangeInfoAction.this.setProperties(text.getText(), text2.getText(), text3.getText(), text4.getText());
                    shell2.dispose();
                }
            });
            Button button2 = new Button(composite, 8);
            button2.setText(TuxGuitar.getProperty("cancel"));
            button2.setLayoutData(gridData);
            button2.addSelectionListener(new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    shell2.dispose();
                }
            });
            shell2.pack();
            shell2.open();
            int n = shell.getBounds().x + (shell.getBounds().width - shell2.getSize().x) / 2;
            int n2 = shell.getBounds().y + (shell.getBounds().height - shell2.getSize().y) / 2;
            shell2.setLocation(n, n2);
        }
    }

    private GridLayout makeGroupLayout(int n) {
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginTop = n;
        gridLayout.marginBottom = n;
        gridLayout.marginLeft = n;
        gridLayout.marginRight = n;
        gridLayout.verticalSpacing = n;
        gridLayout.horizontalSpacing = n;
        return gridLayout;
    }

    private GridData makeTextData() {
        return new GridData(300, -1);
    }

    private GridData makeLabelData() {
        return new GridData(131072, 0x1000000, true, true);
    }

    private void setProperties(String string, String string2, String string3, String string4) {
        this.getEditor().getSongManager().setProperties(string, string2, string3, string4);
        TuxGuitar.instance().showTitle();
        this.redraw();
    }
}

