/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.actions;

import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TypedEvent;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.editors.TablatureEditor;
import org.herac.tuxguitar.song.managers.SongManager;

public abstract class Action
implements SelectionListener,
MouseListener,
MenuListener,
DisposeListener {
    private String name;
    private boolean editableKeyBinding;
    private TablatureEditor tablatureEditor;

    public Action(String string, boolean bl, TablatureEditor tablatureEditor) {
        this.name = string;
        this.editableKeyBinding = bl;
        this.tablatureEditor = tablatureEditor;
    }

    public Action(String string, TablatureEditor tablatureEditor) {
        this(string, false, tablatureEditor);
    }

    protected abstract boolean doAction(TypedEvent var1);

    public synchronized void process(TypedEvent typedEvent) {
        TuxGuitar.instance().updateCache(this.doAction(typedEvent));
        this.setLastEvent(typedEvent);
    }

    public boolean isEditableKeyBinding() {
        return this.editableKeyBinding;
    }

    public String getName() {
        return this.name;
    }

    protected synchronized void redraw() {
        TuxGuitar.instance().redraw();
    }

    protected synchronized void updateTablature() {
        TuxGuitar.instance().fireUpdate();
    }

    protected void fireUpdate(int n, boolean bl) {
        this.tablatureEditor.getTablature().getViewLayout().fireUpdate(n, bl);
    }

    protected void fireUpdate(int n) {
        this.fireUpdate(n, false);
    }

    protected TablatureEditor getEditor() {
        return this.tablatureEditor;
    }

    protected SongManager getSongManager() {
        return this.tablatureEditor.getSongManager();
    }

    protected TypedEvent getLastEvent() {
        return TuxGuitar.instance().getActionContainer().getLastEvent();
    }

    private void setLastEvent(TypedEvent typedEvent) {
        TuxGuitar.instance().getActionContainer().setLastEvent(typedEvent);
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        this.process(selectionEvent);
    }

    public void mouseDoubleClick(MouseEvent mouseEvent) {
    }

    public void mouseDown(MouseEvent mouseEvent) {
    }

    public void mouseUp(MouseEvent mouseEvent) {
        this.process(mouseEvent);
    }

    public void menuShown(MenuEvent menuEvent) {
        this.process(menuEvent);
    }

    public void menuHidden(MenuEvent menuEvent) {
    }

    public void widgetDisposed(DisposeEvent disposeEvent) {
        this.process(disposeEvent);
    }
}

