/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui;

import java.io.File;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.gui.SongTableViewer;
import org.herac.tuxguitar.gui.SystemImages;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.actions.ActionContainer;
import org.herac.tuxguitar.gui.editors.EditorCache;
import org.herac.tuxguitar.gui.editors.FretBoardEditor;
import org.herac.tuxguitar.gui.editors.PianoEditor;
import org.herac.tuxguitar.gui.editors.TablatureEditor;
import org.herac.tuxguitar.gui.editors.chord.CustomChordManager;
import org.herac.tuxguitar.gui.editors.lyric.LyricEditor;
import org.herac.tuxguitar.gui.helper.FileHistory;
import org.herac.tuxguitar.gui.helper.SyncThread;
import org.herac.tuxguitar.gui.items.ItemManager;
import org.herac.tuxguitar.gui.mixer.SongMixer;
import org.herac.tuxguitar.gui.scale.MusicScaleManager;
import org.herac.tuxguitar.gui.system.config.ConfigManager;
import org.herac.tuxguitar.gui.system.keybindings.KeyBindingManager;
import org.herac.tuxguitar.gui.system.language.LanguageManager;
import org.herac.tuxguitar.gui.system.plugins.PluginManager;
import org.herac.tuxguitar.gui.transport.SongTransport;
import org.herac.tuxguitar.gui.util.ArgumentParser;
import org.herac.tuxguitar.gui.util.ClassLoaderUtil;
import org.herac.tuxguitar.gui.util.MessageDialog;
import org.herac.tuxguitar.gui.util.SplashShell;
import org.herac.tuxguitar.gui.util.SystemError;
import org.herac.tuxguitar.gui.util.WindowTitleUtil;
import org.herac.tuxguitar.io.FileFormatFormatException;
import org.herac.tuxguitar.player.NullPlayer;
import org.herac.tuxguitar.player.base.MidiPlayer;
import org.herac.tuxguitar.song.managers.SongManager;

public class TuxGuitar {
    public static final String TUXGUITAR_NAME = "TuxGuitar";
    public static final String TUXGUITAR_VERSION = "0.9";
    private static final String appConfigDomain = ".tuxguitar";
    private static final String appConfigDomainEnvVar = "TUXGUITAR_CONFIG_HOME";
    public static final int MARGIN_WIDTH = 5;
    private static TuxGuitar instance;
    private Display display;
    private Shell shell;
    private SongManager songManager;
    private MidiPlayer player;
    private LanguageManager languageManager;
    private ConfigManager configManager;
    private KeyBindingManager keyBindingManager;
    private Composite sashComposite;
    private Sash sash;
    private EditorCache editorCache;
    private TablatureEditor tablatureEditor;
    private SongTableViewer tableViewer;
    private SongMixer songMixer;
    private SongTransport songTransport;
    private FretBoardEditor fretBoardEditor;
    private PianoEditor pianoEditor;
    private LyricEditor lyricEditor;
    private MusicScaleManager scaleManager;
    private ActionContainer actionContainer;
    private ItemManager itemManager;
    private CustomChordManager customChordManager;
    private FileHistory fileHistory;
    private PluginManager pluginManager;

    public static void main(String[] stringArray) {
        TuxGuitar.instance().displayGUI(stringArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TuxGuitar instance() {
        if (instance != null) return instance;
        Class<TuxGuitar> clazz = TuxGuitar.class;
        synchronized (TuxGuitar.class) {
            instance = new TuxGuitar();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private void initLanguage() {
        this.languageManager = new LanguageManager();
        this.languageManager.setLanguage(this.getConfig().getStringConfigValue("language"));
    }

    public void displayGUI(String[] stringArray) {
        ArgumentParser argumentParser = new ArgumentParser(stringArray);
        if (argumentParser.printAndExit()) {
            return;
        }
        this.initConfigManager();
        this.initLanguage();
        this.display = new Display();
        SplashShell splashShell = new SplashShell(this.display);
        this.shell = new Shell(this.display);
        this.shell.setLayout(this.getShellLayout());
        this.shell.setImage(SystemImages.TUXGUITAR_ICON);
        this.songManager = new SongManager();
        this.initPluginManager();
        if (argumentParser.getFile() != null) {
            try {
                this.songManager.open(argumentParser.getFile().getPath());
            }
            catch (FileFormatFormatException fileFormatFormatException) {
                fileFormatFormatException.printStackTrace();
                this.songManager.newSong();
            }
        }
        this.initPlayer(false);
        this.fileHistory = new FileHistory();
        this.editorCache = new EditorCache();
        this.scaleManager = new MusicScaleManager();
        this.tablatureEditor = new TablatureEditor(this.songManager);
        this.tableViewer = new SongTableViewer(this.tablatureEditor);
        this.fretBoardEditor = new FretBoardEditor(this.tablatureEditor);
        this.pianoEditor = new PianoEditor(this.tablatureEditor);
        this.songMixer = new SongMixer();
        this.songTransport = new SongTransport();
        this.customChordManager = new CustomChordManager();
        this.lyricEditor = new LyricEditor();
        this.initActions();
        this.adjustKeyBindings();
        this.initItems();
        this.createComposites(this.shell);
        boolean bl = this.getConfig().getBooleanConfigValue("window.maximized");
        this.shell.setMaximized(bl);
        if (!bl) {
            int n = this.getConfig().getIntConfigValue("window.width");
            int n2 = this.getConfig().getIntConfigValue("window.height");
            if (n > 0 && n2 > 0) {
                this.shell.setSize(n, n2);
            }
        }
        this.tablatureEditor.getTablature().setFocus();
        this.shell.setMinimumSize(640, 480);
        this.showDefaultControls();
        this.updateCache(true);
        this.showTitle();
        splashShell.close();
        this.shell.addDisposeListener(this.getAction("action.main.dispose"));
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (this.display.readAndDispatch()) continue;
            this.display.sleep();
        }
        this.getDisplay().dispose();
        System.exit(0);
    }

    private FormLayout getShellLayout() {
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        return formLayout;
    }

    public void createComposites(Composite composite) {
        this.sashComposite = new Composite(composite, 0);
        this.sashComposite.setLayout(new FormLayout());
        FormData formData = new FormData();
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        formData.top = new FormAttachment(this.itemManager.getCoolbar(), 5);
        formData.bottom = new FormAttachment(100, 0);
        this.sashComposite.setLayoutData(formData);
        this.sash = new Sash(this.sashComposite, 258);
        formData = new FormData();
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        formData.top = new FormAttachment(75, 0);
        this.sash.setLayoutData(formData);
        this.tablatureEditor.showTablature(this.sashComposite);
        formData = new FormData();
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        formData.top = new FormAttachment(0, 0);
        formData.bottom = new FormAttachment(this.sash, 0);
        this.tablatureEditor.getTablature().setLayoutData(formData);
        this.tableViewer.showTable(this.sashComposite);
        formData = new FormData();
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        formData.top = new FormAttachment(this.sash, 10);
        formData.bottom = new FormAttachment(100, 0);
        this.tableViewer.getTableInfo().setLayoutData(formData);
        this.sash.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                int n = selectionEvent.y * 100 / ((TuxGuitar)TuxGuitar.this).sashComposite.getBounds().height;
                n = Math.max(n, 0);
                n = Math.min(n, 100);
                ((FormData)((TuxGuitar)TuxGuitar.this).sash.getLayoutData()).top = new FormAttachment(n, 0);
            }
        });
        this.sash.addMouseListener(new MouseAdapter(){

            public void mouseUp(MouseEvent mouseEvent) {
                TuxGuitar.this.sash.getParent().layout();
            }
        });
        formData = new FormData();
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        formData.top = new FormAttachment(this.sashComposite, 0);
        formData.bottom = new FormAttachment(100, 0);
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout(new FormLayout());
        composite2.setLayoutData(formData);
        this.fretBoardEditor.showFretBoard(composite2);
    }

    public void checkSoundbank() {
        boolean bl = this.getConfig().getBooleanConfigValue("soundbank.custom");
        if (bl && !this.getPlayer().loadSoundbank(new File(this.getConfig().getStringConfigValue("soundbank.custom.path")))) {
            String string = TuxGuitar.getProperty("soundbank.error");
            String string2 = TuxGuitar.getProperty("soundbank.error.custom");
            new MessageDialog(string, string2, 33).show(this.shell);
        }
    }

    public void initPlayer(boolean bl) {
        if (this.getPlayer() == null || bl) {
            MidiPlayer midiPlayer = null;
            Object object = ClassLoaderUtil.newInstance(this.getConfig().getStringConfigValue("system.player"));
            if (object instanceof MidiPlayer) {
                midiPlayer = (MidiPlayer)object;
            }
            if (midiPlayer == null) {
                midiPlayer = new NullPlayer();
            }
            this.initPlayer(midiPlayer);
        }
    }

    public void initPlayer(MidiPlayer midiPlayer) {
        if (this.player != null) {
            this.player.close();
        }
        this.player = midiPlayer;
        for (SystemError systemError : midiPlayer.getSystemErrors()) {
            new MessageDialog(systemError.getTitle(), systemError.getMessage(), 33).show(this.shell);
        }
    }

    public void showDefaultControls() {
        if (this.getConfig().getBooleanConfigValue("show.fretboard")) {
            this.getFretBoardEditor().showFretBoard();
        } else {
            this.getFretBoardEditor().hideFretBoard();
        }
        if (this.getConfig().getBooleanConfigValue("show.mixer")) {
            new SyncThread(new Runnable(){

                public void run() {
                    TuxGuitar.this.getMixer().show();
                }
            }).start();
        } else {
            this.getMixer().dispose();
        }
        if (this.getConfig().getBooleanConfigValue("show.transport")) {
            new SyncThread(new Runnable(){

                public void run() {
                    TuxGuitar.this.getTransport().show();
                }
            }).start();
        } else {
            this.getTransport().dispose();
        }
        if (this.getConfig().getBooleanConfigValue("show.piano")) {
            new SyncThread(new Runnable(){

                public void run() {
                    TuxGuitar.this.getPianoEditor().show();
                }
            }).start();
        } else {
            this.getPianoEditor().dispose();
        }
    }

    public void updateShellFooter(int n, int n2, int n3) {
        n2 = Math.max(640, n2);
        n3 = Math.max(480, n3);
        FormData formData = (FormData)this.sashComposite.getLayoutData();
        formData.bottom.offset = -n;
        this.shell.setMinimumSize(n2, n3);
        this.shell.layout();
    }

    public TablatureEditor getTablatureEditor() {
        return this.tablatureEditor;
    }

    public FretBoardEditor getFretBoardEditor() {
        return this.fretBoardEditor;
    }

    public PianoEditor getPianoEditor() {
        return this.pianoEditor;
    }

    private void initItems() {
        this.itemManager = new ItemManager(this.tablatureEditor);
        this.itemManager.createItems(this.shell);
    }

    private void initActions() {
        this.actionContainer = new ActionContainer(this.tablatureEditor);
        this.actionContainer.initActions();
    }

    private void initConfigManager() {
        this.configManager = new ConfigManager();
        this.configManager.init();
    }

    private void adjustKeyBindings() {
        this.keyBindingManager = new KeyBindingManager();
        this.keyBindingManager.init();
    }

    private void initPluginManager() {
        this.pluginManager = new PluginManager();
        this.pluginManager.loadPlugins();
        this.pluginManager.initPLugins();
    }

    public SongManager getSongManager() {
        return this.songManager;
    }

    public SongMixer getMixer() {
        return this.songMixer;
    }

    public SongTransport getTransport() {
        return this.songTransport;
    }

    public SongTableViewer getTableViewer() {
        return this.tableViewer;
    }

    public EditorCache getEditorCache() {
        return this.editorCache;
    }

    public LyricEditor getLyricEditor() {
        return this.lyricEditor;
    }

    public MusicScaleManager getScaleManager() {
        return this.scaleManager;
    }

    public PluginManager getPluginManager() {
        return this.pluginManager;
    }

    public CustomChordManager getCustomChordManager() {
        return this.customChordManager;
    }

    public MidiPlayer getPlayer() {
        return this.player;
    }

    public void showTitle() {
        this.getShell().setText(WindowTitleUtil.parseTitle());
    }

    public void updateCache(boolean bl) {
        this.getEditorCache().updateCaretMode();
        if (bl) {
            this.getItemManager().updateItems();
            this.getTransport().updateItems();
            this.getLyricEditor().updateSongTrack();
        }
    }

    public void redraw() {
        if (!this.getDisplay().isDisposed()) {
            this.tablatureEditor.getTablature().redraw();
            this.fretBoardEditor.redraw();
            this.pianoEditor.redraw();
            this.tableViewer.getTableInfo().redraw();
        }
    }

    public void redrawPayingMode() {
        if (!this.getDisplay().isDisposed()) {
            this.editorCache.updatePlayingMode();
            if (this.editorCache.shouldRedraw()) {
                this.tablatureEditor.getTablature().redrawPlayingMode();
                this.fretBoardEditor.redrawPlayingMode();
                this.pianoEditor.redrawPlayingMode();
                this.tableViewer.getTableInfo().redrawPlayingMode();
                this.songTransport.redraw();
            }
        }
    }

    public void fireUpdate() {
        this.editorCache.reset();
        this.tablatureEditor.getTablature().updateTablature();
        this.tableViewer.getTableInfo().fireUpdate();
    }

    public Display getDisplay() {
        return this.display;
    }

    public Shell getShell() {
        return this.shell;
    }

    public Action getAction(String string) {
        return this.actionContainer.getAction(string);
    }

    public ItemManager getItemManager() {
        return this.itemManager;
    }

    public ActionContainer getActionContainer() {
        return this.actionContainer;
    }

    public LanguageManager getLanguageManager() {
        return this.languageManager;
    }

    public static String getProperty(String string) {
        return TuxGuitar.instance().languageManager.getProperty(string);
    }

    public ConfigManager getConfig() {
        return this.configManager;
    }

    public KeyBindingManager getkeyBindingManager() {
        return this.keyBindingManager;
    }

    public FileHistory getFileHistory() {
        return this.fileHistory;
    }

    public static boolean isDisposed() {
        return TuxGuitar.instance().getDisplay().isDisposed();
    }

    public void showErrorMessage(final Throwable throwable) {
        new SyncThread(new Runnable(){

            public void run() {
                throwable.printStackTrace();
                String string = TuxGuitar.getProperty("error");
                String string2 = throwable.toString();
                new MessageDialog(string, string2, 1).show(TuxGuitar.this.shell);
            }
        }).start();
    }

    public void loadLanguage() {
        this.getLanguageManager().setLanguage(this.getConfig().getStringConfigValue("language"));
    }

    public void loadProperties() {
        this.getItemManager().loadProperties();
        this.getTableViewer().getTableInfo().loadProperties();
        this.getFretBoardEditor().loadProperties();
        this.getPianoEditor().loadProperties();
        this.getMixer().loadProperties();
        this.getTransport().loadProperties();
    }

    public void loadToolBars() {
        this.getItemManager().makeCoolItems();
    }

    public void loadStyles() {
        this.getTablatureEditor().getTablature().reloadStyles();
    }
}

