package synth;
import javax.sound.midi.MidiChannel;
import javax.sound.midi.MidiUnavailableException;

import org.herac.tuxguitar.play.models.defaultplayer.DefinedControllers;

public class MidiChannelImpl implements MidiChannel{
	private int channel;
	private boolean solo;
	private boolean mute;
	private int volume;	
	private SynthesizerImpl synthesizer;	
	
	public MidiChannelImpl(int channel,SynthesizerImpl synthesizer){
		this.channel = channel;
		this.synthesizer = synthesizer;
	}
	
	public void noteOn(int noteNumber, int velocity) {
		try {
			getSynthesizer().getReceiver().noteOn(channel,noteNumber,velocity);
		} catch (MidiUnavailableException e) {
			e.printStackTrace();
		}		
	}

	public void noteOff(int noteNumber, int velocity) {
		try {
			getSynthesizer().getReceiver().noteOff(channel,noteNumber,velocity);
		} catch (MidiUnavailableException e) {
			e.printStackTrace();
		}		
	}

	public void noteOff(int noteNumber) {
		try {
			getSynthesizer().getReceiver().noteOff(channel,noteNumber,0);
		} catch (MidiUnavailableException e) {
			e.printStackTrace();
		}
	}

	public void setPolyPressure(int noteNumber, int pressure) {		
	}

	public int getPolyPressure(int noteNumber) {
		return 0;
	}

	public void setChannelPressure(int pressure) {		
	}

	public int getChannelPressure() {
		return 0;
	}

	public void controlChange(int controller, int value) {
		try {	
			boolean sendEvent = true;			
			if(controller == DefinedControllers.VOLUME){
				volume = value;
				if(!getSolo() && (getMute() || getSynthesizer().isAnyChannelSolo())){
					sendEvent = false;
				}	
			}			
			if(sendEvent){				
				getSynthesizer().getReceiver().controlChange(channel,controller,value);
			}
		} catch (MidiUnavailableException e) {
			e.printStackTrace();
		}
	}

	public int getController(int controller) {
		return 0;
	}

	public void programChange(int program) {
		programChange(0,program);
	}

	public void programChange(int bank, int program) {
		try {
			getSynthesizer().getReceiver().programChange(channel,program);
		} catch (MidiUnavailableException e) {
			e.printStackTrace();
		}
	}

	public int getProgram() {
		return 0;
	}

	public void setPitchBend(int bend) {		
	}

	public int getPitchBend() {
		return 0;
	}

	public void resetAllControllers() {		
	}

	public void allNotesOff() {
		
	}

	public void allSoundOff() {		
	}

	public boolean localControl(boolean on) {
		return false;
	}

	public void setMono(boolean on) {		
	}

	public boolean getMono() {
		return false;
	}

	public void setOmni(boolean on) {		
	}

	public boolean getOmni() {
		return false;
	}

	public void setMute(boolean mute) {
		try {				
			if(mute && !getMute()){			
				getSynthesizer().getReceiver().controlChange(channel,DefinedControllers.VOLUME,0);			
			}else if(!mute && getMute() && !getSynthesizer().isAnyChannelSolo()){
				getSynthesizer().getReceiver().controlChange(channel,DefinedControllers.VOLUME,volume);
			}
			this.mute = mute;
		} catch (MidiUnavailableException e) {
			e.printStackTrace();
		}
	}

	public boolean getMute() {
		return mute;
	}

	public void setSolo(boolean soloState) {	
		this.solo = soloState;
		getSynthesizer().setSolo(channel,soloState);		
		if(soloState){				
			this.mute = false;				
		}	
	}

	public boolean getSolo() {
		return this.solo;
	}
	
	public void fireSoloChannelEnabled(){
		try {		
			if(getSolo()){				
				getSynthesizer().getReceiver().controlChange(channel,DefinedControllers.VOLUME,volume);
			}else{
				getSynthesizer().getReceiver().controlChange(channel,DefinedControllers.VOLUME,0);
			}
		} catch (MidiUnavailableException e) {
			e.printStackTrace();
		}		
	}

	public void fireSoloChannelDisabled(){
		try {		
			if(!getMute()){
				getSynthesizer().getReceiver().controlChange(channel,DefinedControllers.VOLUME,volume);
			}
		} catch (MidiUnavailableException e) {
			e.printStackTrace();
		}		
	}	
	
	private SynthesizerImpl getSynthesizer(){
		return synthesizer;
	}

}
