/*
 * Created on 09-ene-2006
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package plugin;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

import org.herac.tuxguitar.gui.util.TuxGuitarFileUtils;

/**
 * @author julian
 * 
 * TODO To change the template for this generated type comment go to Window - Preferences - Java - Code Style - Code Templates
 */
public class Config {
	private static final String CONFIG_FILE = "tuxguitar-alsa.properties";
    private Properties properties;  
    
    public Config() {
    	this.properties = new Properties();
    	this.init();
    }

    public void init(){    	
    	this.load();
    }
    
    private String getProperty(String key) {      
        return this.properties.getProperty(key);    
    }    

    public String getStringConfigValue(String key) {
    	String property = getProperty(key); 
        return (property == null)?null:property.trim();
    }
    
    public int getIntConfigValue(String key,int defaultValue) {
        String value = getProperty(key);        		
        return (value == null)?defaultValue:Integer.parseInt(value.trim());
    }   
    
    public boolean getBooleanConfigValue(String key,boolean defaultValue) {
        String value = getProperty(key);
        return (value == null)?defaultValue:Boolean.valueOf(value.trim()).booleanValue();
    }   

    public void setProperty(String key,String value){
        this.properties.setProperty(key,value);
    }
    
    public void setProperty(String key,int value){
        setProperty(key,Integer.toString(value));
    }
    
    public void setProperty(String key,boolean value){
        setProperty(key,Boolean.toString(value));
    }
    
    
    public void removeProperty(String key){
        this.properties.remove(key);
    }
    
    public void clear(){
        this.properties.clear();
    }
    
    public void load() {       
        try {                    
        	if(new File(getFileName()).exists()){        	
        		InputStream inputStream = new FileInputStream(getFileName());                        
        		this.properties.clear();
        		this.properties.load(inputStream);
        	}else{
        		this.save();
        	}
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
    
    public void save(){
        try {
            properties.store(new FileOutputStream(getFileName()),"TuxGuitar-alsa Configuration");
        } catch (FileNotFoundException e1) {
            e1.printStackTrace();
        } catch (IOException e1) {
            e1.printStackTrace();
        }
    }
    
    private String getFileName(){
    	return TuxGuitarFileUtils.USER_CONFIG_PREFIX + File.separator + CONFIG_FILE;
    }

}