/*
 * Decompiled with CFR 0.152.
 */
package synth;

import java.util.ArrayList;
import java.util.List;
import javax.sound.midi.Instrument;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Patch;
import javax.sound.midi.Receiver;
import javax.sound.midi.Soundbank;
import javax.sound.midi.Synthesizer;
import javax.sound.midi.Transmitter;
import javax.sound.midi.VoiceStatus;
import synth.MidiChannelImpl;
import synth.ReceiverImpl;
import synth.SoundBankImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SynthesizerImpl
implements Synthesizer {
    private boolean open;
    private boolean anyChannelSolo;
    private ReceiverImpl receiver;
    private Soundbank soundbank;
    private MidiChannelImpl[] channels;

    public SynthesizerImpl(ReceiverImpl receiverImpl) {
        this.receiver = receiverImpl;
        this.soundbank = new SoundBankImpl();
        this.channels = new MidiChannelImpl[16];
        for (int i = 0; i < this.channels.length; ++i) {
            this.channels[i] = new MidiChannelImpl(i, this);
        }
    }

    @Override
    public int getMaxPolyphony() {
        return 0;
    }

    @Override
    public long getLatency() {
        return 0L;
    }

    public MidiChannelImpl[] getChannels() {
        return this.channels;
    }

    @Override
    public VoiceStatus[] getVoiceStatus() {
        return null;
    }

    @Override
    public boolean isSoundbankSupported(Soundbank soundbank) {
        return false;
    }

    @Override
    public boolean loadInstrument(Instrument instrument) {
        return false;
    }

    @Override
    public void unloadInstrument(Instrument instrument) {
    }

    @Override
    public boolean remapInstrument(Instrument instrument, Instrument instrument2) {
        return false;
    }

    @Override
    public Soundbank getDefaultSoundbank() {
        return this.soundbank;
    }

    @Override
    public Instrument[] getAvailableInstruments() {
        return this.soundbank.getInstruments();
    }

    @Override
    public Instrument[] getLoadedInstruments() {
        return this.soundbank.getInstruments();
    }

    @Override
    public boolean loadAllInstruments(Soundbank soundbank) {
        return false;
    }

    @Override
    public void unloadAllInstruments(Soundbank soundbank) {
    }

    @Override
    public boolean loadInstruments(Soundbank soundbank, Patch[] patchArray) {
        return false;
    }

    @Override
    public void unloadInstruments(Soundbank soundbank, Patch[] patchArray) {
    }

    @Override
    public MidiDevice.Info getDeviceInfo() {
        return null;
    }

    @Override
    public void open() throws MidiUnavailableException {
        this.open = true;
        this.receiver.open();
    }

    @Override
    public void close() {
        this.open = false;
        this.receiver.close();
    }

    @Override
    public boolean isOpen() {
        return this.open;
    }

    @Override
    public long getMicrosecondPosition() {
        return 0L;
    }

    @Override
    public int getMaxReceivers() {
        return 0;
    }

    @Override
    public int getMaxTransmitters() {
        return 0;
    }

    @Override
    public ReceiverImpl getReceiver() throws MidiUnavailableException {
        return this.receiver;
    }

    @Override
    public List<Receiver> getReceivers() {
        ArrayList<Receiver> arrayList = new ArrayList<Receiver>();
        arrayList.add(this.receiver);
        return arrayList;
    }

    @Override
    public Transmitter getTransmitter() throws MidiUnavailableException {
        return null;
    }

    @Override
    public List<Transmitter> getTransmitters() {
        return null;
    }

    public void setSolo(int n, boolean bl) {
        if (bl) {
            this.anyChannelSolo = true;
            for (int i = 0; i < this.getChannels().length; ++i) {
                this.getChannels()[i].fireSoloChannelEnabled();
            }
        } else {
            int n2;
            this.anyChannelSolo = false;
            for (n2 = 0; n2 < this.getChannels().length; ++n2) {
                if (!this.getChannels()[n2].getSolo()) continue;
                this.anyChannelSolo = true;
                break;
            }
            if (this.anyChannelSolo) {
                for (n2 = 0; n2 < this.getChannels().length; ++n2) {
                    this.getChannels()[n2].fireSoloChannelEnabled();
                }
            } else {
                for (n2 = 0; n2 < this.getChannels().length; ++n2) {
                    this.getChannels()[n2].fireSoloChannelDisabled();
                }
            }
        }
    }

    public boolean isAnyChannelSolo() {
        return this.anyChannelSolo;
    }
}

