/*
 * Decompiled with CFR 0.152.
 */
package synth;

import javax.sound.midi.MidiChannel;
import javax.sound.midi.MidiUnavailableException;
import synth.SynthesizerImpl;

public class MidiChannelImpl
implements MidiChannel {
    private int channel;
    private boolean solo;
    private boolean mute;
    private int volume;
    private SynthesizerImpl synthesizer;

    public MidiChannelImpl(int n, SynthesizerImpl synthesizerImpl) {
        this.channel = n;
        this.synthesizer = synthesizerImpl;
    }

    public void noteOn(int n, int n2) {
        try {
            this.getSynthesizer().getReceiver().noteOn(this.channel, n, n2);
        }
        catch (MidiUnavailableException midiUnavailableException) {
            midiUnavailableException.printStackTrace();
        }
    }

    public void noteOff(int n, int n2) {
        try {
            this.getSynthesizer().getReceiver().noteOff(this.channel, n, n2);
        }
        catch (MidiUnavailableException midiUnavailableException) {
            midiUnavailableException.printStackTrace();
        }
    }

    public void noteOff(int n) {
        try {
            this.getSynthesizer().getReceiver().noteOff(this.channel, n, 0);
        }
        catch (MidiUnavailableException midiUnavailableException) {
            midiUnavailableException.printStackTrace();
        }
    }

    public void setPolyPressure(int n, int n2) {
    }

    public int getPolyPressure(int n) {
        return 0;
    }

    public void setChannelPressure(int n) {
    }

    public int getChannelPressure() {
        return 0;
    }

    public void controlChange(int n, int n2) {
        try {
            boolean bl = true;
            if (n == 7) {
                this.volume = n2;
                if (!this.getSolo() && (this.getMute() || this.getSynthesizer().isAnyChannelSolo())) {
                    bl = false;
                }
            }
            if (bl) {
                this.getSynthesizer().getReceiver().controlChange(this.channel, n, n2);
            }
        }
        catch (MidiUnavailableException midiUnavailableException) {
            midiUnavailableException.printStackTrace();
        }
    }

    public int getController(int n) {
        return 0;
    }

    public void programChange(int n) {
        this.programChange(0, n);
    }

    public void programChange(int n, int n2) {
        try {
            this.getSynthesizer().getReceiver().programChange(this.channel, n2);
        }
        catch (MidiUnavailableException midiUnavailableException) {
            midiUnavailableException.printStackTrace();
        }
    }

    public int getProgram() {
        return 0;
    }

    public void setPitchBend(int n) {
    }

    public int getPitchBend() {
        return 0;
    }

    public void resetAllControllers() {
    }

    public void allNotesOff() {
    }

    public void allSoundOff() {
    }

    public boolean localControl(boolean bl) {
        return false;
    }

    public void setMono(boolean bl) {
    }

    public boolean getMono() {
        return false;
    }

    public void setOmni(boolean bl) {
    }

    public boolean getOmni() {
        return false;
    }

    public void setMute(boolean bl) {
        try {
            if (bl && !this.getMute()) {
                this.getSynthesizer().getReceiver().controlChange(this.channel, 7, 0);
            } else if (!bl && this.getMute() && !this.getSynthesizer().isAnyChannelSolo()) {
                this.getSynthesizer().getReceiver().controlChange(this.channel, 7, this.volume);
            }
            this.mute = bl;
        }
        catch (MidiUnavailableException midiUnavailableException) {
            midiUnavailableException.printStackTrace();
        }
    }

    public boolean getMute() {
        return this.mute;
    }

    public void setSolo(boolean bl) {
        this.solo = bl;
        this.getSynthesizer().setSolo(this.channel, bl);
        if (bl) {
            this.mute = false;
        }
    }

    public boolean getSolo() {
        return this.solo;
    }

    public void fireSoloChannelEnabled() {
        try {
            if (this.getSolo()) {
                this.getSynthesizer().getReceiver().controlChange(this.channel, 7, this.volume);
            } else {
                this.getSynthesizer().getReceiver().controlChange(this.channel, 7, 0);
            }
        }
        catch (MidiUnavailableException midiUnavailableException) {
            midiUnavailableException.printStackTrace();
        }
    }

    public void fireSoloChannelDisabled() {
        try {
            if (!this.getMute()) {
                this.getSynthesizer().getReceiver().controlChange(this.channel, 7, this.volume);
            }
        }
        catch (MidiUnavailableException midiUnavailableException) {
            midiUnavailableException.printStackTrace();
        }
    }

    private SynthesizerImpl getSynthesizer() {
        return this.synthesizer;
    }
}

