/*
 * Decompiled with CFR 0.152.
 */
package plugin;

import javax.sound.midi.MidiUnavailableException;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.plugins.TGPluginItem;
import plugin.TGPluginImpl;
import synth.MidiDevice;

public class TGPluginItemImpl
implements TGPluginItem {
    private TGPluginImpl plugin;

    public TGPluginItemImpl(TGPluginImpl tGPluginImpl) {
        this.plugin = tGPluginImpl;
    }

    public boolean isEnabled() {
        return true;
    }

    public MenuItem getMenuItem(final Menu menu) {
        MenuItem menuItem = new MenuItem(menu, 8);
        menuItem.setText("Tuxguitar-alsa Plugin");
        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TGPluginItemImpl.this.showConfigDialog(menu.getShell());
            }
        });
        return menuItem;
    }

    private void showConfigDialog(Shell shell) {
        try {
            MidiDevice midiDevice;
            final Shell shell2 = new Shell(shell, 67680);
            shell2.setLayout((Layout)new GridLayout());
            shell2.setText("Tuxguitar-alsa Plugin");
            Composite composite = new Composite((Composite)shell2, 0);
            composite.setLayout((Layout)new GridLayout());
            composite.setLayoutData((Object)new GridData(4, 4, true, true));
            final Button button = new Button(composite, 32);
            button.setText("Active plugin");
            button.setSelection(this.plugin.isEnabled());
            Composite composite2 = new Composite((Composite)shell2, 0);
            composite2.setLayout((Layout)new GridLayout(2, false));
            composite2.setLayoutData((Object)new GridData(4, 4, true, true));
            Label label = new Label(composite2, 0);
            label.setText("Device: ");
            final Combo combo = new Combo(composite2, 4);
            combo.setLayoutData((Object)new GridData(0x1000008, 4, true, true));
            combo.setEnabled(button.getSelection());
            for (int i = 0; i < this.plugin.getSynthesizer().getReceiver().getDevices().size(); ++i) {
                midiDevice = (MidiDevice)this.plugin.getSynthesizer().getReceiver().getDevices().get(i);
                combo.add(midiDevice.getName() + " " + midiDevice.getClient() + ":" + midiDevice.getPort());
                if (i != this.plugin.getSynthesizer().getReceiver().getDevice()) continue;
                combo.select(i);
            }
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    combo.setEnabled(button.getSelection());
                }
            });
            Composite composite3 = new Composite((Composite)shell2, 0);
            composite3.setLayout((Layout)new GridLayout(2, false));
            composite3.setLayoutData((Object)new GridData(0x1000008, 4, true, true));
            midiDevice = new GridData(4, 4, true, true);
            ((GridData)midiDevice).minimumWidth = 80;
            ((GridData)midiDevice).minimumHeight = 25;
            Button button2 = new Button(composite3, 8);
            button2.setText(TuxGuitar.getProperty((String)"ok"));
            button2.setLayoutData((Object)midiDevice);
            button2.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    TGPluginItemImpl.this.selectDevice(combo.getSelectionIndex(), button.getSelection());
                    shell2.dispose();
                }
            });
            Button button3 = new Button(composite3, 8);
            button3.setLayoutData((Object)midiDevice);
            button3.setText(TuxGuitar.getProperty((String)"cancel"));
            button3.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    shell2.dispose();
                }
            });
            shell2.pack();
            shell2.open();
            int n = shell.getBounds().x + (shell.getBounds().width - shell2.getSize().x) / 2;
            int n2 = shell.getBounds().y + (shell.getBounds().height - shell2.getSize().y) / 2;
            shell2.setLocation(n, n2);
            while (!shell2.isDisposed()) {
                if (shell2.getDisplay().readAndDispatch()) continue;
                shell2.getDisplay().sleep();
            }
        }
        catch (MidiUnavailableException midiUnavailableException) {
            midiUnavailableException.printStackTrace();
        }
    }

    private void selectDevice(int n, boolean bl) {
        this.plugin.changeConfig(n, bl);
    }
}

