package synth;
import java.util.ArrayList;
import java.util.List;

import javax.sound.midi.Instrument;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Patch;
import javax.sound.midi.Receiver;
import javax.sound.midi.Soundbank;
import javax.sound.midi.Synthesizer;
import javax.sound.midi.Transmitter;
import javax.sound.midi.VoiceStatus;

public class SynthesizerImpl implements Synthesizer{
	private boolean open;
	private boolean anyChannelSolo;
	private ReceiverImpl receiver;
	private Soundbank soundbank;
	private MidiChannelImpl[] channels;
	
	public SynthesizerImpl(ReceiverImpl receiver){
		this.receiver = receiver;
		this.soundbank = new SoundBankImpl();
		this.channels = new MidiChannelImpl[16];
		for(int i = 0;i < channels.length;i ++){
			this.channels[i] = new MidiChannelImpl(i,this);
		}
	}
	
	public int getMaxPolyphony() {
		return 0;
	}

	public long getLatency() {
		return 0;
	}

	public MidiChannelImpl[] getChannels() {
		return channels;
	}

	public VoiceStatus[] getVoiceStatus() {
		return null;
	}

	public boolean isSoundbankSupported(Soundbank soundbank) {
		return false;
	}

	public boolean loadInstrument(Instrument instrument) {
		return false;
	}

	public void unloadInstrument(Instrument instrument) {
		
	}

	public boolean remapInstrument(Instrument from, Instrument to) {
		return false;
	}

	public Soundbank getDefaultSoundbank() {
		return soundbank;
	}

	public Instrument[] getAvailableInstruments() {
		return soundbank.getInstruments();
	}

	public Instrument[] getLoadedInstruments() {
		return soundbank.getInstruments();
	}

	public boolean loadAllInstruments(Soundbank soundbank) {
		return false;
	}

	public void unloadAllInstruments(Soundbank soundbank) {		
	}

	public boolean loadInstruments(Soundbank soundbank, Patch[] patchList) {
		return false;
	}

	public void unloadInstruments(Soundbank soundbank, Patch[] patchList) {		
	}

	public Info getDeviceInfo() {
		return null;
	}

	public void open() throws MidiUnavailableException {
		this.open = true;
		this.receiver.open();
	}

	public void close() {		
		this.open = false;
		this.receiver.close();
	}

	public boolean isOpen() {
		return open;
	}

	public long getMicrosecondPosition() {
		return 0;
	}

	public int getMaxReceivers() {
		return 0;
	}

	public int getMaxTransmitters() {
		return 0;
	}

	public ReceiverImpl getReceiver() throws MidiUnavailableException {
		return receiver;
	}

	public List<Receiver> getReceivers() {
		List receivers = new ArrayList();
		receivers.add(receiver);
		return receivers;
	}

	public Transmitter getTransmitter() throws MidiUnavailableException {
		return null;
	}

	public List<Transmitter> getTransmitters() {
		return null;
	}

	
	public void setSolo(int channel,boolean solo){
		if(solo){
			anyChannelSolo = true;
			for(int i = 0; i < getChannels().length;i++){
				getChannels()[i].fireSoloChannelEnabled();					
			}
		}
		else{
			anyChannelSolo = false;
			for(int i = 0; i < getChannels().length;i++){
				if(getChannels()[i].getSolo()){
					anyChannelSolo = true;
					break;
				}
			}
			if(anyChannelSolo){
				for(int i = 0; i < getChannels().length;i++){
					getChannels()[i].fireSoloChannelEnabled();					
				}
			}else{			
				for(int i = 0; i < getChannels().length;i++){
					getChannels()[i].fireSoloChannelDisabled();					
				}
			}
		}

	}

	
	public boolean isAnyChannelSolo(){
		return anyChannelSolo;
	}

}
