package synth;
import javax.sound.midi.Instrument;
import javax.sound.midi.Patch;
import javax.sound.midi.Soundbank;
import javax.sound.midi.SoundbankResource;

public class SoundBankImpl implements Soundbank {

	private Instrument[] instruments;
	
	public SoundBankImpl(){
		loadInstruments();
	}
	
	public String getName() {
		return null;
	}

	public String getVersion() {
		return null;
	}

	public String getVendor() {
		return null;
	}

	public String getDescription() {
		return null;
	}

	public SoundbankResource[] getResources() {
		return instruments;
	}

	public Instrument[] getInstruments() {
		return instruments;
	}

	public Instrument getInstrument(Patch patch) {
		for(int i = 0; i < instruments.length; i++){
			if(instruments[i].getPatch().getBank() == patch.getBank() && instruments[i].getPatch().getProgram() == patch.getProgram()){
				return instruments[i];
			}
		}
		return null;
	}
	
	private void loadInstruments(){
		int number = 0;
		this.instruments = new Instrument[]{						
			new InstrumentImpl(this,new Patch(0,number++),"Acustic piano",Instrument.class),
			new InstrumentImpl(this,new Patch(0,number++),"Bright piano",Instrument.class),
			new InstrumentImpl(this,new Patch(0,number++),"Synth piano",Instrument.class),
			new InstrumentImpl(this,new Patch(0,number++),"Honky tonky",Instrument.class),
			new InstrumentImpl(this,new Patch(0,number++),"Electric piano 1",Instrument.class),
			new InstrumentImpl(this,new Patch(0,number++),"Electric piano 2",Instrument.class),
			new InstrumentImpl(this,new Patch(0,number++),"Harpsichord",Instrument.class),
			new InstrumentImpl(this,new Patch(0,number++),"Clavinet",Instrument.class),
			new InstrumentImpl(this,new Patch(0,number++),"Celeste",Instrument.class),
			new InstrumentImpl(this,new Patch(0,number++),"Glockenspiel",Instrument.class),
			new InstrumentImpl(this,new Patch(0,number++),"Musicbox",Instrument.class),
			new InstrumentImpl(this,new Patch(0,number++),"Vibes",Instrument.class),
			new InstrumentImpl(this,new Patch(0,number++),"Marimba",Instrument.class),
			new InstrumentImpl(this,new Patch(0,number++),"Xylophon",Instrument.class),
			new InstrumentImpl(this,new Patch(0,number++),"TubeBell",Instrument.class),
			new InstrumentImpl(this,new Patch(0,number++),"Santur",Instrument.class),
			new InstrumentImpl(this,new Patch(0,number++),"Home Org",Instrument.class),
			new InstrumentImpl(this,new Patch(0,number++),"Percussion Org",Instrument.class),
			new InstrumentImpl(this,new Patch(0,number++),"Rock Org",Instrument.class),
			new InstrumentImpl(this,new Patch(0,number++),"Church Org",Instrument.class),
			new InstrumentImpl(this,new Patch(0,number++),"Reed Org",Instrument.class),
			new InstrumentImpl(this,new Patch(0,number++),"Accordion",Instrument.class),
			new InstrumentImpl(this,new Patch(0,number++),"Harmonica",Instrument.class),
			new InstrumentImpl(this,new Patch(0,number++),"Concrtna",Instrument.class),
			new InstrumentImpl(this,new Patch(0,number++),"Nylon guitar",Instrument.class),
			new InstrumentImpl(this,new Patch(0,number++),"Acustic guitar",Instrument.class),
			new InstrumentImpl(this,new Patch(0,number++),"Jazz guitar",Instrument.class),
			new InstrumentImpl(this,new Patch(0,number++),"Clean guitar",Instrument.class),
			new InstrumentImpl(this,new Patch(0,number++),"Mute guitar",Instrument.class),
			new InstrumentImpl(this,new Patch(0,number++),"Od guitar",Instrument.class),
			new InstrumentImpl(this,new Patch(0,number++),"Distortion guitar",Instrument.class),
			new InstrumentImpl(this,new Patch(0,number++),"Guitar Harmonic",Instrument.class),
			new InstrumentImpl(this,new Patch(0,number++),"Acustic bass",Instrument.class),
			new InstrumentImpl(this,new Patch(0,number++),"Finger bass",Instrument.class),
			new InstrumentImpl(this,new Patch(0,number++),"Pick bass",Instrument.class),
			new InstrumentImpl(this,new Patch(0,number++),"Fretless bass",Instrument.class),
			new InstrumentImpl(this,new Patch(0,number++),"Slap bass 1",Instrument.class),
			new InstrumentImpl(this,new Patch(0,number++),"Slap bass 2",Instrument.class),
			new InstrumentImpl(this,new Patch(0,number++),"Synth Bass 1",Instrument.class),
			new InstrumentImpl(this,new Patch(0,number++),"Synth Bass 2",Instrument.class),
			new InstrumentImpl(this,new Patch(0,number++),"Violin",Instrument.class),
			new InstrumentImpl(this,new Patch(0,number++),"Viola",Instrument.class),
			new InstrumentImpl(this,new Patch(0,number++),"Cello",Instrument.class),
			new InstrumentImpl(this,new Patch(0,number++),"Contrabajo",Instrument.class),
			new InstrumentImpl(this,new Patch(0,number++),"Marcato",Instrument.class),
			new InstrumentImpl(this,new Patch(0,number++),"Pizzicato",Instrument.class),
			new InstrumentImpl(this,new Patch(0,number++),"Harp",Instrument.class),
			new InstrumentImpl(this,new Patch(0,number++),"Timpani",Instrument.class),
			new InstrumentImpl(this,new Patch(0,number++),"Marcato",Instrument.class),
			new InstrumentImpl(this,new Patch(0,number++),"Slow strings",Instrument.class),
			new InstrumentImpl(this,new Patch(0,number++),"Synth strings 1",Instrument.class),
			new InstrumentImpl(this,new Patch(0,number++),"Synth strings 2",Instrument.class),
			new InstrumentImpl(this,new Patch(0,number++),"Choir",Instrument.class),
			new InstrumentImpl(this,new Patch(0,number++),"Doo",Instrument.class),
			new InstrumentImpl(this,new Patch(0,number++),"Voices",Instrument.class),
			new InstrumentImpl(this,new Patch(0,number++),"Orchestra Hit",Instrument.class),
			new InstrumentImpl(this,new Patch(0,number++),"Trumpet",Instrument.class),
			new InstrumentImpl(this,new Patch(0,number++),"Trombone",Instrument.class),
			new InstrumentImpl(this,new Patch(0,number++),"Tuba",Instrument.class),
			new InstrumentImpl(this,new Patch(0,number++),"Mute trumpet",Instrument.class),
			new InstrumentImpl(this,new Patch(0,number++),"French horn",Instrument.class),
			new InstrumentImpl(this,new Patch(0,number++),"Hit brass",Instrument.class),
			new InstrumentImpl(this,new Patch(0,number++),"Synth brass 1",Instrument.class),
			new InstrumentImpl(this,new Patch(0,number++),"Synth brass 2",Instrument.class),
			new InstrumentImpl(this,new Patch(0,number++),"Soprano sax",Instrument.class),
			new InstrumentImpl(this,new Patch(0,number++),"Alto sax",Instrument.class),
			new InstrumentImpl(this,new Patch(0,number++),"Tenor sax",Instrument.class),
			new InstrumentImpl(this,new Patch(0,number++),"Baritone sax",Instrument.class),
			new InstrumentImpl(this,new Patch(0,number++),"Oboe",Instrument.class),
			new InstrumentImpl(this,new Patch(0,number++),"English horn",Instrument.class),
			new InstrumentImpl(this,new Patch(0,number++),"Bassoon",Instrument.class),
			new InstrumentImpl(this,new Patch(0,number++),"Clarinet",Instrument.class),
			new InstrumentImpl(this,new Patch(0,number++),"Piccolo",Instrument.class),
			new InstrumentImpl(this,new Patch(0,number++),"Flute",Instrument.class),
			new InstrumentImpl(this,new Patch(0,number++),"Recorder",Instrument.class),
			new InstrumentImpl(this,new Patch(0,number++),"WoodFlute",Instrument.class),
			new InstrumentImpl(this,new Patch(0,number++),"Bottle",Instrument.class),
			new InstrumentImpl(this,new Patch(0,number++),"Shakazul",Instrument.class),
			new InstrumentImpl(this,new Patch(0,number++),"Whistle",Instrument.class),
			new InstrumentImpl(this,new Patch(0,number++),"Ocarina",Instrument.class),
			new InstrumentImpl(this,new Patch(0,number++),"Square wave",Instrument.class),
			new InstrumentImpl(this,new Patch(0,number++),"Saw wave",Instrument.class),
			new InstrumentImpl(this,new Patch(0,number++),"Calliope",Instrument.class),
			new InstrumentImpl(this,new Patch(0,number++),"Chiflead",Instrument.class),
			new InstrumentImpl(this,new Patch(0,number++),"Charang",Instrument.class),
			new InstrumentImpl(this,new Patch(0,number++),"Vox lead",Instrument.class),
			new InstrumentImpl(this,new Patch(0,number++),"Lead 5th",Instrument.class),
			new InstrumentImpl(this,new Patch(0,number++),"Bass lead",Instrument.class),
			new InstrumentImpl(this,new Patch(0,number++),"Fantasia",Instrument.class),
			new InstrumentImpl(this,new Patch(0,number++),"Warm pad",Instrument.class),
			new InstrumentImpl(this,new Patch(0,number++),"Polysyn",Instrument.class),
			new InstrumentImpl(this,new Patch(0,number++),"Ghostie",Instrument.class),
			new InstrumentImpl(this,new Patch(0,number++),"Bow glass",Instrument.class),
			new InstrumentImpl(this,new Patch(0,number++),"Metal pad",Instrument.class),
			new InstrumentImpl(this,new Patch(0,number++),"Halo pad",Instrument.class),
			new InstrumentImpl(this,new Patch(0,number++),"Sweeper",Instrument.class),
			new InstrumentImpl(this,new Patch(0,number++),"Aurora",Instrument.class),
			new InstrumentImpl(this,new Patch(0,number++),"Sound track",Instrument.class),
			new InstrumentImpl(this,new Patch(0,number++),"Crystal",Instrument.class),
			new InstrumentImpl(this,new Patch(0,number++),"Atmosphear",Instrument.class),
			new InstrumentImpl(this,new Patch(0,number++),"Fresh air",Instrument.class),
			new InstrumentImpl(this,new Patch(0,number++),"Unicorn",Instrument.class),
			new InstrumentImpl(this,new Patch(0,number++),"Sweeper",Instrument.class),
			new InstrumentImpl(this,new Patch(0,number++),"Star trak",Instrument.class),
			new InstrumentImpl(this,new Patch(0,number++),"Sitar",Instrument.class),
			new InstrumentImpl(this,new Patch(0,number++),"Banjo",Instrument.class),
			new InstrumentImpl(this,new Patch(0,number++),"Shamisen",Instrument.class),
			new InstrumentImpl(this,new Patch(0,number++),"Koto",Instrument.class),
			new InstrumentImpl(this,new Patch(0,number++),"Kalimba",Instrument.class),
			new InstrumentImpl(this,new Patch(0,number++),"Bag pipes",Instrument.class),
			new InstrumentImpl(this,new Patch(0,number++),"Fiddle",Instrument.class),
			new InstrumentImpl(this,new Patch(0,number++),"Shannai",Instrument.class),
			new InstrumentImpl(this,new Patch(0,number++),"Carillon",Instrument.class),
			new InstrumentImpl(this,new Patch(0,number++),"Agogo",Instrument.class),
			new InstrumentImpl(this,new Patch(0,number++),"Steel drum",Instrument.class),
			new InstrumentImpl(this,new Patch(0,number++),"WoodBlk",Instrument.class),
			new InstrumentImpl(this,new Patch(0,number++),"Taiko",Instrument.class),
			new InstrumentImpl(this,new Patch(0,number++),"Toms",Instrument.class),
			new InstrumentImpl(this,new Patch(0,number++),"Syntom",Instrument.class),
			new InstrumentImpl(this,new Patch(0,number++),"RevCymbal",Instrument.class),
			new InstrumentImpl(this,new Patch(0,number++),"Fx-Fret",Instrument.class),
			new InstrumentImpl(this,new Patch(0,number++),"Fx-Blow",Instrument.class),
			new InstrumentImpl(this,new Patch(0,number++),"Seashore",Instrument.class),
			new InstrumentImpl(this,new Patch(0,number++),"Jungle",Instrument.class),
			new InstrumentImpl(this,new Patch(0,number++),"Telephon",Instrument.class),
			new InstrumentImpl(this,new Patch(0,number++),"Helicopter",Instrument.class),
			new InstrumentImpl(this,new Patch(0,number++),"Applause",Instrument.class),
			new InstrumentImpl(this,new Patch(0,number++),"Gunshot",Instrument.class)			
		};				
	}
}
