package synth;

import java.util.ArrayList;
import java.util.List;

import javax.sound.midi.MidiMessage;
import javax.sound.midi.ShortMessage;

import jni.ReceiverJNI;

public class ReceiverImpl extends ReceiverJNI{
	
	private int device;
	private boolean open;
	private List devices = new ArrayList();
	
	public ReceiverImpl(int device){
		this.device = device;
		this.findDevices();
	}	

	public void open(){		
		open(this.device);
	}
	
	public void open(int device){
		if(devices.size() > device){
			if(open){
				close();
			}
			MidiDevice midiDevice = (MidiDevice)devices.get(device);
			openDevice(midiDevice.getClient(),midiDevice.getPort());
			this.device = device;
			this.open = true;
		}
	}

	public void close() {
		this.closeDevice();
		this.open = false;
	}	
	
	public int getDevice(){
		return this.device;
	}

	protected void addDevice(String name,int client,int port){	
		devices.add(new MidiDevice(name,client,port));					
	}

	public List getDevices(){
		return this.devices;
	}
	
	public void send(MidiMessage message, long timeStamp) {
		parseMessage(message.getMessage());
	}

	
	private void parseMessage(byte[] data){		
		int length = data.length;	
		
		//NOTE ON
		if((((length > 0)?(data[0] & 0xFF):0) & 0xF0) == ShortMessage.NOTE_ON){			
			parseNoteOn(data);
		}
		//NOTE OFF		
		else if((((length > 0)?(data[0] & 0xFF):0) & 0xF0) == ShortMessage.NOTE_OFF){
			parseNoteOff(data);
		}
		//PROGRAM CHANGE		
		else if((((length > 0)?(data[0] & 0xFF):0) & 0xF0) == ShortMessage.PROGRAM_CHANGE){
			parseProgramChange(data);
		}
		//CONTROL CHANGE		
		else if((((length > 0)?(data[0] & 0xFF):0) & 0xF0) == ShortMessage.CONTROL_CHANGE){
			parseControlChange(data);
		}		
		//PITCH BEND		
		else if((((length > 0)?(data[0] & 0xFF):0) & 0xF0) == ShortMessage.PITCH_BEND){
			parsePitchBend(data);
		}			
	}
	
	private void parseNoteOn(byte[] data){				
		int length = data.length;		
		int channel = (length > 0)?((data[0] & 0xFF) & 0x0F):0;
		int value = (length > 1)?(data[1] & 0xFF):0;
		int velocity = (length > 2)?(data[2] & 0xFF):0;
		
		if(velocity == 0){
			parseNoteOff(data);
		}else if(value > 0){			
			noteOn(channel,value,velocity);
		}
	}
	
	
	private void parseNoteOff(byte[] data){		
		int length = data.length;
		
		int channel = (length > 0)?((data[0] & 0xFF) & 0x0F):0;
		int value = (length > 1)?(data[1] & 0xFF):0;
		int velocity = (length > 2)?(data[2] & 0xFF):0;
		
		noteOff(channel,value,velocity);
	}	
	
	
	private void parseProgramChange(byte[] data){		
		int length = data.length;		
		int channel = (length > 0)?((data[0] & 0xFF) & 0x0F):-1;
		int instrument = (length > 1)?(data[1] & 0xFF):-1;
		if(channel != -1 && instrument != -1){
			programChange(channel,instrument);
		}
	}		

	private void parseControlChange(byte[] data){				
		int length = data.length;		
		int channel = (length > 0)?((data[0] & 0xFF) & 0x0F):-1;
		int control = (length > 1)?(data[1] & 0xFF):-1;
		int value = (length > 2)?(data[2] & 0xFF):-1;
		if(channel != -1 && control != -1 && value != -1){
			controlChange(channel,control,value);
		}
	}	
	
	private void parsePitchBend(byte[] data){				
		int length = data.length;		
		int channel = (length > 0)?((data[0] & 0xFF) & 0x0F):-1;
		int value = (length > 2)?(data[2] & 0xFF):-1;
		if(channel != -1 && value != -1){
			//alsa param val pitch bend; zero centered from -8192 to 8191
			pitchBend(channel,((value * 127) - 8191));
		}
	}		
}
