package plugin;

import javax.sound.midi.MidiUnavailableException;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.plugins.TGPluginItem;

import synth.MidiDevice;

public class TGPluginItemImpl implements TGPluginItem{

	private TGPluginImpl plugin;
	
	public TGPluginItemImpl(TGPluginImpl plugin){
		this.plugin = plugin;
	}
	
	public boolean isEnabled() {
		return true;
	}

	public MenuItem getMenuItem(final Menu menu) {
		MenuItem item = new MenuItem(menu,SWT.PUSH);
		item.setText("Tuxguitar-alsa Plugin");
		item.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent arg0) {
				showConfigDialog(menu.getShell());
			}		
		});
		
		return item;		
	}
	
	private void showConfigDialog(Shell shell){
		try {
        final Shell dialog = new Shell(shell, SWT.DIALOG_TRIM | SWT.APPLICATION_MODAL);

        dialog.setLayout(new GridLayout());
        dialog.setText("Tuxguitar-alsa Plugin");
        
        //-------------Enabled plugin--------------------------------------------
        Composite enabledComposite = new Composite(dialog, SWT.NONE);
        enabledComposite.setLayout(new GridLayout());
        enabledComposite.setLayoutData(new GridData(SWT.FILL,SWT.FILL,true,true));
        
        final Button enabled = new Button(enabledComposite,SWT.CHECK);
        enabled.setText("Active plugin");
        enabled.setSelection(plugin.isEnabled());

        //-------------Midi Device-----------------------------------------------
        Composite deviceComposite = new Composite(dialog, SWT.NONE);
        deviceComposite.setLayout(new GridLayout(2,false));
        deviceComposite.setLayoutData(new GridData(SWT.FILL,SWT.FILL,true,true));   
        
        
        Label label = new Label(deviceComposite, SWT.NULL);
        label.setText("Device: ");
        
        final Combo deviceCombo = new Combo(deviceComposite, SWT.DROP_DOWN);
        deviceCombo.setLayoutData(new GridData(SWT.END,SWT.FILL,true,true));
        deviceCombo.setEnabled(enabled.getSelection());
        for (int i = 0; i < plugin.getSynthesizer().getReceiver().getDevices().size(); i++) {
        	MidiDevice device = (MidiDevice)plugin.getSynthesizer().getReceiver().getDevices().get(i);
        	deviceCombo.add(device.getName() + " " + device.getClient() + ":" + device.getPort());
        	if(i == plugin.getSynthesizer().getReceiver().getDevice()){
        		deviceCombo.select(i);	
        	}
        }           

        
        enabled.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent arg0) {
				deviceCombo.setEnabled(enabled.getSelection());
			}		
		});
        
        //------------------BUTTONS--------------------------            
        Composite buttons = new Composite(dialog, SWT.NONE);
        buttons.setLayout(new GridLayout(2,false));
        buttons.setLayoutData(new GridData(SWT.END,SWT.FILL,true,true));    	
        
        GridData data = new GridData(SWT.FILL,SWT.FILL,true,true);    
        data.minimumWidth = 80;
        data.minimumHeight = 25;            
        
        
        final Button buttonOk = new Button(buttons, SWT.PUSH);
        buttonOk.setText(TuxGuitar.getProperty("ok"));
        buttonOk.setLayoutData(data);
        buttonOk.addSelectionListener(new SelectionAdapter() {
            public void widgetSelected(SelectionEvent arg0) {   
            	selectDevice(deviceCombo.getSelectionIndex(),enabled.getSelection());            	
                dialog.dispose();
            }
        });

        Button buttonCancel = new Button(buttons, SWT.PUSH);
        buttonCancel.setLayoutData(data);
        buttonCancel.setText(TuxGuitar.getProperty("cancel"));
        buttonCancel.addSelectionListener(new SelectionAdapter() {
            public void widgetSelected(SelectionEvent arg0) {
                dialog.dispose();
            }
        });

        dialog.pack();
        dialog.open();

        int x = shell.getBounds().x + (shell.getBounds().width - dialog.getSize().x) / 2;
        int y = shell.getBounds().y + (shell.getBounds().height - dialog.getSize().y) / 2;
        dialog.setLocation(x, y);
        
		while (!dialog.isDisposed()) {
            if (!dialog.getDisplay().readAndDispatch()) {
            	dialog.getDisplay().sleep();
            }
        }
		} catch (MidiUnavailableException e) {
			e.printStackTrace();
		}
	}
	
	private void selectDevice(int device,boolean enabled){
		plugin.changeConfig(device,enabled);
	}
}
