package plugin;

import javax.sound.midi.MidiUnavailableException;

import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.plugins.TGMidiPlugin;
import org.herac.tuxguitar.gui.plugins.TGPluginItem;

import synth.ReceiverImpl;
import synth.SynthesizerImpl;

public class TGPluginImpl implements TGMidiPlugin{
	private Config config;
	private SynthesizerImpl synthesizer;
	private TGPluginItemImpl item;
	private boolean enabled;
	
	public TGPluginImpl(){		
		this.config = new Config();
		this.enabled = this.config.getBooleanConfigValue("enabled",true);
		this.synthesizer = new SynthesizerImpl(new ReceiverImpl(this.config.getIntConfigValue("device",0)));
		this.item = new TGPluginItemImpl(this);	
	}
	
	public void init(TuxGuitar instance) {		
		if(enabled){
			//asigna el nuevo synthesizer
			instance.getSongManager().getPlayer().setSynthesizer(synthesizer);
			//recargo los textos para actualizar los instrumentos
			instance.loadProperties();
		}
	}
	
	public String getName() {
		return "Tuxguitar-alsa plugin";
	}

	public String getDescription() {
		return "Tuxguitar-alsa plugin";
	}

	public String getVersion() {
		return "test";
	}

	public String getVendor() {
		return "none";
	}

	public TGPluginItem getItem() {
		return this.item;
	}
	
	public SynthesizerImpl getSynthesizer(){
		return this.synthesizer;
	}
	
	public boolean isEnabled(){
		return this.enabled;
	}
	
	public void changeConfig(int device,boolean enabled){
		try {
			this.config.setProperty("device",device);
			this.config.setProperty("enabled",enabled);
			this.config.save();
			if(enabled){
				if(!this.enabled){
					TuxGuitar.instance().getSongManager().getPlayer().setSynthesizer(synthesizer);
					TuxGuitar.instance().loadProperties();
				}
				if(device != getSynthesizer().getReceiver().getDevice()){
					getSynthesizer().getReceiver().open(device);
				}
			}else{
				if(this.enabled){
					TuxGuitar.instance().getSongManager().getPlayer().setSynthesizer(null);
					TuxGuitar.instance().loadProperties();
				}
			}
			this.enabled = enabled;
		} catch (MidiUnavailableException e) {
			e.printStackTrace();
		}
	}
		
	public void close() {
		synthesizer.close();
	}

}
