//---------------------------------------------------------------------------------------------------------------------------------------------------------------//
//gcc -shared /usr/lib/libasound.so -I /usr/lib/jvm/java-1.5.0-sun/include/ -I /usr/lib/jvm/java-1.5.0-sun/include/linux/ -o libReceiverJNI.so jni_ReceiverJNI.c //
//---------------------------------------------------------------------------------------------------------------------------------------------------------------//
#include <stdio.h>
#include <alsa/asoundlib.h>
#include "jni_ReceiverJNI.h"

struct sequencerContext {
		snd_seq_t* handle;
		int queue;
		snd_seq_addr_t address;
		int port;
		snd_seq_port_subscribe_t *subs;
};

struct sequencerContext context;
snd_seq_addr_t address;

JNIEXPORT void JNICALL Java_jni_ReceiverJNI_findDevices(JNIEnv* env, jobject obj){
	snd_seq_client_info_t* clientInfo;

	if (snd_seq_open(&context.handle, "default", SND_SEQ_OPEN_OUTPUT, 0) < 0){
		return;
	}	
	
	snd_seq_client_info_alloca(&clientInfo);
	snd_seq_client_info_set_client(clientInfo, -1);

	// iterate through clients
	while (snd_seq_query_next_client(context.handle, clientInfo) >= 0) {
		snd_seq_port_info_t* pinfo;
		
		snd_seq_port_info_alloca(&pinfo);
		snd_seq_port_info_set_client(pinfo, snd_seq_client_info_get_client(clientInfo));
		snd_seq_port_info_set_port(pinfo, -1);
		
		// and now through ports
		while (snd_seq_query_next_port(context.handle, pinfo) >= 0) {
			unsigned int capability = snd_seq_port_info_get_capability(pinfo);
						
			if ((capability & SND_SEQ_PORT_CAP_SUBS_WRITE) == 0){
				continue;
			}
			jstring name = (*env)->NewStringUTF(env, snd_seq_port_info_get_name(pinfo));
			jint client  = (snd_seq_port_info_get_addr(pinfo))->client;
			jint port    = (snd_seq_port_info_get_addr(pinfo))->port;

			//Add a new MidiDevice to the java class		
			jclass cl = (*env)->GetObjectClass(env, obj);			 
			jmethodID mid = (*env)->GetMethodID(env, cl, "addDevice", "(Ljava/lang/String;II)V");  	
  			if (mid != 0){
  				(*env)->CallVoidMethod(env, obj, mid,name,client,port);
		  	}

		}
		
	}
	
	if (snd_seq_set_client_name(context.handle, "TuxGuitar") < 0){
		return;
	}
	
	context.address.port = snd_seq_create_simple_port(context.handle, "TuxGuitar Port 0", SND_SEQ_PORT_CAP_SUBS_WRITE, SND_SEQ_PORT_TYPE_APPLICATION);
	context.address.client = snd_seq_client_id (context.handle);
	context.queue = snd_seq_alloc_queue (context.handle);
	
	snd_seq_set_client_pool_output (context.handle, 1024);
}


JNIEXPORT void JNICALL Java_jni_ReceiverJNI_openDevice(JNIEnv* env, jobject obj, jint client, jint port)
{	
	address.client = client;
	address.port = port;	
	
	snd_seq_port_subscribe_alloca(&context.subs);
	
	snd_seq_port_subscribe_set_sender(context.subs, &context.address);
	snd_seq_port_subscribe_set_dest(context.subs, &address);	
	
	snd_seq_subscribe_port(context.handle, context.subs);	
}

JNIEXPORT void JNICALL Java_jni_ReceiverJNI_closeDevice(JNIEnv* env, jobject obj)
{
	snd_seq_port_subscribe_alloca(&context.subs);	
	snd_seq_port_subscribe_set_sender(context.subs, &context.address);
	snd_seq_port_subscribe_set_dest(context.subs, &address);		
	 
	if (snd_seq_unsubscribe_port(context.handle, context.subs) < 0){
		return;
	}		
	//snd_seq_port_subscribe_free(context.subs);
}




//************************************************************************************//
//************************************MIDI EVENTS*************************************//
//************************************************************************************//

JNIEXPORT void JNICALL Java_jni_ReceiverJNI_noteOn(JNIEnv* env, jobject ojb, jint channel, jint note, jint velocity)
{
	snd_seq_event_t event;
	
	snd_seq_ev_clear(&event);
	
	event.queue  = SND_SEQ_QUEUE_DIRECT;
	event.source = context.address;
	
	snd_seq_ev_set_subs(&event);
	snd_seq_ev_set_direct(&event);
	snd_seq_ev_set_noteon(&event, channel, note, velocity);
	
	snd_seq_event_output_direct(context.handle, &event);
	snd_seq_drain_output(context.handle);
}

JNIEXPORT void JNICALL Java_jni_ReceiverJNI_noteOff(JNIEnv* env, jobject ojb, jint channel, jint note, jint velocity)
{
	snd_seq_event_t event;
	
	snd_seq_ev_clear(&event);
	
	event.queue  = SND_SEQ_QUEUE_DIRECT;
	event.source = context.address;
	
	snd_seq_ev_set_subs(&event);
	snd_seq_ev_set_direct(&event);
	snd_seq_ev_set_noteoff(&event, channel, note, velocity);
	
	snd_seq_event_output_direct(context.handle, &event);
	snd_seq_drain_output(context.handle);
}

JNIEXPORT void JNICALL Java_jni_ReceiverJNI_programChange(JNIEnv* env, jobject ojb, jint channel, jint program)
{
	snd_seq_event_t event;
	
	snd_seq_ev_clear(&event);
	
	event.queue  = SND_SEQ_QUEUE_DIRECT;
	event.source = context.address;
	
	snd_seq_ev_set_subs(&event);
	snd_seq_ev_set_direct(&event);
	snd_seq_ev_set_pgmchange(&event, channel, program);
	
	if (snd_seq_event_output_direct(context.handle, &event) < 0){
		return;
	}
	snd_seq_drain_output(context.handle);
}

JNIEXPORT void JNICALL Java_jni_ReceiverJNI_controlChange(JNIEnv* env, jobject ojb, jint channel, jint control, jint value)
{
	snd_seq_event_t event;
	
	snd_seq_ev_clear(&event);
	
	event.queue  = SND_SEQ_QUEUE_DIRECT;
	event.source = context.address;
	
	snd_seq_ev_set_subs(&event);
	snd_seq_ev_set_direct(&event);
	snd_seq_ev_set_controller(&event, channel, control, value);
	
	if(snd_seq_event_output_direct(context.handle, &event) < 0){
		return;
	}		
	snd_seq_drain_output(context.handle);
}


JNIEXPORT void JNICALL Java_jni_ReceiverJNI_pitchBend(JNIEnv* env, jobject ojb, jint channel, jint value)
{
	snd_seq_event_t event;
	
	snd_seq_ev_clear(&event);
	
	event.queue  = SND_SEQ_QUEUE_DIRECT;
	event.source = context.address;
	
	snd_seq_ev_set_subs(&event);
	snd_seq_ev_set_direct(&event);
	snd_seq_ev_set_pitchbend(&event, channel, value);
	
	snd_seq_event_output_direct(context.handle, &event);
	snd_seq_drain_output(context.handle);
}
