package jni;

import javax.sound.midi.Receiver;

public abstract class ReceiverJNI implements Receiver{	
	static{  
		System.loadLibrary("ReceiverJNI");
	}		
	
	public ReceiverJNI() {
	}
	
	protected abstract void addDevice(String name,int client,int port);
	
	public native void findDevices();
	
	public native void openDevice(int client,int port);
	
	public native void closeDevice();
	
	public native void noteOn(int channel,int note,int velocity);
	
	public native void noteOff(int channel,int note,int velocity);

	public native void controlChange(int channel,int control,int value);
	
	public native void programChange(int channel,int program);
	
	public native void pitchBend(int channel,int value);
		
}
