/*
 * Decompiled with CFR 0.152.
 */
package synth;

import java.util.ArrayList;
import java.util.List;
import javax.sound.midi.MidiMessage;
import jni.ReceiverJNI;
import synth.MidiDevice;

public class ReceiverImpl
extends ReceiverJNI {
    private int device;
    private boolean open;
    private List devices = new ArrayList();

    public ReceiverImpl(int n) {
        this.device = n;
        this.findDevices();
    }

    public void open() {
        this.open(this.device);
    }

    public void open(int n) {
        if (this.devices.size() > n) {
            if (this.open) {
                this.close();
            }
            MidiDevice midiDevice = (MidiDevice)this.devices.get(n);
            this.openDevice(midiDevice.getClient(), midiDevice.getPort());
            this.device = n;
            this.open = true;
        }
    }

    public void close() {
        this.closeDevice();
        this.open = false;
    }

    public int getDevice() {
        return this.device;
    }

    protected void addDevice(String string, int n, int n2) {
        this.devices.add(new MidiDevice(string, n, n2));
    }

    public List getDevices() {
        return this.devices;
    }

    public void send(MidiMessage midiMessage, long l) {
        this.parseMessage(midiMessage.getMessage());
    }

    private void parseMessage(byte[] byArray) {
        int n = byArray.length;
        if (((n > 0 ? byArray[0] & 0xFF : 0) & 0xF0) == 144) {
            this.parseNoteOn(byArray);
        } else if (((n > 0 ? byArray[0] & 0xFF : 0) & 0xF0) == 128) {
            this.parseNoteOff(byArray);
        } else if (((n > 0 ? byArray[0] & 0xFF : 0) & 0xF0) == 192) {
            this.parseProgramChange(byArray);
        } else if (((n > 0 ? byArray[0] & 0xFF : 0) & 0xF0) == 176) {
            this.parseControlChange(byArray);
        } else if (((n > 0 ? byArray[0] & 0xFF : 0) & 0xF0) == 224) {
            this.parsePitchBend(byArray);
        }
    }

    private void parseNoteOn(byte[] byArray) {
        int n;
        int n2 = byArray.length;
        int n3 = n2 > 0 ? byArray[0] & 0xFF & 0xF : 0;
        int n4 = n2 > 1 ? byArray[1] & 0xFF : 0;
        int n5 = n = n2 > 2 ? byArray[2] & 0xFF : 0;
        if (n == 0) {
            this.parseNoteOff(byArray);
        } else if (n4 > 0) {
            this.noteOn(n3, n4, n);
        }
    }

    private void parseNoteOff(byte[] byArray) {
        int n = byArray.length;
        int n2 = n > 0 ? byArray[0] & 0xFF & 0xF : 0;
        int n3 = n > 1 ? byArray[1] & 0xFF : 0;
        int n4 = n > 2 ? byArray[2] & 0xFF : 0;
        this.noteOff(n2, n3, n4);
    }

    private void parseProgramChange(byte[] byArray) {
        int n;
        int n2 = byArray.length;
        int n3 = n2 > 0 ? byArray[0] & 0xFF & 0xF : -1;
        int n4 = n = n2 > 1 ? byArray[1] & 0xFF : -1;
        if (n3 != -1 && n != -1) {
            this.programChange(n3, n);
        }
    }

    private void parseControlChange(byte[] byArray) {
        int n;
        int n2 = byArray.length;
        int n3 = n2 > 0 ? byArray[0] & 0xFF & 0xF : -1;
        int n4 = n2 > 1 ? byArray[1] & 0xFF : -1;
        int n5 = n = n2 > 2 ? byArray[2] & 0xFF : -1;
        if (n3 != -1 && n4 != -1 && n != -1) {
            this.controlChange(n3, n4, n);
        }
    }

    private void parsePitchBend(byte[] byArray) {
        int n;
        int n2 = byArray.length;
        int n3 = n2 > 0 ? byArray[0] & 0xFF & 0xF : -1;
        int n4 = n = n2 > 2 ? byArray[2] & 0xFF : -1;
        if (n3 != -1 && n != -1) {
            this.pitchBend(n3, n * 127 - 8191);
        }
    }
}

