/*
 * Decompiled with CFR 0.152.
 */
package plugin;

import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Synthesizer;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.plugins.TGMidiPlugin;
import org.herac.tuxguitar.gui.plugins.TGPluginItem;
import plugin.Config;
import plugin.TGPluginItemImpl;
import synth.ReceiverImpl;
import synth.SynthesizerImpl;

public class TGPluginImpl
implements TGMidiPlugin {
    private Config config = new Config();
    private SynthesizerImpl synthesizer;
    private TGPluginItemImpl item;
    private boolean enabled = this.config.getBooleanConfigValue("enabled", true);

    public TGPluginImpl() {
        this.synthesizer = new SynthesizerImpl(new ReceiverImpl(this.config.getIntConfigValue("device", 0)));
        this.item = new TGPluginItemImpl(this);
    }

    public void init(TuxGuitar tuxGuitar) {
        if (this.enabled) {
            tuxGuitar.getSongManager().getPlayer().setSynthesizer((Synthesizer)this.synthesizer);
            tuxGuitar.loadProperties();
        }
    }

    public String getName() {
        return "Tuxguitar-alsa plugin";
    }

    public String getDescription() {
        return "Tuxguitar-alsa plugin";
    }

    public String getVersion() {
        return "test";
    }

    public String getVendor() {
        return "none";
    }

    public TGPluginItem getItem() {
        return this.item;
    }

    public SynthesizerImpl getSynthesizer() {
        return this.synthesizer;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void changeConfig(int n, boolean bl) {
        try {
            this.config.setProperty("device", n);
            this.config.setProperty("enabled", bl);
            this.config.save();
            if (bl) {
                if (!this.enabled) {
                    TuxGuitar.instance().getSongManager().getPlayer().setSynthesizer((Synthesizer)this.synthesizer);
                    TuxGuitar.instance().loadProperties();
                }
                if (n != this.getSynthesizer().getReceiver().getDevice()) {
                    this.getSynthesizer().getReceiver().open(n);
                }
            } else if (this.enabled) {
                TuxGuitar.instance().getSongManager().getPlayer().setSynthesizer(null);
                TuxGuitar.instance().loadProperties();
            }
            this.enabled = bl;
        }
        catch (MidiUnavailableException midiUnavailableException) {
            midiUnavailableException.printStackTrace();
        }
    }

    public void close() {
        this.synthesizer.close();
    }
}

