/*
 * Decompiled with CFR 0.152.
 */
package plugin;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import org.herac.tuxguitar.gui.util.TuxGuitarFileUtils;

public class Config {
    private static final String CONFIG_FILE = "tuxguitar-alsa.properties";
    private Properties properties = new Properties();

    public Config() {
        this.init();
    }

    public void init() {
        this.load();
    }

    private String getProperty(String string) {
        return this.properties.getProperty(string);
    }

    public String getStringConfigValue(String string) {
        String string2 = this.getProperty(string);
        return string2 == null ? null : string2.trim();
    }

    public int getIntConfigValue(String string, int n) {
        String string2 = this.getProperty(string);
        return string2 == null ? n : Integer.parseInt(string2.trim());
    }

    public boolean getBooleanConfigValue(String string, boolean bl) {
        String string2 = this.getProperty(string);
        return string2 == null ? bl : Boolean.valueOf(string2.trim());
    }

    public void setProperty(String string, String string2) {
        this.properties.setProperty(string, string2);
    }

    public void setProperty(String string, int n) {
        this.setProperty(string, Integer.toString(n));
    }

    public void setProperty(String string, boolean bl) {
        this.setProperty(string, Boolean.toString(bl));
    }

    public void removeProperty(String string) {
        this.properties.remove(string);
    }

    public void clear() {
        this.properties.clear();
    }

    public void load() {
        try {
            if (new File(this.getFileName()).exists()) {
                FileInputStream fileInputStream = new FileInputStream(this.getFileName());
                this.properties.clear();
                this.properties.load(fileInputStream);
            } else {
                this.save();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void save() {
        try {
            this.properties.store(new FileOutputStream(this.getFileName()), "TuxGuitar-alsa Configuration");
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private String getFileName() {
        return TuxGuitarFileUtils.USER_CONFIG_PREFIX + File.separator + CONFIG_FILE;
    }
}

