/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.song.managers;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.sound.midi.Instrument;
import javax.sound.midi.Soundbank;
import org.herac.tuxguitar.io.SongLoader;
import org.herac.tuxguitar.io.SongWriter;
import org.herac.tuxguitar.io.UnsupportedFormatException;
import org.herac.tuxguitar.io.gp.GPFormatException;
import org.herac.tuxguitar.play.models.Player;
import org.herac.tuxguitar.play.models.defaultplayer.SongPlayer;
import org.herac.tuxguitar.song.helpers.TrackMeasure;
import org.herac.tuxguitar.song.helpers.TracksMeasures;
import org.herac.tuxguitar.song.managers.MeasureManager;
import org.herac.tuxguitar.song.managers.SongTrackManager;
import org.herac.tuxguitar.song.models.Duration;
import org.herac.tuxguitar.song.models.InstrumentString;
import org.herac.tuxguitar.song.models.Marker;
import org.herac.tuxguitar.song.models.Measure;
import org.herac.tuxguitar.song.models.MeasureHeader;
import org.herac.tuxguitar.song.models.RGBColor;
import org.herac.tuxguitar.song.models.Song;
import org.herac.tuxguitar.song.models.SongChannel;
import org.herac.tuxguitar.song.models.SongTrack;
import org.herac.tuxguitar.song.models.Tempo;
import org.herac.tuxguitar.song.models.TimeSignature;

public class SongManager {
    public static short MAX_CHANNELS = (short)16;
    private Song song;
    private Player player = new SongPlayer(this);
    private SongTrackManager trackManager;
    private MeasureManager measureManager;

    public SongManager() {
        this.newSong();
    }

    public void setSongName(String string) {
        this.getSong().setName(string);
    }

    public Song getSong() {
        return this.song;
    }

    public void newSong() {
        this.setSong(SongManager.makeNewSong());
    }

    public void save(String string) {
        try {
            new SongWriter(string).write(this.getSong());
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (GPFormatException gPFormatException) {
            gPFormatException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public boolean open(String string) throws GPFormatException, IOException, UnsupportedFormatException {
        SongLoader songLoader = new SongLoader(string);
        Song song = songLoader.load();
        if (song != null) {
            this.setSong(song);
            return true;
        }
        return false;
    }

    public void setSong(Song song) {
        this.song = song;
        this.player.reset();
    }

    public void setProperties(String string, String string2, String string3, String string4) {
        this.getSong().setName(string);
        this.getSong().setInterpret(string2);
        this.getSong().setAlbum(string3);
        this.getSong().setAuthor(string4);
    }

    public Player getPlayer() {
        return this.player;
    }

    public void addTrack(SongTrack songTrack) {
        this.orderTracks();
        int n = -1;
        for (int i = 0; i < this.getSong().getTracks().size(); ++i) {
            SongTrack songTrack2 = (SongTrack)this.getSong().getTracks().get(i);
            if (n == -1 && songTrack2.getNumber() == songTrack.getNumber()) {
                n = i;
            }
            if (n < 0) continue;
            songTrack2.setNumber(songTrack2.getNumber() + 1L);
        }
        if (n < 0) {
            n = this.getSong().getTracks().size();
        }
        this.getSong().getTracks().add(n, songTrack);
    }

    public void removeTrack(long l) {
        this.orderTracks();
        SongTrack songTrack = null;
        for (SongTrack songTrack2 : this.getSong().getTracks()) {
            if (songTrack == null && songTrack2.getNumber() == l) {
                songTrack = songTrack2;
                continue;
            }
            if (songTrack2.getNumber() != l + 1L) continue;
            songTrack2.setNumber(l);
            ++l;
        }
        this.getSong().getTracks().remove(songTrack);
    }

    private void orderTracks() {
        for (int i = 0; i < this.getSong().getTracks().size(); ++i) {
            SongTrack songTrack = null;
            for (int j = i; j < this.getSong().getTracks().size(); ++j) {
                SongTrack songTrack2 = (SongTrack)this.getSong().getTracks().get(j);
                if (songTrack != null && songTrack2.getNumber() >= songTrack.getNumber()) continue;
                songTrack = songTrack2;
            }
            this.getSong().getTracks().remove(songTrack);
            this.getSong().getTracks().add(i, songTrack);
        }
    }

    public SongTrack getTrack(Measure measure) {
        SongTrack songTrack = null;
        for (SongTrack songTrack2 : this.getSong().getTracks()) {
            if (!songTrack2.getMeasures().contains(measure)) continue;
            songTrack = songTrack2;
            break;
        }
        return songTrack;
    }

    public static Song makeNewSong() {
        ArrayList<SongTrack> arrayList = new ArrayList<SongTrack>();
        List list = SongManager.createDefaultInstrumentStrings();
        ArrayList<MeasureHeader> arrayList2 = new ArrayList<MeasureHeader>();
        ArrayList<Measure> arrayList3 = new ArrayList<Measure>();
        MeasureHeader measureHeader = new MeasureHeader(1, 1000L, new TimeSignature(4, new Duration(4)), new Tempo(100), null, 1, false, 0);
        arrayList2.add(measureHeader);
        arrayList3.add(new Measure(measureHeader, new ArrayList(), new ArrayList(), 1, 0));
        arrayList.add(new SongTrack(1L, "Track 1", new SongChannel(0, 1, 0), arrayList3, list, 0, RGBColor.RED));
        return new Song(arrayList, arrayList2);
    }

    public long getNextTrackNumber() {
        return this.countTracks() + 1;
    }

    public boolean isEmpty() {
        return this.song.getTracks().isEmpty();
    }

    public SongChannel getFreeChannel(short s, boolean bl) {
        return SongManager.getFreeChannel(this.getSong().getTracks(), s, bl);
    }

    public static SongChannel getFreeChannel(List list, short s, boolean bl) {
        if (bl) {
            return SongChannel.getDefaultPercusionChannel();
        }
        short s2 = -1;
        short s3 = -1;
        boolean[] blArray = SongManager.getUsedChannels(list);
        boolean[] blArray2 = SongManager.getUsedEffectChannels(list);
        for (short s4 = 0; s4 < MAX_CHANNELS; s4 = (short)(s4 + 1)) {
            if (blArray[s4] || blArray2[s4]) continue;
            s2 = s2 < 0 ? s4 : s2;
            s3 = s3 < 0 && s4 != s2 ? s4 : s3;
        }
        if (s2 < 0 || s3 < 0) {
            if (s2 >= 0) {
                s3 = s2;
            } else {
                SongChannel songChannel = ((SongTrack)list.get(list.size() - 1)).getChannel();
                return (SongChannel)songChannel.clone();
            }
        }
        return new SongChannel(s2, s3, s);
    }

    public boolean[] getUsedEffectChannels() {
        return SongManager.getUsedEffectChannels(this.getSong().getTracks());
    }

    public static boolean[] getUsedEffectChannels(List list) {
        boolean[] blArray = new boolean[MAX_CHANNELS];
        for (int i = 0; i < list.size(); ++i) {
            SongTrack songTrack = (SongTrack)list.get(i);
            blArray[songTrack.getChannel().getEffectChannel()] = true;
        }
        return blArray;
    }

    public boolean[] getUsedChannels() {
        return SongManager.getUsedChannels(this.getSong().getTracks());
    }

    public static boolean[] getUsedChannels(List list) {
        boolean[] blArray = new boolean[MAX_CHANNELS];
        for (int i = 0; i < list.size(); ++i) {
            SongTrack songTrack = (SongTrack)list.get(i);
            blArray[songTrack.getChannel().getChannel()] = true;
        }
        return blArray;
    }

    public SongChannel getUsedChannel(int n) {
        for (int i = 0; i < this.getSong().getTracks().size(); ++i) {
            SongTrack songTrack = (SongTrack)this.getSong().getTracks().get(i);
            if (n != songTrack.getChannel().getChannel()) continue;
            return (SongChannel)songTrack.getChannel().clone();
        }
        return null;
    }

    public int countTracksForChannel(int n) {
        int n2 = 0;
        for (int i = 0; i < this.getSong().getTracks().size(); ++i) {
            SongTrack songTrack = (SongTrack)this.getSong().getTracks().get(i);
            if (n != songTrack.getChannel().getChannel()) continue;
            ++n2;
        }
        return n2;
    }

    public void updateChannel(SongChannel songChannel) {
        for (int i = 0; i < this.getSong().getTracks().size(); ++i) {
            SongTrack songTrack = (SongTrack)this.getSong().getTracks().get(i);
            if (songChannel.getChannel() != songTrack.getChannel().getChannel()) continue;
            songTrack.setChannel((SongChannel)songChannel.clone());
        }
    }

    public static List createDefaultInstrumentStrings() {
        ArrayList<InstrumentString> arrayList = new ArrayList<InstrumentString>();
        arrayList.add(new InstrumentString(1, 64));
        arrayList.add(new InstrumentString(2, 59));
        arrayList.add(new InstrumentString(3, 55));
        arrayList.add(new InstrumentString(4, 50));
        arrayList.add(new InstrumentString(5, 45));
        arrayList.add(new InstrumentString(6, 40));
        return arrayList;
    }

    public static List createPercusionStrings(int n) {
        ArrayList<InstrumentString> arrayList = new ArrayList<InstrumentString>();
        for (int i = 1; i <= n; ++i) {
            arrayList.add(new InstrumentString(i, 0));
        }
        return arrayList;
    }

    public void calculateMeasureStartWidthRepetitions() {
        boolean bl = true;
        long l = 1000L;
        long l2 = 0L;
        long l3 = 0L;
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < this.getSong().getMeasureHeaders().size(); ++i) {
            MeasureHeader measureHeader = (MeasureHeader)this.getSong().getMeasureHeaders().get(i);
            if (!bl || measureHeader.getStart() + measureHeader.getLength() > l2) {
                measureHeader.setStartWidthRepetitions(measureHeader.getStart() + l3);
                for (SongTrack songTrack : this.getSong().getTracks()) {
                    this.getMeasureManager().calculateNoteStartWidthRepetitions(this.getTrackManager().getMeasure(songTrack, measureHeader.getNumber()), l3);
                }
            }
            if (measureHeader.isRepeatStart()) {
                n = i;
                l = measureHeader.getStart();
                bl = true;
            }
            if (!bl || measureHeader.getNumberOfRepetitions() <= 0) continue;
            if (n2 < measureHeader.getNumberOfRepetitions()) {
                l2 = measureHeader.getStart() + measureHeader.getLength();
                l3 += l2 - l;
                i = n - 1;
                ++n2;
                continue;
            }
            l = 0L;
            n2 = 0;
            l2 = 0L;
            bl = false;
        }
    }

    public String getInstrumentName(int n) {
        String string = null;
        Soundbank soundbank = this.getPlayer().getSoundbank();
        if (soundbank != null) {
            Instrument[] instrumentArray = soundbank.getInstruments();
            string = instrumentArray[n].getName();
        } else {
            string = Integer.toString(n);
        }
        return string;
    }

    public int countTracks() {
        return this.getSong().getTracks().size();
    }

    public int countMeasures() {
        return this.getTrackManager().countMeasures(this.getFirstTrack());
    }

    public SongTrackManager getTrackManager() {
        if (this.trackManager == null) {
            this.trackManager = new SongTrackManager(this);
        }
        return this.trackManager;
    }

    public MeasureManager getMeasureManager() {
        if (this.measureManager == null) {
            this.measureManager = new MeasureManager(this);
        }
        return this.measureManager;
    }

    public SongTrack getTrack(long l) {
        SongTrack songTrack = null;
        for (int i = 0; i < this.getSong().getTracks().size(); ++i) {
            SongTrack songTrack2 = (SongTrack)this.getSong().getTracks().get(i);
            if (songTrack2.getNumber() != l) continue;
            songTrack = songTrack2;
            break;
        }
        return songTrack;
    }

    public SongTrack getFirstTrack() {
        SongTrack songTrack = null;
        if (!this.getSong().getTracks().isEmpty()) {
            songTrack = (SongTrack)this.getSong().getTracks().get(0);
        }
        return songTrack;
    }

    public SongTrack getLastTrack() {
        SongTrack songTrack = null;
        if (!this.getSong().getTracks().isEmpty()) {
            songTrack = (SongTrack)this.getSong().getTracks().get(this.getSong().getTracks().size() - 1);
        }
        return songTrack;
    }

    public SongTrack cloneTrack(SongTrack songTrack) {
        SongTrack songTrack2 = (SongTrack)songTrack.clone(this.getMeasureHeaders());
        songTrack2.setNumber(this.getNextTrackNumber());
        this.addTrack(songTrack2);
        return songTrack2;
    }

    public boolean moveTrackUp(SongTrack songTrack) {
        if (songTrack.getNumber() > 1L) {
            SongTrack songTrack2 = this.getTrack(songTrack.getNumber() - 1L);
            songTrack2.setNumber(songTrack2.getNumber() + 1L);
            songTrack.setNumber(songTrack.getNumber() - 1L);
            this.orderTracks();
            return true;
        }
        return false;
    }

    public boolean moveTrackDown(SongTrack songTrack) {
        if (songTrack.getNumber() < (long)this.countTracks()) {
            SongTrack songTrack2 = this.getTrack(songTrack.getNumber() + 1L);
            songTrack2.setNumber(songTrack2.getNumber() - 1L);
            songTrack.setNumber(songTrack.getNumber() + 1L);
            this.orderTracks();
            return true;
        }
        return false;
    }

    private SongTrack makeNewTrack() {
        ArrayList<Measure> arrayList = new ArrayList<Measure>();
        for (MeasureHeader measureHeader : this.getSong().getMeasureHeaders()) {
            arrayList.add(new Measure(measureHeader, new ArrayList(), new ArrayList(), 1, 0));
        }
        long l = this.getNextTrackNumber();
        String string = "Track " + l;
        SongChannel songChannel = this.getFreeChannel((short)0, false);
        List list = SongManager.createDefaultInstrumentStrings();
        return new SongTrack(l, string, songChannel, arrayList, list, 0, RGBColor.RED);
    }

    public SongTrack createTrack() {
        SongTrack songTrack = null;
        if (this.getSong().getTracks().isEmpty()) {
            this.setSong(SongManager.makeNewSong());
        } else {
            songTrack = this.makeNewTrack();
        }
        this.addTrack(songTrack);
        return songTrack;
    }

    public void removeTrack(SongTrack songTrack) {
        this.removeTrack(songTrack.getNumber());
    }

    public void changeTimeSignature(long l, TimeSignature timeSignature, boolean bl) {
        this.changeTimeSignature(this.getMeasureHeaderAt(l), timeSignature, bl);
    }

    public void changeTimeSignature(MeasureHeader measureHeader, TimeSignature timeSignature, boolean bl) {
        measureHeader.setTimeSignature((TimeSignature)timeSignature.clone());
        long l = measureHeader.getStart() + measureHeader.getLength();
        List list = this.getMeasureHeadersBeforeEnd(measureHeader.getStart() + 1L);
        for (MeasureHeader measureHeader2 : list) {
            long l2 = l - measureHeader2.getStart();
            this.moveMeasureComponents(measureHeader2, l2, 0);
            this.moveMeasureHeader(measureHeader2, l2, 0);
            if (bl) {
                measureHeader2.setTimeSignature((TimeSignature)timeSignature.clone());
            }
            l = measureHeader2.getStart() + measureHeader2.getLength();
        }
    }

    public void changeTripletFeel(long l, int n, boolean bl) {
        this.changeTripletFeel(this.getMeasureHeaderAt(l), n, bl);
    }

    public void changeTripletFeel(MeasureHeader measureHeader, int n, boolean bl) {
        measureHeader.setTripletFeel(n);
        if (bl) {
            List list = this.getMeasureHeadersBeforeEnd(measureHeader.getStart() + 1L);
            for (MeasureHeader measureHeader2 : list) {
                measureHeader2.setTripletFeel(n);
            }
        }
    }

    public void changeTempo(long l, Tempo tempo, boolean bl) {
        this.changeTempo(this.getMeasureHeaderAt(l), tempo, bl);
    }

    public void changeTempo(MeasureHeader measureHeader, Tempo tempo, boolean bl) {
        measureHeader.setTempo((Tempo)tempo.clone());
        if (bl) {
            List list = this.getMeasureHeadersBeforeEnd(measureHeader.getStart() + 1L);
            for (MeasureHeader measureHeader2 : list) {
                measureHeader2.setTempo((Tempo)tempo.clone());
            }
        }
    }

    public void changeOpenRepeat(long l) {
        MeasureHeader measureHeader;
        measureHeader.setRepeatStart(!(measureHeader = this.getMeasureHeaderAt(l)).isRepeatStart());
    }

    public void changeCloseRepeat(long l, int n) {
        MeasureHeader measureHeader = this.getMeasureHeaderAt(l);
        measureHeader.setNumberOfRepetitions(n);
    }

    public void addNewMeasureBeforeEnd() {
        MeasureHeader measureHeader = this.getLastMeasureHeader();
        TimeSignature timeSignature = (TimeSignature)measureHeader.getTimeSignature().clone();
        Tempo tempo = (Tempo)measureHeader.getTempo().clone();
        int n = measureHeader.getNumber() + 1;
        long l = measureHeader.getStart() + measureHeader.getLength();
        boolean bl = false;
        int n2 = 0;
        int n3 = measureHeader.getTripletFeel();
        MeasureHeader measureHeader2 = new MeasureHeader(n, l, timeSignature, tempo, null, n3, bl, n2);
        this.getSong().getMeasureHeaders().add(measureHeader2);
        for (SongTrack songTrack : this.getSong().getTracks()) {
            this.getTrackManager().addNewMeasureBeforeEnd(songTrack, measureHeader2);
        }
        this.calculateMeasureStartWidthRepetitions();
    }

    public List getMeasures(long l) {
        ArrayList<Measure> arrayList = new ArrayList<Measure>();
        for (SongTrack songTrack : this.getSong().getTracks()) {
            Measure measure = this.getTrackManager().getMeasureAt(songTrack, l);
            if (measure == null) continue;
            arrayList.add(measure);
        }
        return arrayList;
    }

    public SongTrack replaceTrack(SongTrack songTrack) {
        SongTrack songTrack2 = this.getTrack(songTrack.getNumber());
        if (songTrack2 != null) {
            songTrack2.makeEqual(songTrack, this.getMeasureHeaders());
        }
        return songTrack2;
    }

    public TracksMeasures copyMeasures(long l, long l2) {
        TracksMeasures tracksMeasures = new TracksMeasures();
        tracksMeasures.setMeasureHeaders(this.getMeasureHeadersBetween(l, l2));
        ArrayList arrayList = new ArrayList();
        for (SongTrack songTrack : this.getSong().getTracks()) {
            List list = this.getTrackManager().copyMeasures(songTrack, l, l2);
            tracksMeasures.addTrackMeasure(songTrack.getNumber(), list);
        }
        return (TracksMeasures)tracksMeasures.clone();
    }

    public TracksMeasures copyMeasures(long l, long l2, SongTrack songTrack) {
        TracksMeasures tracksMeasures = new TracksMeasures();
        tracksMeasures.setMeasureHeaders(this.getMeasureHeadersBetween(l, l2));
        ArrayList arrayList = new ArrayList();
        List list = this.getTrackManager().copyMeasures(songTrack, l, l2);
        tracksMeasures.addTrackMeasure(songTrack.getNumber(), list);
        return (TracksMeasures)tracksMeasures.clone();
    }

    public void insertMeasures(TracksMeasures tracksMeasures, int n, long l) {
        ArrayList<MeasureHeader> arrayList = new ArrayList<MeasureHeader>();
        this.moveMeasureHeaders(tracksMeasures.getMeasureHeaders(), l, 0, false);
        int n2 = n;
        for (MeasureHeader measureHeader : tracksMeasures.getMeasureHeaders()) {
            measureHeader.setNumber(n2);
            arrayList.add(measureHeader);
            ++n2;
        }
        long l2 = ((MeasureHeader)arrayList.get(0)).getStart();
        long l3 = ((MeasureHeader)arrayList.get(arrayList.size() - 1)).getStart() + ((MeasureHeader)arrayList.get(arrayList.size() - 1)).getLength();
        List list = this.getMeasureHeadersBeforeEnd(l2);
        this.moveMeasureHeaders(list, l3 - l2, arrayList.size(), true);
        for (Serializable serializable : tracksMeasures.getMeasureHeaders()) {
            this.addMeasureHeader(((MeasureHeader)serializable).getNumber() - 1, (MeasureHeader)serializable);
        }
        for (Serializable serializable : this.getSong().getTracks()) {
            List list2 = null;
            for (TrackMeasure trackMeasure : tracksMeasures.getTrackMeasures()) {
                if (trackMeasure.getTrack() != ((SongTrack)serializable).getNumber()) continue;
                list2 = trackMeasure.getMeasures();
                break;
            }
            if (list2 == null) {
                list2 = this.getEmptyMeasures(((TrackMeasure)tracksMeasures.getTrackMeasures().get(0)).getMeasures());
            }
            for (int i = 0; i < list2.size(); ++i) {
                Measure measure = (Measure)list2.get(i);
                measure.setHeader((MeasureHeader)arrayList.get(i));
                this.getMeasureManager().moveAllComponents(measure, l);
            }
            this.getTrackManager().insertMeasures((SongTrack)serializable, list2, n);
        }
        this.calculateMeasureStartWidthRepetitions();
    }

    private List getEmptyMeasures(List list) {
        ArrayList<Measure> arrayList = new ArrayList<Measure>();
        for (Measure measure : list) {
            int n = measure.getClef();
            int n2 = measure.getKeySignature();
            arrayList.add(new Measure(null, new ArrayList(), new ArrayList(), n, n2));
        }
        return arrayList;
    }

    public void replaceMeasures(TracksMeasures tracksMeasures, long l) {
        ArrayList<MeasureHeader> arrayList = new ArrayList<MeasureHeader>();
        this.moveMeasureHeaders(tracksMeasures.getMeasureHeaders(), l, 0, false);
        for (Object object : tracksMeasures.getMeasureHeaders()) {
            arrayList.add(this.replaceMeasureHeader((MeasureHeader)object));
        }
        for (Object object : tracksMeasures.getTrackMeasures()) {
            SongTrack songTrack = this.getTrack(((TrackMeasure)object).getTrack());
            List list = ((TrackMeasure)object).getMeasures();
            for (int i = 0; i < list.size(); ++i) {
                Measure measure = (Measure)list.get(i);
                measure.setHeader((MeasureHeader)arrayList.get(i));
                this.getMeasureManager().moveAllComponents(measure, l);
                this.getTrackManager().replaceMeasure(songTrack, measure);
            }
        }
        this.calculateMeasureStartWidthRepetitions();
    }

    public MeasureHeader getFirstMeasureHeader() {
        MeasureHeader measureHeader = null;
        for (int i = 0; i < this.getSong().getMeasureHeaders().size(); ++i) {
            MeasureHeader measureHeader2 = (MeasureHeader)this.getSong().getMeasureHeaders().get(i);
            if (measureHeader != null && measureHeader2.getStart() >= measureHeader.getStart()) continue;
            measureHeader = measureHeader2;
        }
        return measureHeader;
    }

    public MeasureHeader getLastMeasureHeader() {
        int n = this.getSong().getMeasureHeaders().size() - 1;
        return (MeasureHeader)this.getSong().getMeasureHeaders().get(n);
    }

    public MeasureHeader getPrevMeasureHeader(MeasureHeader measureHeader) {
        int n = measureHeader.getNumber() - 1;
        if (n > 0) {
            return (MeasureHeader)this.getSong().getMeasureHeaders().get(n - 1);
        }
        return null;
    }

    public MeasureHeader getNextMeasureHeader(MeasureHeader measureHeader) {
        int n = measureHeader.getNumber();
        if (n < this.getSong().getMeasureHeaders().size()) {
            return (MeasureHeader)this.getSong().getMeasureHeaders().get(n);
        }
        return null;
    }

    public MeasureHeader getMeasureHeaderAt(long l) {
        for (MeasureHeader measureHeader : this.getSong().getMeasureHeaders()) {
            long l2 = measureHeader.getStart();
            long l3 = measureHeader.getLength();
            if (l < l2 || l >= l2 + l3) continue;
            return measureHeader;
        }
        return null;
    }

    public MeasureHeader getMeasureHeader(int n) {
        for (int i = 0; i < this.getSong().getMeasureHeaders().size(); ++i) {
            MeasureHeader measureHeader = (MeasureHeader)this.getSong().getMeasureHeaders().get(i);
            if (measureHeader.getNumber() != n) continue;
            return measureHeader;
        }
        return null;
    }

    public List getMeasureHeadersBeforeEnd(long l) {
        ArrayList<MeasureHeader> arrayList = new ArrayList<MeasureHeader>();
        for (MeasureHeader measureHeader : this.getSong().getMeasureHeaders()) {
            if (measureHeader.getStart() < l) continue;
            arrayList.add(measureHeader);
        }
        return arrayList;
    }

    public List getMeasureHeadersBetween(long l, long l2) {
        ArrayList<MeasureHeader> arrayList = new ArrayList<MeasureHeader>();
        for (MeasureHeader measureHeader : this.getSong().getMeasureHeaders()) {
            long l3 = measureHeader.getStart();
            if (l3 < l || l3 > l2) continue;
            arrayList.add(measureHeader);
        }
        return arrayList;
    }

    public List getMeasureHeaders() {
        return this.getSong().getMeasureHeaders();
    }

    public void removeMeasures(long l, long l2) {
        this.removeMeasureHeaders(l, l2);
    }

    public void removeLastMeasure() {
        this.removeLastMeasureHeader();
    }

    public void removeMeasure(long l) {
        this.removeMeasureHeader(l);
    }

    public void addMeasureHeader(MeasureHeader measureHeader) {
        this.getSong().getMeasureHeaders().add(measureHeader);
    }

    public void addMeasureHeader(int n, MeasureHeader measureHeader) {
        this.getSong().getMeasureHeaders().add(n, measureHeader);
    }

    public void removeMeasureHeaders(long l, long l2) {
        ArrayList arrayList = new ArrayList();
        for (MeasureHeader measureHeader : this.getMeasureHeadersBetween(l, l2)) {
            this.removeMeasureHeader(measureHeader);
        }
    }

    public void removeLastMeasureHeader() {
        this.removeMeasureHeader(this.getLastMeasureHeader());
    }

    public void removeMeasureHeader(long l) {
        this.removeMeasureHeader(this.getMeasureHeaderAt(l));
    }

    public void removeMeasureHeader(MeasureHeader measureHeader) {
        Object object2;
        long l = measureHeader.getStart();
        long l2 = measureHeader.getLength();
        for (Object object2 : this.getSong().getTracks()) {
            this.getTrackManager().removeMeasure((SongTrack)object2, l);
        }
        object2 = this.getMeasureHeadersBeforeEnd(l + 1L);
        this.moveMeasureHeaders((List)object2, -l2, -1, true);
        this.getSong().getMeasureHeaders().remove(measureHeader.getNumber() - 1);
        this.calculateMeasureStartWidthRepetitions();
    }

    public MeasureHeader replaceMeasureHeader(MeasureHeader measureHeader) {
        MeasureHeader measureHeader2 = this.getMeasureHeaderAt(measureHeader.getStart());
        measureHeader2.makeEqual((MeasureHeader)measureHeader.clone());
        return measureHeader2;
    }

    public void moveMeasureHeaders(List list, long l, int n, boolean bl) {
        if (bl) {
            for (MeasureHeader measureHeader : list) {
                this.moveMeasureComponents(measureHeader, l, n);
            }
        }
        for (MeasureHeader measureHeader : list) {
            this.moveMeasureHeader(measureHeader, l, n);
        }
    }

    public void moveMeasureHeader(MeasureHeader measureHeader, long l, int n) {
        measureHeader.setNumber(measureHeader.getNumber() + n);
        measureHeader.setStart(measureHeader.getStart() + l);
    }

    public void moveMeasureComponents(MeasureHeader measureHeader, long l, int n) {
        for (SongTrack songTrack : this.getSong().getTracks()) {
            this.getTrackManager().moveMeasure(songTrack, this.getTrackManager().getMeasure(songTrack, measureHeader.getNumber()), l, n);
        }
    }

    public boolean isAtPosition(MeasureHeader measureHeader, long l) {
        return l >= measureHeader.getStart() && l < measureHeader.getStart() + measureHeader.getLength();
    }

    public Marker updateMarker(int n, String string, RGBColor rGBColor) {
        return this.updateMarker(new Marker(n, string, rGBColor));
    }

    public Marker updateMarker(Marker marker) {
        MeasureHeader measureHeader = this.getMeasureHeader(marker.getMeasure());
        if (measureHeader != null) {
            measureHeader.setMarker(marker);
        }
        return null;
    }

    public void removeMarker(Marker marker) {
        if (marker != null) {
            this.removeMarker(marker.getMeasure());
        }
    }

    public void removeMarker(int n) {
        MeasureHeader measureHeader = this.getMeasureHeader(n);
        if (measureHeader != null && measureHeader.hasMarker()) {
            measureHeader.setMarker(null);
        }
    }

    public void removeAllMarkers() {
        for (MeasureHeader measureHeader : this.getSong().getMeasureHeaders()) {
            if (!measureHeader.hasMarker()) continue;
            measureHeader.setMarker(null);
        }
    }

    public List getMarkers() {
        ArrayList<Marker> arrayList = new ArrayList<Marker>();
        for (MeasureHeader measureHeader : this.getSong().getMeasureHeaders()) {
            if (!measureHeader.hasMarker()) continue;
            arrayList.add(measureHeader.getMarker());
        }
        return arrayList;
    }

    public Marker getMarker(int n) {
        MeasureHeader measureHeader = this.getMeasureHeader(n);
        if (measureHeader != null && measureHeader.hasMarker()) {
            return measureHeader.getMarker();
        }
        return null;
    }

    public Marker getPreviousMarker(int n) {
        MeasureHeader measureHeader = null;
        for (MeasureHeader measureHeader2 : this.getSong().getMeasureHeaders()) {
            if (!measureHeader2.hasMarker() || measureHeader2.getNumber() >= n || measureHeader != null && measureHeader.getNumber() >= measureHeader2.getNumber()) continue;
            measureHeader = measureHeader2;
        }
        return measureHeader != null ? measureHeader.getMarker() : null;
    }

    public Marker getNextMarker(int n) {
        MeasureHeader measureHeader = null;
        for (MeasureHeader measureHeader2 : this.getSong().getMeasureHeaders()) {
            if (!measureHeader2.hasMarker() || measureHeader2.getNumber() <= n || measureHeader != null && measureHeader.getNumber() <= measureHeader2.getNumber()) continue;
            measureHeader = measureHeader2;
        }
        return measureHeader != null ? measureHeader.getMarker() : null;
    }

    public Marker getFirstMarker() {
        MeasureHeader measureHeader = null;
        for (MeasureHeader measureHeader2 : this.getSong().getMeasureHeaders()) {
            if (!measureHeader2.hasMarker() || measureHeader != null && measureHeader2.getNumber() >= measureHeader.getNumber()) continue;
            measureHeader = measureHeader2;
        }
        return measureHeader != null ? measureHeader.getMarker() : null;
    }

    public Marker getLastMarker() {
        MeasureHeader measureHeader = null;
        for (MeasureHeader measureHeader2 : this.getSong().getMeasureHeaders()) {
            if (!measureHeader2.hasMarker() || measureHeader != null && measureHeader2.getNumber() <= measureHeader.getNumber()) continue;
            measureHeader = measureHeader2;
        }
        return measureHeader != null ? measureHeader.getMarker() : null;
    }

    public void autoCompleteSilences() {
        for (SongTrack songTrack : this.getSong().getTracks()) {
            this.getTrackManager().autoCompleteSilences(songTrack);
        }
    }
}

