/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.io.tg;

import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.herac.tuxguitar.io.tg.TGStream;
import org.herac.tuxguitar.song.models.BendEffect;
import org.herac.tuxguitar.song.models.Component;
import org.herac.tuxguitar.song.models.Duration;
import org.herac.tuxguitar.song.models.InstrumentString;
import org.herac.tuxguitar.song.models.Marker;
import org.herac.tuxguitar.song.models.Measure;
import org.herac.tuxguitar.song.models.MeasureHeader;
import org.herac.tuxguitar.song.models.Note;
import org.herac.tuxguitar.song.models.NoteEffect;
import org.herac.tuxguitar.song.models.RGBColor;
import org.herac.tuxguitar.song.models.Silence;
import org.herac.tuxguitar.song.models.Song;
import org.herac.tuxguitar.song.models.SongChannel;
import org.herac.tuxguitar.song.models.SongTrack;
import org.herac.tuxguitar.song.models.Tempo;
import org.herac.tuxguitar.song.models.TimeSignature;
import org.herac.tuxguitar.song.models.Tupleto;

public class TGOutputStream
extends TGStream {
    private static final String TG_VERSION = "TG_DEVEL-0.8";
    private DataOutputStream dataOutputStream;

    public TGOutputStream(FileOutputStream fileOutputStream) throws FileNotFoundException {
        this.dataOutputStream = new DataOutputStream(fileOutputStream);
    }

    public TGOutputStream(String string) throws FileNotFoundException {
        this(new FileOutputStream(new File(string)));
    }

    public void write(Song song) {
        try {
            this.writeVersion();
            this.writeSong(song);
            this.dataOutputStream.flush();
            this.dataOutputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void writeVersion() {
        this.writeString(TG_VERSION);
    }

    private void writeSong(Song song) {
        Serializable serializable;
        int n;
        this.writeString(song.getName());
        this.writeString(song.getInterpret());
        this.writeString(song.getAlbum());
        this.writeString(song.getAuthor());
        this.writeShort((short)song.getMeasureHeaders().size());
        MeasureHeader measureHeader = null;
        for (n = 0; n < song.getMeasureHeaders().size(); ++n) {
            serializable = (MeasureHeader)song.getMeasureHeaders().get(n);
            this.writeMeasureHeader((MeasureHeader)serializable, measureHeader);
            measureHeader = serializable;
        }
        this.writeByte(song.getTracks().size());
        for (n = 0; n < song.getTracks().size(); ++n) {
            serializable = (SongTrack)song.getTracks().get(n);
            this.writeTrack((SongTrack)serializable);
        }
    }

    private void writeTrack(SongTrack songTrack) {
        this.writeString(songTrack.getName());
        this.writeChannel(songTrack.getChannel());
        Measure measure = null;
        for (Object object : songTrack.getMeasures()) {
            this.writeMeasure((Measure)object, measure);
            measure = object;
        }
        this.writeByte(songTrack.getStrings().size());
        for (InstrumentString instrumentString : songTrack.getStrings()) {
            this.writeInstrumentString(instrumentString);
        }
        this.writeByte(songTrack.getOffset() - -24);
        this.writeRGBColor(songTrack.getColor());
    }

    private void writeMeasureHeader(MeasureHeader measureHeader, MeasureHeader measureHeader2) {
        int n = 0;
        if (measureHeader2 == null) {
            n |= 1;
            n |= 2;
            if (measureHeader.getTripletFeel() != 1) {
                n |= 0x20;
            }
        } else {
            int n2 = measureHeader.getTimeSignature().getNumerator();
            int n3 = measureHeader.getTimeSignature().getDenominator().getValue();
            int n4 = measureHeader2.getTimeSignature().getNumerator();
            int n5 = measureHeader2.getTimeSignature().getDenominator().getValue();
            if (n2 != n4 || n3 != n5) {
                n |= 1;
            }
            if (measureHeader.getTempo().getValue() != measureHeader2.getTempo().getValue()) {
                n |= 2;
            }
            if (measureHeader.getTripletFeel() != measureHeader2.getTripletFeel()) {
                n |= 0x20;
            }
        }
        n = measureHeader.isRepeatStart() ? (n = n | 4) : n;
        n = measureHeader.getNumberOfRepetitions() > 0 ? (n = n | 8) : n;
        n = measureHeader.hasMarker() ? (n = n | 0x10) : n;
        this.writeHeader(n);
        if ((n & 1) != 0) {
            this.writeTimeSignature(measureHeader.getTimeSignature());
        }
        if ((n & 2) != 0) {
            this.writeTempo(measureHeader.getTempo());
        }
        if ((n & 8) != 0) {
            this.writeShort((short)measureHeader.getNumberOfRepetitions());
        }
        if ((n & 0x10) != 0) {
            this.writeMarker(measureHeader.getMarker());
        }
        if ((n & 0x20) != 0) {
            this.writeByte(measureHeader.getTripletFeel());
        }
    }

    private void writeMeasure(Measure measure, Measure measure2) {
        int n = 0;
        if (measure2 == null) {
            n |= 1;
            n |= 2;
        } else {
            if (measure.getClef() != measure2.getClef()) {
                n |= 1;
            }
            if (measure.getKeySignature() != measure2.getKeySignature()) {
                n |= 2;
            }
        }
        this.writeHeader(n);
        List list = this.getMeasureComponents(measure);
        this.writeShort((short)list.size());
        Component component = null;
        for (Component component2 : list) {
            this.writeComponent(component2, component);
            component = component2;
        }
        if ((n & 1) != 0) {
            this.writeByte(measure.getClef());
        }
        if ((n & 2) != 0) {
            this.writeByte(measure.getKeySignature());
        }
    }

    private void writeChannel(SongChannel songChannel) {
        int n = 0;
        n = songChannel.isSolo() ? (n = n | 1) : n;
        n = songChannel.isMute() ? (n = n | 2) : n;
        this.writeHeader(n);
        this.writeByte(songChannel.getChannel());
        this.writeByte(songChannel.getEffectChannel());
        this.writeByte(songChannel.getInstrument());
        this.writeByte(songChannel.getVolume());
        this.writeByte(songChannel.getBalance());
        this.writeByte(songChannel.getChorus());
        this.writeByte(songChannel.getReverb());
        this.writeByte(songChannel.getPhaser());
        this.writeByte(songChannel.getTremolo());
    }

    private void writeComponent(Component component, Component component2) {
        Note note;
        int n = 0;
        if (component instanceof Note) {
            note = (Note)component;
            n |= 1;
            n = note.isTiedNote() ? (n = n | 4) : n;
            n = note.getEffect().hasEffects() || note.getEffect().isDeadNote() ? (n = n | 8) : n;
        } else if (component instanceof Silence) {
            n |= 2;
        }
        n = component2 == null || component.getStart() != component2.getStart() ? (n = n | 0x10) : n;
        n = component2 == null || !component.getDuration().isEqual(component2.getDuration()) ? (n = n | 0x20) : n;
        this.writeHeader(n);
        if ((n & 0x20) != 0) {
            this.writeDuration(component.getDuration());
        }
        if ((n & 1) != 0) {
            note = (Note)component;
            this.writeByte(note.getValue());
            this.writeByte(note.getVelocity());
            this.writeByte(note.getString());
            if ((n & 8) != 0) {
                this.writeNoteEffect(note.getEffect());
            }
        }
    }

    private void writeInstrumentString(InstrumentString instrumentString) {
        this.writeByte(instrumentString.getValue());
    }

    private void writeTempo(Tempo tempo) {
        this.writeShort((short)tempo.getValue());
    }

    private void writeTimeSignature(TimeSignature timeSignature) {
        this.writeByte(timeSignature.getNumerator());
        this.writeDuration(timeSignature.getDenominator());
    }

    private void writeDuration(Duration duration) {
        int n = 0;
        n = duration.isDotted() ? (n = n | 1) : n;
        n = duration.isDoubleDotted() ? (n = n | 2) : n;
        n = !duration.getTupleto().isEqual(Duration.NO_TUPLETO) ? (n = n | 4) : n;
        this.writeHeader(n);
        this.writeByte(duration.getValue());
        if ((n & 4) != 0) {
            this.writeTupleto(duration.getTupleto());
        }
    }

    private void writeTupleto(Tupleto tupleto) {
        this.writeByte(tupleto.getEnters());
        this.writeByte(tupleto.getTimes());
    }

    private void writeNoteEffect(NoteEffect noteEffect) {
        int n = 0;
        n = noteEffect.isVibrato() ? (n = n | 1) : n;
        n = noteEffect.isBend() ? (n = n | 2) : n;
        n = noteEffect.isDeadNote() ? (n = n | 4) : n;
        n = noteEffect.isSlide() ? (n = n | 8) : n;
        n = noteEffect.isHammer() ? (n = n | 0x10) : n;
        this.writeHeader(n);
        if ((n & 2) != 0) {
            this.writeBendEffect(noteEffect.getBend());
        }
    }

    private void writeBendEffect(BendEffect bendEffect) {
        this.writeByte(bendEffect.getPoints().size());
        for (BendEffect.BendPoint bendPoint : bendEffect.getPoints()) {
            this.writeByte(bendPoint.getPosition());
            this.writeByte(bendPoint.getValue());
        }
    }

    private void writeMarker(Marker marker) {
        this.writeString(marker.getTitle());
        this.writeRGBColor(marker.getColor());
    }

    private void writeRGBColor(RGBColor rGBColor) {
        this.writeShort((short)rGBColor.getR());
        this.writeShort((short)rGBColor.getG());
        this.writeShort((short)rGBColor.getB());
    }

    private List getMeasureComponents(Measure measure) {
        ArrayList<Component> arrayList = new ArrayList<Component>();
        arrayList.addAll(measure.getNotes());
        arrayList.addAll(measure.getSilences());
        for (int i = 0; i < arrayList.size(); ++i) {
            Component component = null;
            for (int j = i; j < arrayList.size(); ++j) {
                Component component2 = (Component)arrayList.get(j);
                if (component != null && component2.getStart() >= component.getStart()) continue;
                component = component2;
            }
            arrayList.remove(component);
            arrayList.add(i, component);
        }
        return arrayList;
    }

    public void writeByte(int n) {
        try {
            this.dataOutputStream.write(n);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void writeString(String string) {
        try {
            this.dataOutputStream.write(string.length());
            this.dataOutputStream.writeChars(string);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void writeHeader(int n) {
        try {
            this.dataOutputStream.write(n);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void writeShort(short s) {
        try {
            this.dataOutputStream.writeShort(s);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

