/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.io;

import java.io.FileNotFoundException;
import java.io.IOException;
import org.herac.tuxguitar.io.UnsupportedFormatException;
import org.herac.tuxguitar.io.gp.GP3InputStream;
import org.herac.tuxguitar.io.gp.GP4InputStream;
import org.herac.tuxguitar.io.gp.GP5InputStream;
import org.herac.tuxguitar.io.gp.GPFormatException;
import org.herac.tuxguitar.io.pt.PTB4InputStream;
import org.herac.tuxguitar.io.tg.TGInputStream;
import org.herac.tuxguitar.song.models.Song;

public class SongLoader {
    private String fileName;

    public SongLoader(String string) {
        this.fileName = string;
    }

    public Song load() throws GPFormatException, FileNotFoundException, IOException, UnsupportedFormatException {
        Object var1_1 = null;
        TGInputStream tGInputStream = new TGInputStream(this.fileName);
        if (tGInputStream.isSupportedVersion()) {
            return tGInputStream.read();
        }
        GP3InputStream gP3InputStream = new GP3InputStream(this.fileName);
        if (gP3InputStream.isSupportedVersion()) {
            return gP3InputStream.readSong();
        }
        GP4InputStream gP4InputStream = new GP4InputStream(this.fileName);
        if (gP4InputStream.isSupportedVersion()) {
            return gP4InputStream.readSong();
        }
        GP5InputStream gP5InputStream = new GP5InputStream(this.fileName);
        if (gP5InputStream.isSupportedVersion()) {
            return gP5InputStream.readSong();
        }
        PTB4InputStream pTB4InputStream = new PTB4InputStream(this.fileName);
        if (pTB4InputStream.isSupportedVersion()) {
            return pTB4InputStream.readSong();
        }
        throw new UnsupportedFormatException();
    }
}

