/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.util;

import java.io.File;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;

public class FileChooser {
    public static FilterFormat OPEN_FORMAT;
    public static FilterFormat IMPORT_MIDI_FORMAT;
    public static FilterFormat SAVE_FORMAT;
    public static FilterFormat EXPORT_MIDI_FORMAT;
    public static FilterFormat EXPORT_PDF_FORMAT;
    public static FilterFormat EXPORT_ASCII_FORMAT;
    public static FilterFormat ALL_FORMAT;
    private static FileChooser instance;
    private String path;

    public static FileChooser instance() {
        if (instance == null) {
            instance = new FileChooser();
        }
        return instance;
    }

    public String open(Shell shell, FilterFormat filterFormat, String string) {
        FileDialog fileDialog = new FileDialog(shell, 4096);
        fileDialog.setFilterPath(this.getPath());
        fileDialog.setFileName("*");
        fileDialog.setFilterNames(filterFormat.filterNames);
        fileDialog.setFilterExtensions(filterFormat.filterExtensions);
        String string2 = fileDialog.open();
        this.setPath(string2);
        return string2;
    }

    public String save(Shell shell, FilterFormat filterFormat, String string) {
        FileDialog fileDialog = new FileDialog(shell, 8192);
        fileDialog.setFilterPath(this.getPath());
        fileDialog.setFileName(string);
        fileDialog.setFilterNames(filterFormat.filterNames);
        fileDialog.setFilterExtensions(filterFormat.filterExtensions);
        String string2 = fileDialog.open();
        this.setPath(string2);
        return string2;
    }

    private String getPath() {
        return this.path;
    }

    private void setPath(String string) {
        if (string != null && string.length() > 0) {
            this.path = new File(string).getParent();
        }
    }

    static {
        FileChooser fileChooser = FileChooser.instance();
        fileChooser.getClass();
        OPEN_FORMAT = fileChooser.new FilterFormat(new String[]{"*.tg;*.gp3;*.gp4;*.gp5;*.ptb"}, new String[]{"Suported Files (*.tg,*.gp3,*.gp4,*.gp5,*.ptb)"});
        FileChooser fileChooser2 = FileChooser.instance();
        fileChooser2.getClass();
        IMPORT_MIDI_FORMAT = fileChooser2.new FilterFormat(new String[]{"*.mid"}, new String[]{"Suported Files (*.mid)"});
        FileChooser fileChooser3 = FileChooser.instance();
        fileChooser3.getClass();
        SAVE_FORMAT = fileChooser3.new FilterFormat(new String[]{"*.gp4", "*.gp3", "*.tg"}, null);
        FileChooser fileChooser4 = FileChooser.instance();
        fileChooser4.getClass();
        EXPORT_MIDI_FORMAT = fileChooser4.new FilterFormat(new String[]{"*.mid"}, null);
        FileChooser fileChooser5 = FileChooser.instance();
        fileChooser5.getClass();
        EXPORT_PDF_FORMAT = fileChooser5.new FilterFormat(new String[]{"*.pdf"}, null);
        FileChooser fileChooser6 = FileChooser.instance();
        fileChooser6.getClass();
        EXPORT_ASCII_FORMAT = fileChooser6.new FilterFormat(new String[]{"*.tab"}, null);
        FileChooser fileChooser7 = FileChooser.instance();
        fileChooser7.getClass();
        ALL_FORMAT = fileChooser7.new FilterFormat(null, null);
    }

    private class FilterFormat {
        private String[] filterExtensions;
        private String[] filterNames;

        private FilterFormat(String[] stringArray, String[] stringArray2) {
            this.filterExtensions = stringArray;
            this.filterNames = stringArray2;
        }
    }
}

