/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.undo.undoables.track;

import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.tab.Caret;
import org.herac.tuxguitar.gui.undo.CannotRedoException;
import org.herac.tuxguitar.gui.undo.CannotUndoException;
import org.herac.tuxguitar.gui.undo.UndoableEdit;
import org.herac.tuxguitar.gui.undo.undoables.UndoableCaretHelper;
import org.herac.tuxguitar.song.models.SongTrack;

public class UndoableAddTrack
implements UndoableEdit {
    private int doAction;
    private UndoableCaretHelper undoCaret;
    private UndoableCaretHelper redoCaret;
    private SongTrack redoableTrack;

    private UndoableAddTrack() {
    }

    public void redo() throws CannotRedoException {
        if (!this.canRedo()) {
            throw new CannotRedoException();
        }
        TuxGuitar.instance().getSongManager().addTrack((SongTrack)this.redoableTrack.clone(TuxGuitar.instance().getSongManager().getMeasureHeaders()));
        TuxGuitar.instance().fireUpdate();
        TuxGuitar.instance().getMixer().update();
        this.redoCaret.update();
        this.doAction = 1;
    }

    public void undo() throws CannotUndoException {
        if (!this.canUndo()) {
            throw new CannotUndoException();
        }
        TuxGuitar.instance().getSongManager().removeTrack(this.redoableTrack);
        TuxGuitar.instance().fireUpdate();
        TuxGuitar.instance().getMixer().update();
        this.undoCaret.update();
        this.doAction = 2;
    }

    public boolean canRedo() {
        return this.doAction == 2;
    }

    public boolean canUndo() {
        return this.doAction == 1;
    }

    public static UndoableAddTrack startUndo() {
        UndoableAddTrack undoableAddTrack = new UndoableAddTrack();
        Caret caret = UndoableAddTrack.getCaret();
        undoableAddTrack.doAction = 1;
        undoableAddTrack.undoCaret = new UndoableCaretHelper();
        return undoableAddTrack;
    }

    public UndoableAddTrack endUndo(SongTrack songTrack) {
        this.redoCaret = new UndoableCaretHelper();
        this.redoableTrack = (SongTrack)songTrack.clone(TuxGuitar.instance().getSongManager().getMeasureHeaders());
        return this;
    }

    private static Caret getCaret() {
        return TuxGuitar.instance().getTablatureEditor().getTablature().getCaret();
    }
}

