/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.undo.undoables.measure;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.tab.Caret;
import org.herac.tuxguitar.gui.undo.CannotRedoException;
import org.herac.tuxguitar.gui.undo.CannotUndoException;
import org.herac.tuxguitar.gui.undo.UndoableEdit;
import org.herac.tuxguitar.gui.undo.undoables.UndoableCaretHelper;
import org.herac.tuxguitar.song.helpers.TracksMeasures;
import org.herac.tuxguitar.song.models.Marker;

public class UndoableReplaceMeasures
implements UndoableEdit {
    private int doAction;
    private UndoableCaretHelper undoCaret;
    private UndoableCaretHelper redoCaret;
    private UndoMarkers undoMarkers;
    private TracksMeasures undoTrackMeasures;
    private TracksMeasures redoTrackMeasures;
    private int count;
    private int freeSpace;
    private long theMove;

    public UndoableReplaceMeasures(long l, long l2) {
        Caret caret = UndoableReplaceMeasures.getCaret();
        this.doAction = 1;
        this.undoCaret = new UndoableCaretHelper();
        this.undoMarkers = new UndoMarkers();
        this.undoTrackMeasures = TuxGuitar.instance().getSongManager().copyMeasures(l, l2);
    }

    public void redo() throws CannotRedoException {
        if (!this.canRedo()) {
            throw new CannotRedoException();
        }
        for (int i = this.freeSpace; i < this.count; ++i) {
            TuxGuitar.instance().getSongManager().addNewMeasureBeforeEnd();
        }
        TuxGuitar.instance().getSongManager().replaceMeasures((TracksMeasures)this.redoTrackMeasures.clone(), this.theMove);
        TuxGuitar.instance().fireUpdate();
        this.redoCaret.update();
        this.doAction = 1;
    }

    public void undo() throws CannotUndoException {
        if (!this.canUndo()) {
            throw new CannotUndoException();
        }
        for (int i = this.freeSpace; i < this.count; ++i) {
            TuxGuitar.instance().getSongManager().removeLastMeasure();
        }
        TuxGuitar.instance().getSongManager().replaceMeasures((TracksMeasures)this.undoTrackMeasures.clone(), 0L);
        TuxGuitar.instance().fireUpdate();
        this.undoMarkers.undo();
        this.undoCaret.update();
        this.doAction = 2;
    }

    public boolean canRedo() {
        return this.doAction == 2;
    }

    public boolean canUndo() {
        return this.doAction == 1;
    }

    private static Caret getCaret() {
        return TuxGuitar.instance().getTablatureEditor().getTablature().getCaret();
    }

    public UndoableReplaceMeasures endUndo(TracksMeasures tracksMeasures, int n, int n2, long l) {
        this.redoCaret = new UndoableCaretHelper();
        this.redoTrackMeasures = tracksMeasures;
        this.count = n;
        this.freeSpace = n2;
        this.theMove = l;
        return this;
    }

    private class UndoMarkers {
        private List markers = new ArrayList();

        public UndoMarkers() {
            Iterator iterator = TuxGuitar.instance().getSongManager().getMarkers().iterator();
            while (iterator.hasNext()) {
                this.markers.add(((Marker)iterator.next()).clone());
            }
        }

        public void undo() {
            TuxGuitar.instance().getSongManager().removeAllMarkers();
            for (Marker marker : this.markers) {
                TuxGuitar.instance().getSongManager().updateMarker((Marker)marker.clone());
            }
        }
    }
}

