/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.undo.undoables.component;

import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.tab.Caret;
import org.herac.tuxguitar.gui.tab.MeasureComponent;
import org.herac.tuxguitar.gui.undo.CannotRedoException;
import org.herac.tuxguitar.gui.undo.CannotUndoException;
import org.herac.tuxguitar.gui.undo.UndoableEdit;
import org.herac.tuxguitar.song.managers.SongManager;
import org.herac.tuxguitar.song.models.Component;
import org.herac.tuxguitar.song.models.Measure;
import org.herac.tuxguitar.song.models.Note;
import org.herac.tuxguitar.song.models.Silence;
import org.herac.tuxguitar.song.models.SongTrack;

public class UndoableComponentChange
implements UndoableEdit {
    private int doAction;
    private long trackNumber;
    private long caretPosition;
    private int caretString;
    private UndoComponent undoComponent;
    private RedoComponent redoComponent;

    private UndoableComponentChange() {
    }

    public void redo() throws CannotRedoException {
        if (!this.canRedo()) {
            throw new CannotRedoException();
        }
        this.redoComponent.redo();
        this.doAction = 1;
    }

    public void undo() throws CannotUndoException {
        if (!this.canUndo()) {
            throw new CannotUndoException();
        }
        this.undoComponent.undo();
        this.doAction = 2;
    }

    public boolean canRedo() {
        return this.doAction == 2;
    }

    public boolean canUndo() {
        return this.doAction == 1;
    }

    public static UndoableComponentChange startUndo() {
        Caret caret = UndoableComponentChange.getCaret();
        MeasureComponent measureComponent = caret.getMeasureCoords().getComponentOrSilence(caret.getPosition(), caret.getSelectedString().getNumber());
        UndoableComponentChange undoableComponentChange = new UndoableComponentChange();
        undoableComponentChange.doAction = 1;
        undoableComponentChange.trackNumber = caret.getSongTrackCoords().getTrack().getNumber();
        undoableComponentChange.caretPosition = caret.getPosition();
        undoableComponentChange.caretString = caret.getSelectedString().getNumber();
        UndoableComponentChange undoableComponentChange2 = undoableComponentChange;
        undoableComponentChange2.getClass();
        undoableComponentChange.undoComponent = undoableComponentChange2.new UndoComponent(measureComponent == null ? null : measureComponent.getComponent());
        return undoableComponentChange;
    }

    public static UndoableComponentChange startUndo(Component component) {
        Caret caret = UndoableComponentChange.getCaret();
        UndoableComponentChange undoableComponentChange = new UndoableComponentChange();
        undoableComponentChange.doAction = 1;
        undoableComponentChange.trackNumber = caret.getSongTrackCoords().getTrack().getNumber();
        undoableComponentChange.caretPosition = caret.getPosition();
        undoableComponentChange.caretString = caret.getSelectedString().getNumber();
        UndoableComponentChange undoableComponentChange2 = undoableComponentChange;
        undoableComponentChange2.getClass();
        undoableComponentChange.undoComponent = undoableComponentChange2.new UndoComponent(component);
        return undoableComponentChange;
    }

    public UndoableComponentChange endUndo(Component component) {
        this.redoComponent = new RedoComponent(component);
        return this;
    }

    private static Caret getCaret() {
        return TuxGuitar.instance().getTablatureEditor().getTablature().getCaret();
    }

    private class RedoComponent {
        private Component component;

        public RedoComponent(Component component) {
            if (component != null) {
                this.component = (Component)component.clone();
            }
        }

        public void redo() {
            SongManager songManager = TuxGuitar.instance().getSongManager();
            SongTrack songTrack = songManager.getTrack(UndoableComponentChange.this.trackNumber);
            Measure measure = songManager.getTrackManager().getMeasureAt(songTrack, UndoableComponentChange.this.caretPosition);
            if (this.component instanceof Note) {
                songManager.getMeasureManager().addNote(measure, (Note)this.component.clone());
            } else if (this.component instanceof Silence) {
                songManager.getMeasureManager().addSilence(measure, (Silence)this.component.clone());
            } else {
                songManager.getMeasureManager().removeComponentsAt(measure, UndoableComponentChange.this.caretPosition, UndoableComponentChange.this.caretString, true);
            }
            TuxGuitar.instance().getTablatureEditor().getTablature().getViewLayout().fireUpdate(measure.getNumber(), false);
            UndoableComponentChange.getCaret().update(UndoableComponentChange.this.trackNumber, UndoableComponentChange.this.caretPosition, UndoableComponentChange.this.caretString);
        }
    }

    private class UndoComponent {
        private Component component;

        public UndoComponent(Component component) {
            if (component != null) {
                this.component = (Component)component.clone();
            }
        }

        public void undo() {
            SongManager songManager = TuxGuitar.instance().getSongManager();
            SongTrack songTrack = songManager.getTrack(UndoableComponentChange.this.trackNumber);
            Measure measure = songManager.getTrackManager().getMeasureAt(songTrack, UndoableComponentChange.this.caretPosition);
            if (measure != null) {
                if (this.component instanceof Note) {
                    songManager.getMeasureManager().addNote(measure, (Note)this.component.clone());
                } else if (this.component instanceof Silence) {
                    songManager.getMeasureManager().addSilence(measure, (Silence)this.component.clone());
                } else {
                    songManager.getMeasureManager().removeComponentsAt(measure, UndoableComponentChange.this.caretPosition, UndoableComponentChange.this.caretString, true);
                }
                TuxGuitar.instance().getTablatureEditor().getTablature().getViewLayout().fireUpdate(measure.getNumber(), false);
                UndoableComponentChange.getCaret().update(UndoableComponentChange.this.trackNumber, UndoableComponentChange.this.caretPosition, UndoableComponentChange.this.caretString);
            }
        }
    }
}

