/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.table;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.herac.tuxguitar.gui.TablatureEditor;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.tab.MeasureCoords;
import org.herac.tuxguitar.gui.tab.SongTrackCoords;
import org.herac.tuxguitar.gui.table.SongTable;
import org.herac.tuxguitar.song.models.RGBColor;
import org.herac.tuxguitar.song.models.SongChannel;
import org.herac.tuxguitar.song.models.SongTrack;

public class SongTableInfo
extends Composite {
    private static final int TABLE_COLUMN_NUMBER = 0;
    private static final int TABLE_COLUMN_NAME = 1;
    private static final int TABLE_COLUMN_INSTRUMENT = 2;
    private static final int TABLE_COLUMN_CHANNEL = 3;
    private static final int TABLE_COLUMN_EFFECT_CHANNEL = 4;
    private static final Color[] BACKGROUNDS = new Color[]{new Color((Device)TuxGuitar.instance().getDisplay(), 255, 255, 255), new Color((Device)TuxGuitar.instance().getDisplay(), 238, 238, 238), new Color((Device)TuxGuitar.instance().getDisplay(), 192, 192, 192)};
    private TablatureEditor editor;
    private ScrollBar hSroll;
    private ScrolledComposite scrolledComposite;
    private SongTable table;
    private Composite trackMeasures;
    private Button trackMeasuresHeader;
    private Canvas painter;
    private int measureLength;
    private long lastTrackSelection;
    private MeasureCoords lasPlayedMeasure;

    public SongTableInfo(Composite composite, TablatureEditor tablatureEditor) {
        super(composite, 2304);
        this.setLayout((Layout)new FillLayout());
        this.editor = tablatureEditor;
        this.init();
        this.hSroll = this.getHorizontalBar();
        this.hSroll.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                SongTableInfo.this.painter.redraw();
            }
        });
        this.redraw();
    }

    private void init() {
        this.scrolledComposite = new ScrolledComposite((Composite)this, 512);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginTop = 0;
        gridLayout.marginBottom = 0;
        gridLayout.marginLeft = 0;
        gridLayout.marginRight = 0;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        this.scrolledComposite.setLayout((Layout)gridLayout);
        SashForm sashForm = new SashForm((Composite)this.scrolledComposite, 256);
        sashForm.SASH_WIDTH = 2;
        this.initTable((Composite)sashForm);
        this.initTrackMeasures((Composite)sashForm);
        this.scrolledComposite.setContent((Control)sashForm);
        this.scrolledComposite.setExpandHorizontal(true);
        this.scrolledComposite.setExpandVertical(true);
    }

    private void initTable(Composite composite) {
        this.table = new SongTable(composite, 5, this.editor);
        this.loadProperties();
        this.table.setWeights(new int[]{1, 7, 5, 3, 2});
        this.updateTable();
    }

    private void initTrackMeasures(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new FillLayout(512));
        this.trackMeasures = new Composite(composite2, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginTop = 0;
        gridLayout.marginBottom = 0;
        gridLayout.marginLeft = 0;
        gridLayout.marginRight = 0;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        this.trackMeasures.setLayout((Layout)gridLayout);
        this.trackMeasuresHeader = new Button(this.trackMeasures, 8);
        this.trackMeasuresHeader.setLayoutData((Object)new GridData(4, 128, true, false, 0, 0));
        this.trackMeasuresHeader.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent mouseEvent) {
                TuxGuitar.instance().getAction("CHANGE_INFO").process((TypedEvent)mouseEvent);
            }
        });
        this.painter = new Canvas(this.trackMeasures, 0x20000000);
        this.painter.setLayoutData((Object)new GridData(4, 4, true, true, 0, 0));
        this.painter.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent paintEvent) {
                SongTableInfo.this.updateTrackMeasuresHeader();
                SongTableInfo.this.paintMeasures(paintEvent.gc, -SongTableInfo.this.hSroll.getSelection(), 0);
                paintEvent.gc.dispose();
            }
        });
        this.painter.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent mouseEvent) {
                SongTrackCoords songTrackCoords;
                int n;
                int n2 = SongTableInfo.this.getSelectedTrackIndex(mouseEvent.y);
                if (n2 >= 0 && (n = SongTableInfo.this.getSelectedMeasureIndex(songTrackCoords = (SongTrackCoords)SongTableInfo.this.editor.getTablature().getSongCoords().getTrackCoords().get(n2), mouseEvent.x)) >= 0) {
                    MeasureCoords measureCoords = (MeasureCoords)songTrackCoords.getMeasuresCoords().get(n);
                    SongTableInfo.this.editor.getTablature().getCaret().moveTo(songTrackCoords, measureCoords, measureCoords.getFirstComponent());
                    SongTableInfo.this.editor.getTablature().getCaret().setChanges(true);
                    TuxGuitar.instance().redraw();
                }
            }
        });
    }

    private void updateTable() {
        List list = this.editor.getTablature().getSongCoords().getTrackCoords();
        int n = list.size();
        this.table.clearColumnsAfter(n);
        this.makeTableItems(n);
        for (int i = 0; i < list.size(); ++i) {
            SongTrackCoords songTrackCoords = (SongTrackCoords)list.get(i);
            String string = Long.toString(songTrackCoords.getTrack().getNumber());
            String string2 = songTrackCoords.getTrack().getName();
            String string3 = "";
            string3 = songTrackCoords.getTrack().isPercussionTrack() ? TuxGuitar.getProperty("track.name.default-percussion-name") : this.editor.getSongManager().getInstrumentName(songTrackCoords.getTrack().getChannel().getInstrument());
            this.updateTableItems(i, new String[]{string, string2, string3}, songTrackCoords);
        }
        this.updateItemBackgrounds();
        this.table.layout();
    }

    private void makeTableItems(int n) {
        Combo combo;
        CLabel cLabel;
        int n2;
        int n3;
        GridData gridData = new GridData(4, 0x1000000, true, true, 0, 0);
        gridData.heightHint = 22;
        int n4 = n3 = this.table.getColumn(0).getItemCount();
        while (n4 < n) {
            n2 = n4++;
            cLabel = new CLabel((Composite)this.table.getColumn(0), 16384);
            cLabel.setLayoutData((Object)gridData);
            cLabel.addMouseListener((MouseListener)new ItemSelectionListener());
            cLabel = new CLabel((Composite)this.table.getColumn(1), 16384);
            cLabel.setLayoutData((Object)gridData);
            cLabel.addMouseListener((MouseListener)new ItemSelectionListener());
            cLabel = new CLabel((Composite)this.table.getColumn(2), 16384);
            cLabel.setLayoutData((Object)gridData);
            cLabel.addMouseListener((MouseListener)new ItemSelectionListener());
            combo = new Combo((Composite)this.table.getColumn(3), 16384);
            combo.setLayoutData((Object)new GridData(768));
            combo.setData((Object)new ChannelList());
            this.updateChannelCombo(combo, (ChannelList)combo.getData(), n2);
            final Combo combo2 = new Combo((Composite)this.table.getColumn(4), 16384);
            combo2.setLayoutData((Object)new GridData(768));
            combo2.setData((Object)new ChannelList());
            this.updateEffectChannelCombo(combo2, (ChannelList)combo2.getData(), n2);
            combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    if (selectionEvent.widget.getData() instanceof ChannelList) {
                        SongChannel songChannel = ((SongTrack)TuxGuitar.instance().getSongManager().getSong().getTracks().get(n2)).getChannel();
                        boolean[] blArray = TuxGuitar.instance().getSongManager().getUsedChannels();
                        boolean[] blArray2 = TuxGuitar.instance().getSongManager().getUsedEffectChannels();
                        ChannelList channelList = (ChannelList)selectionEvent.widget.getData();
                        int n = channelList.getChannel(combo.getSelectionIndex());
                        if (!blArray[n]) {
                            songChannel.setChannel((short)n);
                            songChannel.setEffectChannel(songChannel.getChannel());
                        } else {
                            SongChannel songChannel2 = TuxGuitar.instance().getSongManager().getUsedChannel(n);
                            songChannel.setChannel(songChannel2.getChannel());
                            songChannel.setEffectChannel(songChannel2.getEffectChannel());
                            songChannel.setVolume(songChannel2.getVolume());
                            songChannel.setBalance(songChannel2.getBalance());
                            songChannel.setChorus(songChannel2.getChorus());
                            songChannel.setInstrument(songChannel2.getInstrument());
                            songChannel.setPhaser(songChannel2.getPhaser());
                            songChannel.setReverb(songChannel2.getReverb());
                            songChannel.setTremolo(songChannel2.getTremolo());
                            songChannel.setSolo(songChannel2.isSolo());
                            songChannel.setMute(songChannel2.isMute());
                        }
                        SongTableInfo.this.fireChannelChange(songChannel);
                        TuxGuitar.instance().getMixer().update();
                    }
                }
            });
            combo2.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    if (selectionEvent.widget.getData() instanceof ChannelList) {
                        SongChannel songChannel = ((SongTrack)TuxGuitar.instance().getSongManager().getSong().getTracks().get(n2)).getChannel();
                        ChannelList channelList = (ChannelList)selectionEvent.widget.getData();
                        int n = channelList.getChannel(combo2.getSelectionIndex());
                        songChannel.setEffectChannel((short)n);
                        SongTableInfo.this.fireChannelChange(songChannel);
                        TuxGuitar.instance().getMixer().update();
                    }
                }
            });
        }
        List list = TuxGuitar.instance().getSongManager().getSong().getTracks();
        for (n2 = 0; n2 < list.size(); ++n2) {
            cLabel = (Combo)this.table.getColumn(3).getItem(n2);
            combo = (Combo)this.table.getColumn(4).getItem(n2);
            this.updateChannelCombo((Combo)cLabel, (ChannelList)cLabel.getData(), n2);
            this.updateEffectChannelCombo(combo, (ChannelList)combo.getData(), n2);
        }
    }

    private void updateItemBackgrounds() {
        this.lastTrackSelection = this.editor.getTablature().getCaret().getSongTrackCoords().getTrack().getNumber();
        int n = this.table.getColumn(0).getItemCount();
        for (int i = 0; i < n; ++i) {
            CLabel cLabel = (CLabel)this.table.getColumn(0).getItem(i);
            Color color = BACKGROUNDS[i % 2];
            long l = Long.parseLong(cLabel.getText());
            if (l == this.lastTrackSelection) {
                color = BACKGROUNDS[2];
            }
            cLabel.setBackground(color);
            cLabel = (CLabel)this.table.getColumn(1).getItem(i);
            cLabel.setBackground(color);
            cLabel = (CLabel)this.table.getColumn(2).getItem(i);
            cLabel.setBackground(color);
        }
    }

    private void updateTableItems(int n, String[] stringArray, Object object) {
        for (int i = 0; i < stringArray.length; ++i) {
            CLabel cLabel = (CLabel)this.table.getColumn(i).getItem(n);
            cLabel.setData(object);
            cLabel.setText(stringArray[i]);
        }
    }

    private void updateTrackMeasuresHeader() {
        ((GridData)this.trackMeasuresHeader.getLayoutData()).heightHint = this.table.getColumn(0).getHeaderHeight();
        this.trackMeasuresHeader.setText(this.editor.getSongManager().getSong().getName());
    }

    private void paintMeasures(GC gC, int n, int n2) {
        int n3 = this.trackMeasures.getBounds().width;
        int n4 = this.table.getColumn(4).getItemHeight();
        int n5 = n;
        int n6 = 0;
        int n7 = 0;
        boolean bl = this.editor.getSongManager().getPlayer().isRunning();
        this.lasPlayedMeasure = null;
        List list = this.editor.getTablature().getSongCoords().getTrackCoords();
        int n8 = list.size();
        for (int i = 0; i < n8; ++i) {
            SongTrackCoords songTrackCoords = (SongTrackCoords)list.get(i);
            Control control = this.table.getColumn(0).getItem(i);
            Rectangle rectangle = control.getBounds();
            if (i == 0) {
                n7 = rectangle.y;
            }
            n6 = n2 + (rectangle.y - n7);
            gC.setBackground(this.getDisplay().getSystemColor(15));
            gC.fillRectangle(0, n6, n3, n4 - 1);
            RGBColor rGBColor = songTrackCoords.getTrack().getColor();
            Color color = new Color((Device)this.getDisplay(), rGBColor.getR(), rGBColor.getG(), rGBColor.getB());
            gC.setBackground(color);
            gC.setForeground(color);
            List list2 = songTrackCoords.getMeasuresCoords();
            this.measureLength = list2.size();
            for (int j = 0; j < this.measureLength; ++j) {
                MeasureCoords measureCoords = (MeasureCoords)list2.get(j);
                if (measureCoords.getMeasure().getNotes().isEmpty()) {
                    gC.drawRectangle(n5, n6, n4 - 2, n4 - 2);
                } else {
                    gC.fillRectangle(n5, n6, n4 - 1, n4 - 1);
                }
                if (bl && measureCoords.isPlaying() || !bl && measureCoords.hasCaret()) {
                    gC.setBackground(this.getDisplay().getSystemColor(2));
                    gC.fillRectangle(n5 + 4, n6 + 4, n4 - 9, n4 - 9);
                    gC.setBackground(color);
                    this.lasPlayedMeasure = measureCoords;
                }
                n5 += n4;
            }
            n5 = n;
            n6 += n4;
            color.dispose();
        }
        gC.setBackground(this.getDisplay().getSystemColor(2));
        this.trackMeasures.layout();
    }

    private int getSelectedTrackIndex(int n) {
        int n2 = this.table.getColumn(4).getItemHeight();
        List list = this.editor.getTablature().getSongCoords().getTrackCoords();
        int n3 = list.size();
        int n4 = 0;
        for (int i = 0; i < n3; ++i) {
            if (n >= n4 && n < n4 + n2) {
                return i;
            }
            n4 += n2;
        }
        return 0;
    }

    private int getSelectedMeasureIndex(SongTrackCoords songTrackCoords, int n) {
        int n2 = this.table.getColumn(4).getItemHeight();
        List list = songTrackCoords.getMeasuresCoords();
        int n3 = list.size();
        int n4 = -this.hSroll.getSelection();
        for (int i = 0; i < n3; ++i) {
            if (n >= n4 && n < n4 + n2) {
                return i;
            }
            n4 += n2;
        }
        return 0;
    }

    public void updateScrolls() {
        int n = this.table.getColumn(4).getItemHeight();
        this.scrolledComposite.setMinSize(0, n + n * this.table.getColumn(4).getItemCount() + 10);
        int n2 = this.editor.getTablature().getCaret().getSongTrackCoords().getMeasuresCoords().size() * n;
        this.hSroll.setMaximum(n2);
        this.hSroll.setThumb(Math.min(n2, this.painter.getClientArea().width));
        this.hSroll.setVisible(n2 > this.painter.getClientArea().width);
    }

    public void loadProperties() {
        this.updateTable();
        this.table.getColumn(0).setName(TuxGuitar.getProperty("track.number"));
        this.table.getColumn(1).setName(TuxGuitar.getProperty("track.name"));
        this.table.getColumn(2).setName(TuxGuitar.getProperty("track.instrument"));
        this.table.getColumn(3).setName(TuxGuitar.getProperty("track.channel.channel"));
        this.table.getColumn(4).setName(TuxGuitar.getProperty("track.channel.effect-channel"));
    }

    public void fireUpdate() {
        this.updateTable();
    }

    public int getHeight() {
        return this.table.getBounds().height;
    }

    public void redraw() {
        if (!super.isDisposed()) {
            if (this.editor.getTablature().getCaret().getSongTrackCoords().getTrack().getNumber() != this.lastTrackSelection) {
                this.updateItemBackgrounds();
            }
            this.painter.redraw();
            this.updateScrolls();
            super.redraw();
        }
    }

    public void redrawPlayingMode() {
        if (!super.isDisposed()) {
            if (this.editor.getTablature().getCaret().getSongTrackCoords().getTrack().getNumber() != this.lastTrackSelection) {
                this.updateItemBackgrounds();
            }
            if (this.lasPlayedMeasure == null || !this.lasPlayedMeasure.isPlaying()) {
                this.painter.redraw();
            }
        }
    }

    private void updateChannelCombo(Combo combo, ChannelList channelList, int n) {
        combo.removeAll();
        channelList.clear();
        SongChannel songChannel = ((SongTrack)TuxGuitar.instance().getSongManager().getSong().getTracks().get(n)).getChannel();
        boolean[] blArray = TuxGuitar.instance().getSongManager().getUsedChannels();
        boolean[] blArray2 = TuxGuitar.instance().getSongManager().getUsedEffectChannels();
        if (songChannel.isPercusionChannel()) {
            combo.add(Integer.toString(9));
            combo.select(0);
            channelList.addChannel(0, 0);
        } else {
            int n2 = 0;
            for (int i = 0; i < blArray.length; ++i) {
                if (i == 9 || blArray2[i] && (!blArray2[i] || !blArray[i]) && (songChannel.getChannel() != i || songChannel.getEffectChannel() != songChannel.getChannel())) continue;
                String string = new String();
                string = blArray[i] && (songChannel.getChannel() != i || TuxGuitar.instance().getSongManager().countTracksForChannel(i) > 1) ? i + " " + TuxGuitar.getProperty("track.channel.link") : i + " " + TuxGuitar.getProperty("track.channel.free");
                combo.add(string);
                if (i == songChannel.getChannel()) {
                    combo.select(n2);
                }
                channelList.addChannel(n2, i);
                ++n2;
            }
        }
    }

    private void updateEffectChannelCombo(Combo combo, ChannelList channelList, int n) {
        combo.removeAll();
        channelList.clear();
        SongChannel songChannel = ((SongTrack)TuxGuitar.instance().getSongManager().getSong().getTracks().get(n)).getChannel();
        boolean[] blArray = TuxGuitar.instance().getSongManager().getUsedChannels();
        boolean[] blArray2 = TuxGuitar.instance().getSongManager().getUsedEffectChannels();
        if (songChannel.isPercusionChannel()) {
            combo.add(Integer.toString(9));
            combo.select(0);
            channelList.addChannel(0, 0);
        } else {
            int n2 = 0;
            for (int i = 0; i < blArray2.length; ++i) {
                if (i == 9 || blArray2[i] && songChannel.getEffectChannel() != i || blArray[i] && i != songChannel.getChannel()) continue;
                combo.add(Integer.toString(i));
                if (i == songChannel.getEffectChannel()) {
                    combo.select(n2);
                }
                channelList.addChannel(n2, i);
                ++n2;
            }
        }
    }

    public void fireChannelChange(SongChannel songChannel) {
        List list = TuxGuitar.instance().getSongManager().getSong().getTracks();
        for (int i = 0; i < list.size(); ++i) {
            SongTrack songTrack = (SongTrack)list.get(i);
            if (songTrack.getChannel().getChannel() != songChannel.getChannel()) continue;
            songTrack.getChannel().setEffectChannel(songChannel.getEffectChannel());
            songTrack.getChannel().setVolume(songChannel.getVolume());
            songTrack.getChannel().setBalance(songChannel.getBalance());
            songTrack.getChannel().setChorus(songChannel.getChorus());
            songTrack.getChannel().setReverb(songChannel.getReverb());
            songTrack.getChannel().setPhaser(songChannel.getPhaser());
            songTrack.getChannel().setTremolo(songChannel.getTremolo());
            songTrack.getChannel().setSolo(songChannel.isSolo());
            songTrack.getChannel().setMute(songChannel.isMute());
        }
        this.updateTable();
        this.redraw();
    }

    public static void disposeColors() {
        for (int i = 0; i < BACKGROUNDS.length; ++i) {
            BACKGROUNDS[i].dispose();
        }
    }

    private class ChannelIndex {
        private int index;
        private int channel;

        public ChannelIndex(int n, int n2) {
            this.index = n;
            this.channel = n2;
        }

        public int getChannel() {
            return this.channel;
        }

        public int getIndex() {
            return this.index;
        }
    }

    private class ChannelList {
        private List channelIndexs = new ArrayList();

        public void addChannel(int n, int n2) {
            this.channelIndexs.add(new ChannelIndex(n, n2));
        }

        public int getChannel(int n) {
            for (ChannelIndex channelIndex : this.channelIndexs) {
                if (n != channelIndex.getIndex()) continue;
                return channelIndex.getChannel();
            }
            return -1;
        }

        public void clear() {
            this.channelIndexs.clear();
        }
    }

    private class ItemSelectionListener
    extends MouseAdapter {
        private ItemSelectionListener() {
        }

        public void mouseDown(MouseEvent mouseEvent) {
            TuxGuitar.instance().getAction("GO_TO_TRACK").process((TypedEvent)mouseEvent);
        }

        public void mouseDoubleClick(MouseEvent mouseEvent) {
            TuxGuitar.instance().getAction("CHANGE_TRACK_PROPERTIES").process((TypedEvent)mouseEvent);
        }
    }
}

