/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.tab.layout;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.herac.tuxguitar.gui.tab.MeasureCoords;
import org.herac.tuxguitar.gui.tab.SongTrackCoords;
import org.herac.tuxguitar.gui.tab.Tablature;
import org.herac.tuxguitar.gui.tab.layout.ViewLayout;
import org.herac.tuxguitar.song.managers.SongManager;
import org.herac.tuxguitar.song.models.InstrumentString;

public class PageViewLayout
extends ViewLayout {
    private int displayWidth;
    private int divisionCount;

    public PageViewLayout(Tablature tablature, SongManager songManager, boolean bl, boolean bl2) {
        super(tablature, songManager, bl, bl2);
        this.displayWidth = this.getTablature().getDisplay().getBounds().width - 35;
    }

    public void paintSong(GC gC, Rectangle rectangle, int n, int n2) {
        this.clearTrackPositions();
        if (this.isMultitrack()) {
            this.paintTracks(this.getTablature().getCaret().getSongCoords().getTrackCoords(), gC, rectangle, n, n2);
        } else {
            ArrayList<SongTrackCoords> arrayList = new ArrayList<SongTrackCoords>();
            arrayList.add(this.getTablature().getCaret().getSongTrackCoords());
            this.paintTracks(arrayList, gC, rectangle, n, n2);
        }
    }

    public void paintMeasures(SongTrackCoords songTrackCoords, List list, GC gC, int n, int n2, Rectangle rectangle) {
        int n3;
        songTrackCoords.setPosY(n2);
        int n4 = songTrackCoords.getPosX();
        int n5 = songTrackCoords.getPosY();
        int n6 = 0;
        int n7 = 0;
        this.divisionCount = 1;
        int n8 = 20;
        ArrayList<MeasureCoords> arrayList = new ArrayList<MeasureCoords>();
        for (n3 = 0; n3 < list.size(); ++n3) {
            boolean bl;
            MeasureCoords measureCoords = (MeasureCoords)list.get(n3);
            measureCoords.calculateWidth();
            boolean bl2 = n4 + n > rectangle.x - 1500 && n4 + n < rectangle.x + rectangle.width + 100;
            boolean bl3 = bl = n5 > rectangle.y - DEFAULT_TRACK_SPAN && n5 < rectangle.y + rectangle.height + DEFAULT_TRACK_SPAN;
            if (n8 + measureCoords.getWidth() >= this.getMaxWidth() && !arrayList.isEmpty()) {
                int n9 = 0;
                int n10 = this.getMaxWidth() - n8;
                if (n10 != 0 && arrayList.size() > 0) {
                    n9 = n10 / arrayList.size();
                }
                for (MeasureCoords measureCoords2 : arrayList) {
                    measureCoords2.setPosX(n4);
                    measureCoords2.setPosY(n5);
                    if (bl2 && bl) {
                        this.paintMeasure(measureCoords2, gC, n4 + n, n5, n9, rectangle);
                    } else {
                        measureCoords2.setOutOfBounds(true);
                    }
                    if ((n4 += measureCoords2.getWidth() + measureCoords2.getSpan()) <= n6) continue;
                    n6 = n4;
                }
                if (bl2 && bl) {
                    this.paintStrings(songTrackCoords, gC, n, n5, n4);
                    this.addTrackPosition((int)songTrackCoords.getTrack().getNumber(), n5, 200 + this.getScoreSpan());
                }
                n4 = songTrackCoords.getPosX();
                n5 += this.getLinearSpan();
                n7 += this.getLinearSpan();
                n8 = 20;
                arrayList.clear();
                ++this.divisionCount;
            }
            n8 += measureCoords.getWidth();
            measureCoords.setFirstOfLine(arrayList.isEmpty());
            arrayList.add(measureCoords);
        }
        n3 = n4 + n > rectangle.x - 1500 && n4 + n < rectangle.x + rectangle.width + 100 ? 1 : 0;
        boolean bl = n5 > rectangle.y - DEFAULT_TRACK_SPAN && n5 < rectangle.y + rectangle.height + DEFAULT_TRACK_SPAN;
        for (MeasureCoords measureCoords : arrayList) {
            measureCoords.setPosX(n4);
            measureCoords.setPosY(n5);
            if (n3 != 0 && bl) {
                this.paintMeasure(measureCoords, gC, n4 + n, n5, 0, rectangle);
            }
            if ((n4 += measureCoords.getWidth() + measureCoords.getSpan()) <= n6) continue;
            n6 = n4;
        }
        if (n3 != 0 && bl) {
            int n11 = this.getMaxWidth() - 15;
            n11 = n4 > n11 - 20 ? n4 : n11;
            this.paintStrings(songTrackCoords, gC, n, n5, n11);
        }
        this.setWidth(n6);
        this.setHeight((n7 += this.getLinearSpan()) + DEFAULT_TRACK_SPAN + 100);
    }

    public void paintStrings(SongTrackCoords songTrackCoords, GC gC, int n, int n2, int n3) {
        int n4 = songTrackCoords.getPosX();
        if (this.isScoreEnabled()) {
            int n5 = 0;
            for (int i = 1; i <= 5; ++i) {
                n5 = n2 + i * this.getScoreLineSpan();
                gC.drawLine(n + n4, n5, n + n3, n5);
            }
            n2 += this.getScoreSpan();
        }
        for (InstrumentString instrumentString : songTrackCoords.getTrack().getStrings()) {
            int n6 = instrumentString.getNumber() * this.getStringSpan();
            gC.drawLine(n + n4, n2 + n6, n + n3, n2 + n6);
        }
    }

    public SongTrackCoords getTrackAt(List arrayList, int n, int n2) {
        if (!this.isMultitrack()) {
            arrayList = new ArrayList<SongTrackCoords>();
            arrayList.add(this.getTablature().getCaret().getSongTrackCoords());
        }
        SongTrackCoords songTrackCoords = null;
        int n3 = this.getLinearSpan();
        for (int i = 0; i < arrayList.size(); ++i) {
            SongTrackCoords songTrackCoords2 = (SongTrackCoords)arrayList.get(i);
            int n4 = songTrackCoords2.getHeight();
            for (int j = 0; j < this.divisionCount; ++j) {
                int n5 = songTrackCoords2.getPosY() + j * n3;
                if (n >= n5 - DEFAULT_TRACK_SPAN / 2 && n <= n5 + n4 + DEFAULT_TRACK_SPAN / 2) {
                    songTrackCoords = songTrackCoords2;
                }
                n5 += n3;
            }
        }
        return songTrackCoords;
    }

    public void followMeasure(MeasureCoords measureCoords, boolean bl) {
        this.getTablature().moveScrollVerticalTo(measureCoords, this.getDefaultFirstTrackSpan(), this.getDefaultFirstTrackSpan() - measureCoords.getTabHeight() + measureCoords.getScoreSpan(), bl);
    }

    private int getLinearSpan() {
        int n = 200;
        if (this.isScoreEnabled()) {
            n += this.getScoreSpan();
        }
        if (this.isMultiTrack()) {
            n *= this.getTrackCount();
        }
        return n;
    }

    public int getMaxWidth() {
        return this.displayWidth;
    }

    public TempLine getTempLines(int n, List list, int n2) {
        boolean bl = false;
        boolean bl2 = false;
        this.divisionCount = 1;
        TempLine tempLine = new TempLine();
        tempLine.tempWith = 20;
        for (int i = n2; i < list.size(); ++i) {
            MeasureCoords measureCoords = (MeasureCoords)list.get(i);
            measureCoords.calculateWidth();
            if (tempLine.tempWith + measureCoords.getWidth() >= this.getMaxWidth() && !tempLine.measures.isEmpty()) {
                tempLine.fullLine = true;
                return tempLine;
            }
            tempLine.tempWith += measureCoords.getWidth();
            tempLine.maxY = measureCoords.getMaxY() > tempLine.maxY ? measureCoords.getMaxY() : tempLine.maxY;
            tempLine.minY = measureCoords.getMinY() < tempLine.minY ? measureCoords.getMinY() : tempLine.minY;
            tempLine.addMeasure(i);
        }
        return tempLine;
    }

    public void paintLine(SongTrackCoords songTrackCoords, TempLine tempLine, GC gC, int n, int n2, Rectangle rectangle) {
        int n3;
        songTrackCoords.setPosY(n2);
        int n4 = songTrackCoords.getPosX();
        int n5 = songTrackCoords.getPosY();
        int n6 = 0;
        boolean bl = false;
        boolean bl2 = n4 + n > rectangle.x - 1500 && n4 + n < rectangle.x + rectangle.width + 100;
        boolean bl3 = n5 > rectangle.y - DEFAULT_TRACK_SPAN && n5 < rectangle.y + rectangle.height + DEFAULT_TRACK_SPAN;
        int n7 = 0;
        if (tempLine.fullLine && (n3 = this.getMaxWidth() - tempLine.tempWith) != 0 && tempLine.measures.size() > 0) {
            n7 = n3 / tempLine.measures.size();
        }
        for (n3 = 0; n3 < tempLine.measures.size(); ++n3) {
            Integer n8 = (Integer)tempLine.measures.get(n3);
            MeasureCoords measureCoords = (MeasureCoords)songTrackCoords.getMeasuresCoords().get(n8);
            measureCoords.setPosX(n4);
            measureCoords.setPosY(n5);
            measureCoords.setScoreSpan(this.isScoreEnabled() ? this.getScoreSpan() : 0);
            measureCoords.setFirstOfLine(n3 == 0);
            if (bl2 && bl3) {
                this.paintMeasure(measureCoords, gC, n4 + n, n5, n7, rectangle);
            } else {
                measureCoords.setOutOfBounds(true);
            }
            if ((n4 += measureCoords.getWidth() + measureCoords.getSpan()) <= n6) continue;
            n6 = n4;
        }
        if (bl2 && bl3) {
            if (tempLine.fullLine) {
                this.paintStrings(songTrackCoords, gC, n, n5, n4);
            } else {
                n3 = this.getMaxWidth() - 15;
                n3 = n4 > n3 - 20 ? n4 : n3;
                this.paintStrings(songTrackCoords, gC, n, n5, n3);
            }
        }
        this.setWidth(n6 > this.getWidth() ? n6 : this.getWidth());
    }

    public void paintTracks(List list, GC gC, Rectangle rectangle, int n, int n2) {
        int n3 = n2 + this.getDefaultFirstTrackSpan();
        int n4 = this.getDefaultFirstTrackSpan();
        int n5 = 0;
        SongTrackCoords songTrackCoords = (SongTrackCoords)list.get(0);
        int n6 = songTrackCoords.getMeasuresCoords().size();
        int n7 = 0;
        while (n6 > n7) {
            TempLine tempLine = null;
            for (int i = 0; i < list.size(); ++i) {
                SongTrackCoords songTrackCoords2 = (SongTrackCoords)list.get(i);
                songTrackCoords2.checkPosX(n);
                tempLine = this.getTempLines(n, songTrackCoords2.getMeasuresCoords(), n7);
                this.setScoreSpan(DEFAULT_SCORE_SPAN);
                if (AUTO_SPACING_ENABLED && this.isScoreEnabled()) {
                    if (tempLine.minY < -30) {
                        n3 += Math.abs(tempLine.minY) - 30;
                        n4 += Math.abs(tempLine.minY) - 30;
                    }
                    if (tempLine.maxY + MIN_SCORE_TAB_SPAN > this.getScoreSpan()) {
                        this.setScoreSpan(this.getScoreSpan() + (tempLine.maxY + MIN_SCORE_TAB_SPAN - this.getScoreSpan()));
                    }
                }
                this.paintLine(songTrackCoords2, tempLine, gC, n, n3, rectangle);
                n5 = this.isScoreEnabled() ? DEFAULT_TRACK_SPAN + this.getScoreSpan() : DEFAULT_TRACK_SPAN;
                this.addTrackPosition((int)songTrackCoords2.getTrack().getNumber(), n3, n5);
                n3 += n5;
                n4 += n5;
                songTrackCoords2.setHeight(n5 > songTrackCoords2.getHeight() ? n5 : songTrackCoords2.getHeight());
                songTrackCoords2.setWidth(this.getWidth());
            }
            n7 = tempLine.lastIndex + 1;
        }
        this.setHeight(n4 + 100);
    }

    private class TempLine {
        private int tempWith;
        private int lastIndex;
        private boolean fullLine;
        private List measures = new ArrayList();
        private int maxY = 0;
        private int minY = 50;

        private TempLine() {
        }

        private void addMeasure(int n) {
            this.measures.add(n);
            this.lastIndex = n;
        }
    }
}

