/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.tab;

import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.tab.Caret;
import org.herac.tuxguitar.gui.tab.MeasureCoords;
import org.herac.tuxguitar.gui.tab.SongCoords;
import org.herac.tuxguitar.gui.tab.TablaturePaintListener;
import org.herac.tuxguitar.gui.tab.layout.ViewLayout;
import org.herac.tuxguitar.song.managers.SongManager;

public class Tablature
extends Composite {
    private SongManager songManager;
    private SongCoords songCoords;
    private Caret caret;
    private int width;
    private int height;
    private ViewLayout viewLayout;
    private Font defaultFont;
    private Font noteFont;
    private Font timeSignatureFont;
    private Font printerDefaultFont;
    private Font printerNoteFont;
    private Font printerTimeSignatureFont;
    private Color scoreNoteColor;
    private Color tabNoteColor;
    private Color playNoteColor;

    public Tablature(Composite composite, int n) {
        super(composite, n);
        this.setBackground(new Color((Device)this.getDisplay(), 255, 255, 255));
        this.loadFonts();
        this.loadColors();
    }

    public void initGUI() {
        this.addPaintListener(new TablaturePaintListener(this));
        final Point point = new Point(0, 0);
        final ScrollBar scrollBar = this.getHorizontalBar();
        scrollBar.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                int n = scrollBar.getSelection();
                int n2 = -n - point.x;
                Rectangle rectangle = Tablature.this.getClientArea();
                Tablature.this.getShell().scroll(n2, 0, 0, 0, rectangle.width, rectangle.height, false);
                point.x = -n;
                Tablature.this.redraw();
            }
        });
        final ScrollBar scrollBar2 = this.getVerticalBar();
        scrollBar2.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                int n = scrollBar2.getSelection();
                int n2 = -n - point.y;
                Rectangle rectangle = Tablature.this.getBounds();
                Tablature.this.getShell().scroll(0, n2, 0, 0, rectangle.width, rectangle.height, false);
                point.y = -n;
                Tablature.this.redraw();
            }
        });
        this.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent controlEvent) {
                Tablature.this.updateScroll();
            }
        });
    }

    public void initDefaults(ViewLayout viewLayout) {
        this.viewLayout = viewLayout;
        this.songCoords = new SongCoords(this, this.songManager);
        this.caret = new Caret(this, this.songManager, this.songCoords);
    }

    public void updateTablature() {
        this.getViewLayout().updateSong();
    }

    public void initCaret() {
        this.caret.update(1L, 1000L, 1);
    }

    public void loadFonts() {
        this.defaultFont = Tablature.getFont("FONT_DEFAULT");
        this.noteFont = Tablature.getFont("FONT_NOTE");
        this.timeSignatureFont = Tablature.getFont("FONT_TIME_SIGNATURE");
        this.printerDefaultFont = Tablature.getFont("FONT_PRINTER_DEFAULT");
        this.printerNoteFont = Tablature.getFont("FONT_PRINTER_NOTE");
        this.printerTimeSignatureFont = Tablature.getFont("FONT_PRINTER_TIME_SIGNATURE");
    }

    public void loadColors() {
        this.scoreNoteColor = Tablature.getColor("COLOR_SCORE_NOTE");
        this.tabNoteColor = Tablature.getColor("COLOR_TAB_NOTE");
        this.playNoteColor = Tablature.getColor("COLOR_PLAY_NOTE");
    }

    public void paintTablature(GC gC) {
        MeasureCoords measureCoords;
        if (this.songManager.getPlayer().isRunning() && (measureCoords = this.getCaret().getSongTrackCoords().getMeasureCoords(this.songManager.getPlayer().getTickPosition())) != null) {
            this.getViewLayout().followMeasure(measureCoords, false);
        }
        int n = this.getHorizontalBar().getSelection();
        int n2 = this.getVerticalBar().getSelection();
        this.getViewLayout().paintSong(gC, this.getClientArea(), -n, -n2);
        this.width = this.viewLayout.getWidth();
        this.height = this.viewLayout.getHeight();
        this.updateScroll();
        if (this.getCaret().hasChanges() && !this.songManager.getPlayer().isRunning()) {
            this.getCaret().setChanges(false);
            if (this.getCaret().getMeasureCoords() != null) {
                this.getViewLayout().followMeasure(this.getCaret().getMeasureCoords(), true);
            }
        }
    }

    public void updateScroll() {
        Rectangle rectangle = this.getBounds();
        Rectangle rectangle2 = this.getClientArea();
        ScrollBar scrollBar = this.getHorizontalBar();
        ScrollBar scrollBar2 = this.getVerticalBar();
        scrollBar.setMaximum(this.width + 22);
        scrollBar2.setMaximum(this.height);
        scrollBar.setThumb(Math.min(rectangle.width, rectangle2.width));
        scrollBar2.setThumb(Math.min(rectangle.height, rectangle2.height));
    }

    public void moveScrollHorizontalTo(MeasureCoords measureCoords, int n, int n2, boolean bl) {
        if (measureCoords != null) {
            int n3 = this.getHorizontalBar().getSelection();
            int n4 = this.getClientArea().width;
            int n5 = measureCoords.getPosX();
            int n6 = measureCoords.getWidth();
            if (n5 <= n3) {
                this.getHorizontalBar().setSelection(n5 - n);
                if (bl) {
                    this.redraw();
                }
            } else if (n5 + n6 >= n3 + n4) {
                this.getHorizontalBar().setSelection(n5 - n4 + n2);
                if (bl) {
                    this.redraw();
                }
            }
        }
    }

    public void moveScrollVerticalTo(MeasureCoords measureCoords, int n, int n2, boolean bl) {
        if (measureCoords != null) {
            int n3 = this.getVerticalBar().getSelection();
            int n4 = this.getClientArea().height;
            int n5 = measureCoords.getPosY();
            int n6 = measureCoords.getTabHeight() + measureCoords.getScoreSpan();
            if (n5 + n3 <= n3) {
                this.getVerticalBar().setSelection(n3 + n5 - n);
                if (bl) {
                    this.redraw();
                }
            } else if (n5 + n6 + n3 >= n3 + n4) {
                this.getVerticalBar().setSelection(n3 + (n4 - (n4 - (n5 - n6))) - n2);
                if (bl) {
                    this.redraw();
                }
            }
        }
    }

    public Font getDefaultFont() {
        return this.defaultFont;
    }

    public Font getNoteFont() {
        return this.noteFont;
    }

    public Font getTimeSignatureFont() {
        return this.timeSignatureFont;
    }

    public Font getPrinterDefaultFont() {
        return this.printerDefaultFont;
    }

    public Font getPrinterNoteFont() {
        return this.printerNoteFont;
    }

    public Font getPrinterTimeSignatureFont() {
        return this.printerTimeSignatureFont;
    }

    public Color getPlayNoteColor() {
        return this.playNoteColor;
    }

    public Color getScoreNoteColor() {
        return this.scoreNoteColor;
    }

    public Color getTabNoteColor() {
        return this.tabNoteColor;
    }

    public void redraw() {
        if (!super.isDisposed()) {
            super.redraw();
        }
    }

    public void resetScroll() {
        this.getHorizontalBar().setSelection(0);
        this.getVerticalBar().setSelection(0);
    }

    public Caret getCaret() {
        return this.caret;
    }

    public SongManager getSongManager() {
        return this.songManager;
    }

    public void setSongManager(SongManager songManager) {
        this.songManager = songManager;
    }

    public SongCoords getSongCoords() {
        return this.songCoords;
    }

    public void changeCursor(int n) {
        this.setCursor(new Cursor((Device)this.getDisplay(), n));
    }

    public ViewLayout getViewLayout() {
        return this.viewLayout;
    }

    public void setViewLayout(ViewLayout viewLayout) {
        this.viewLayout = viewLayout;
        this.getHorizontalBar().setSelection(0);
        this.getVerticalBar().setSelection(0);
    }

    public void reloadConfig(ViewLayout viewLayout) {
        this.disposeGraphics();
        this.loadFonts();
        this.loadColors();
        this.setViewLayout(viewLayout);
    }

    private static final Font getFont(String string) {
        FontData fontData = TuxGuitar.instance().getConfig().getFontDataConfigValue(string);
        if (fontData == null) {
            fontData = new FontData();
        }
        return new Font((Device)TuxGuitar.instance().getDisplay(), fontData);
    }

    private static final Color getColor(String string) {
        RGB rGB = TuxGuitar.instance().getConfig().getRGBConfigValue(string);
        if (rGB == null) {
            rGB = new RGB(0, 0, 0);
        }
        return new Color((Device)TuxGuitar.instance().getDisplay(), rGB);
    }

    public void dispose() {
        super.dispose();
        this.disposeGraphics();
    }

    public void disposeGraphics() {
        this.defaultFont.dispose();
        this.noteFont.dispose();
        this.timeSignatureFont.dispose();
        this.printerDefaultFont.dispose();
        this.printerNoteFont.dispose();
        this.printerTimeSignatureFont.dispose();
        this.scoreNoteColor.dispose();
        this.tabNoteColor.dispose();
        this.playNoteColor.dispose();
    }
}

