/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.tab;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.herac.tuxguitar.gui.tab.MeasureCoords;
import org.herac.tuxguitar.gui.tab.QuarterSpanHelper;
import org.herac.tuxguitar.gui.tab.Tablature;
import org.herac.tuxguitar.gui.tab.layout.ViewLayout;
import org.herac.tuxguitar.song.managers.SongManager;
import org.herac.tuxguitar.song.models.Measure;
import org.herac.tuxguitar.song.models.SongTrack;

public class SongTrackCoords {
    public static final int DEFAULT_HORIZONTAL_SPAN = 20;
    private Tablature tablature;
    private SongManager songManager;
    private SongTrack track;
    private List measuresCoords;
    private int posX;
    private int posY;
    private int width;
    private int height;

    public SongTrackCoords(Tablature tablature, SongManager songManager, SongTrack songTrack) {
        this.tablature = tablature;
        this.track = songTrack;
        this.songManager = songManager;
        this.measuresCoords = new ArrayList();
        this.posX = 20;
    }

    public void fireChanges(ViewLayout viewLayout, int n, QuarterSpanHelper quarterSpanHelper, boolean bl) {
        MeasureCoords measureCoords = null;
        if (bl) {
            Measure measure = (Measure)this.track.getMeasures().get(n);
            measureCoords = new MeasureCoords(this.songManager, this.tablature, measure, this);
            this.getMeasuresCoords().add(measureCoords);
        } else {
            measureCoords = (MeasureCoords)this.getMeasuresCoords().get(n);
        }
        measureCoords.create(viewLayout);
        quarterSpanHelper.setQuarterSpan(measureCoords.getQuarterSpan());
    }

    public void fireUpdate(ViewLayout viewLayout, int n, QuarterSpanHelper quarterSpanHelper) {
        MeasureCoords measureCoords = (MeasureCoords)this.getMeasuresCoords().get(n);
        measureCoords.setQuarterSpan(this.tablature.getViewLayout().getQuarterSpan(quarterSpanHelper, measureCoords));
        int n2 = measureCoords.getWidth();
        this.width -= n2;
        measureCoords.update(viewLayout);
        this.width += measureCoords.getWidth();
    }

    public void checkPosX(int n) {
        this.posX = 20;
        if (n <= -this.posX) {
            this.posX = 0;
        }
    }

    public void paintTrack(ViewLayout viewLayout, GC gC, int n, int n2, Rectangle rectangle) {
        this.checkPosX(n);
        viewLayout.paintMeasures(this, this.measuresCoords, gC, n, n2, rectangle);
    }

    public List getMeasuresCoords() {
        return this.measuresCoords;
    }

    public SongTrack getTrack() {
        return this.track;
    }

    public MeasureCoords getFirstMeasure() {
        MeasureCoords measureCoords = null;
        for (int i = 0; i < this.measuresCoords.size(); ++i) {
            MeasureCoords measureCoords2 = (MeasureCoords)this.measuresCoords.get(i);
            if (measureCoords != null && measureCoords2.getMeasure().getStart() >= measureCoords.getMeasure().getStart()) continue;
            measureCoords = measureCoords2;
        }
        return measureCoords;
    }

    public MeasureCoords getLastMeasure() {
        int n = this.measuresCoords.size() - 1;
        return (MeasureCoords)this.measuresCoords.get(n);
    }

    public MeasureCoords getPrevMeasure(MeasureCoords measureCoords) {
        int n = measureCoords.getMeasure().getNumber() - 1;
        int n2 = n - 1;
        if (n2 >= 0) {
            return (MeasureCoords)this.measuresCoords.get(n2);
        }
        return null;
    }

    public MeasureCoords getNextMeasure(MeasureCoords measureCoords) {
        int n = measureCoords.getMeasure().getNumber() + 1;
        int n2 = n - 1;
        if (n2 < this.measuresCoords.size()) {
            return (MeasureCoords)this.measuresCoords.get(n2);
        }
        return null;
    }

    public MeasureCoords getMeasureCoords(long l) {
        Object var3_2 = null;
        for (int i = 0; i < this.measuresCoords.size(); ++i) {
            MeasureCoords measureCoords = (MeasureCoords)this.measuresCoords.get(i);
            long l2 = measureCoords.getMeasure().getStart();
            long l3 = measureCoords.getMeasure().getLength();
            if (l < l2 || l >= l2 + l3) continue;
            return measureCoords;
        }
        return null;
    }

    public MeasureCoords getMeasure(Measure measure) {
        MeasureCoords measureCoords = null;
        for (int i = 0; i < this.measuresCoords.size(); ++i) {
            MeasureCoords measureCoords2 = (MeasureCoords)this.measuresCoords.get(i);
            if (!measureCoords2.getMeasure().equals(measure)) continue;
            measureCoords = measureCoords2;
            break;
        }
        return measureCoords;
    }

    public MeasureCoords getMeasureAt(int n, int n2, int n3, int n4) {
        MeasureCoords measureCoords = null;
        long l = this.posX + n3;
        int n5 = this.tablature.getViewLayout().getStringSpan();
        for (MeasureCoords measureCoords2 : this.measuresCoords) {
            boolean bl;
            int n6 = measureCoords2.getTabHeight() + measureCoords2.getScoreSpan();
            boolean bl2 = (long)n >= l + (long)measureCoords2.getPosX() && (long)n <= l + (long)measureCoords2.getPosX() + (long)measureCoords2.getWidth() + (long)measureCoords2.getSpan();
            boolean bl3 = bl = n2 + n5 >= measureCoords2.getPosY() && n2 - n5 <= measureCoords2.getPosY() + n6;
            if (!bl2 || !bl) continue;
            measureCoords = measureCoords2;
            break;
        }
        return measureCoords;
    }

    public boolean hasCaret() {
        return this.equals(this.tablature.getCaret().getSongTrackCoords());
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int n) {
        this.height = n;
    }

    public int getPosX() {
        return this.posX;
    }

    public void setPosX(int n) {
        this.posX = n;
    }

    public int getPosY() {
        return this.posY;
    }

    public void setPosY(int n) {
        this.posY = n;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int n) {
        this.width = n;
    }
}

