/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.tab;

import org.herac.tuxguitar.gui.tab.MeasureCoords;
import org.herac.tuxguitar.gui.tab.NoteCoords;
import org.herac.tuxguitar.gui.tab.layout.ViewLayout;

public class ScoreBeatHelper {
    private static final int[] SCORE_MIDDLE_KEYS = new int[]{60, 40, 40, 50};
    private static final int[] SCORE_SHARP_POSITIONS = new int[]{7, 7, 6, 6, 5, 4, 4, 3, 3, 2, 2, 1};
    private static final int[] SCORE_FLAT_POSITIONS = new int[]{7, 6, 6, 5, 5, 4, 3, 3, 2, 2, 1, 1};
    public static final int DIRECTION_UP = 1;
    public static final int DIRECTION_DOWN = 2;
    private int direction = 1;
    private NoteCoords firstMinNote = null;
    private NoteCoords firstMaxNote = null;
    private NoteCoords lastMinNote = null;
    private NoteCoords lastMaxNote = null;
    private NoteCoords maxNote = null;
    private NoteCoords minNote = null;

    public void check(NoteCoords noteCoords, int n) {
        int n2;
        int n3;
        int n4 = noteCoords.getRealValue();
        if (this.firstMinNote == null || noteCoords.getStart() < this.firstMinNote.getStart()) {
            this.firstMinNote = noteCoords;
        } else if (noteCoords.getStart() == this.firstMinNote.getStart() && noteCoords.getRealValue() < this.firstMinNote.getRealValue()) {
            this.firstMinNote = noteCoords;
        }
        if (this.firstMaxNote == null || noteCoords.getStart() < this.firstMaxNote.getStart()) {
            this.firstMaxNote = noteCoords;
        } else if (noteCoords.getStart() == this.firstMaxNote.getStart() && noteCoords.getRealValue() > this.firstMaxNote.getRealValue()) {
            this.firstMaxNote = noteCoords;
        }
        if (this.lastMinNote == null || noteCoords.getStart() > this.lastMinNote.getStart()) {
            this.lastMinNote = noteCoords;
        } else if (noteCoords.getStart() == this.lastMinNote.getStart() && noteCoords.getRealValue() < this.lastMinNote.getRealValue()) {
            this.lastMinNote = noteCoords;
        }
        if (this.lastMaxNote == null || noteCoords.getStart() > this.lastMaxNote.getStart()) {
            this.lastMaxNote = noteCoords;
        } else if (noteCoords.getStart() == this.lastMaxNote.getStart() && noteCoords.getRealValue() > this.lastMaxNote.getRealValue()) {
            this.lastMaxNote = noteCoords;
        }
        if (this.maxNote == null || n4 > this.maxNote.getRealValue()) {
            this.maxNote = noteCoords;
        }
        if (this.minNote == null || n4 < this.minNote.getRealValue()) {
            this.minNote = noteCoords;
        }
        this.direction = (n3 = Math.abs(this.minNote.getRealValue() - (SCORE_MIDDLE_KEYS[n - 1] + 100))) > (n2 = Math.abs(this.maxNote.getRealValue() - (SCORE_MIDDLE_KEYS[n - 1] - 100))) ? 1 : 2;
    }

    public int getY1(ViewLayout viewLayout, NoteCoords noteCoords, int n, int n2) {
        double d = (double)viewLayout.getScoreLineSpan() / 2.0;
        int n3 = noteCoords.getRealValue();
        int n4 = 0;
        n4 = n <= 7 ? (int)((double)SCORE_SHARP_POSITIONS[n3 % 12] * d - (double)(7 * (n3 / 12)) * d) : (int)((double)SCORE_FLAT_POSITIONS[n3 % 12] * d - (double)(7 * (n3 / 12)) * d);
        n4 = (int)((double)n4 + (double)MeasureCoords.SCORE_KEY_OFFSETS[n2 - 1] * d);
        return n4;
    }

    public int getY2(ViewLayout viewLayout, int n, int n2, int n3) {
        int n4;
        int n5 = 10;
        if (this.direction == 2) {
            int n6;
            if (this.minNote != this.firstMinNote && this.minNote != this.lastMinNote) {
                return this.getY1(viewLayout, this.minNote, n2, n3) + 35;
            }
            int n7 = this.firstMinNote.getPosX() + this.firstMinNote.getSpan();
            int n8 = this.lastMinNote.getPosX() + this.lastMinNote.getSpan();
            int n9 = this.getY1(viewLayout, this.firstMinNote, n2, n3) + 35;
            if (n9 > (n6 = this.getY1(viewLayout, this.lastMinNote, n2, n3) + 35) && n9 - n6 > n5) {
                n6 = n9 - n5;
            }
            if (n6 > n9 && n6 - n9 > n5) {
                n9 = n6 - n5;
            }
            int n10 = (int)(((double)n9 - (double)n6) / ((double)n7 - (double)n8) * ((double)n7 - (double)n));
            return n9 - n10;
        }
        if (this.maxNote != this.firstMaxNote && this.maxNote != this.lastMaxNote) {
            return this.getY1(viewLayout, this.maxNote, n2, n3) - 28;
        }
        int n11 = this.firstMaxNote.getPosX() + this.firstMaxNote.getSpan();
        int n12 = this.lastMaxNote.getPosX() + this.lastMaxNote.getSpan();
        int n13 = this.getY1(viewLayout, this.firstMaxNote, n2, n3) - 28;
        if (n13 < (n4 = this.getY1(viewLayout, this.lastMaxNote, n2, n3) - 28) && n4 - n13 > n5) {
            n4 = n13 + n5;
        }
        if (n4 < n13 && n13 - n4 > n5) {
            n13 = n4 + n5;
        }
        int n14 = (int)(((double)n13 - (double)n4) / ((double)n11 - (double)n12) * ((double)n11 - (double)n));
        return n13 - n14;
    }

    public int getDirection() {
        return this.direction;
    }
}

